//course builder page functions starts
$(document).on("change", ".form-check-input[type='radio']", function() {
    $(".js-quiz-select").has(".form-check-input").removeClass("bg-active");
    if ($(this).prop("checked")) {
        $(this).parent().addClass('bg-active');
    }
})

$(document).on("change", ".form-check-input[type='checkbox']", function() {
    if(this.checked){
        $(this).parent().addClass('bg-active');
    }
    else{
        $(this).parent().removeClass('bg-active');
    }
})
function loadAllVideo(){
    $("[id^='video']").each(function(){
        var videoUrl = $(this).attr('data-video'); 
        var currentVideoId = $(this).attr('id');
        if(videoUrl !== undefined){
            $.ajax({
                type: "post",
                url: videorender,
                data: {"url":videoUrl},
                beforeSend: function (xhr) {
                    xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                },
                success: function (data) {
                    $("#"+currentVideoId).html(data);
                    if( $('#lessonview').length){
                        var iframe = $("#"+currentVideoId).find('iframe');
                        if (videoUrl.includes('vimeo.com')) {
                            const vimeoPlayer = new Vimeo.Player(iframe);
                            vimeoPlayer.on('play', function() {
                            console.log('Vimeo video started playing.');
                            clearTimeout(idleTimer);
                                if (!isActive) {
                                    clearInterval(interval);
                                    isActive = true;
                                    interval = setInterval(function() { startTimer(); }, 1000);
                                }
                            });

                            vimeoPlayer.on('pause', function() {
                            console.log('Vimeo video paused.');
                                if($('.idletimeflag').html() == '1'){
                                    if(!isAnyAudioPlaying()){
                                        idleTimer = setTimeout(function() {
                                            isActive = false;
                                            inactiveTime = 0;
                                        }, 2000); // Set idle time threshold in milliseconds (e.g., 20 seconds)
                                    }
                                }
                            });
                        }
                    }
                },
                error: function(xhr){
                    console.log(xhr.status);
                    $(window).off('beforeunload');
                    if(xhr.status == 401 || xhr.status == 419){
                        window.location = login_url;
                    }
                }
            });      
        }
        
    });
                
}
loadAllVideo();

if($("[id^='submit-button-']").length ){
    $("[id^='submit-button-']").each(function(){
        $(this).prop('disabled', true);
    });
}

$(document).on("change","input[name^='optradio']",function(){
    var blockid = $(this).attr('name').replace('optradio','');  
    $('#submit-button-'+blockid).prop('disabled', false);
});

$(document).on("change","input[id^='radio']",function(){
    var blockid = $(this).parent().parent().attr('id').replace('answer-buttons-',''); 
    if($("input[id^='radio']:checked").length == 0){
        $('#submit-button-'+blockid).prop('disabled', true);
    }
    else{
        $('#submit-button-'+blockid).prop('disabled', false);
    }
});

//quiz submission call start
$(document).on("click","[id^='submit-button-']",function(){
    lessonclick = false;
    $(this).hide();
    var blockid = $(this).attr('id').replace('submit-button-','');
    var id = $(this).closest("form").find('input[name="id"]').val();
    if(id  == undefined){
        id  = blockid;
    }
    var submitAnswer = $(this).closest("form").find('input[name="optradio'+blockid+'"]:checked').val();
    if(submitAnswer == undefined){
        var selectedAns = [];
        $(this).closest("form").find('input[name="optcheckbox'+blockid+'[]"]:checked').each(function() {
            selectedAns.push($(this).val());
         });
        submitAnswer = JSON.stringify(selectedAns);
    }
    var resEle = $(this).parent(); 
    $.ajax({
        type: "post",
        url: submit_quiz_url,
        data: { "id": id ,'submitanswer': submitAnswer },
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        success: function (data) {
            data = $.parseJSON(data);
            if( $('#lessonview').length){
                $('.lesson_progress_bar').css('width',data.enroldata.progress+'%');
                $('.lesson_progress').html(Math.round(data.enroldata.progress));               
            }
            if($('#resELe').length){ $('#resELe').remove(); }
            var html = "<div>";
            if (data.status == "success") {
                html +=
                    '<figure class="correct-answer"><svg xmlns="http://www.w3.org/2000/svg" height="48" viewBox="0 96 960 960" width="48"><path d="M378 810 154 586l43-43 181 181 384-384 43 43-427 427Z"/></svg></figure>';
                html +=
                    '<span class="text-success">' + data.message + "</span>";
            } else {
                html +=
                    '<figure class="wrong-answer text-danger"><svg xmlns="http://www.w3.org/2000/svg" height="48" viewBox="0 96 960 960" width="48"><path d="m249 849-42-42 231-231-231-231 42-42 231 231 231-231 42 42-231 231 231 231-42 42-231-231-231 231Z"/></svg></figure>';
                html += '<span class="text-danger">' + data.message + "</span>";
            }
            html += "</div>";
            if( $('#lessonview').length){
                //apply check mark on lesson sidebar
                if(data.lessonid !== undefined){
                    $(".js-list-lesson").each(function(){
                        if($(this).attr('data-lessonid') == data.lessonid) {
                            var oldsrc = $(this).find('img').attr('src');
                            if(data.answer_status == 'incorrect'){
                                var newsrc = oldsrc.replace('course-uncheckd','course-cancel');
                            }
                            else{
                                var newsrc = oldsrc.replace('course-uncheckd','check-green-success');
                            }
                            $(this).find('img').attr('src',newsrc).addClass('completed').addClass(data.answer_status);
                        }
                    });                    
                }
            }
            else{         
            html +=
            '<div class="take-again"><a href="javascript:void(0)" class="btn btn-outline-secondary font-weight-bold w-auto" title="takeagain" id="takeagain" data-blockid="' + blockid +'">Reset</a></div>';
            }
            $(resEle).append('<div id="resELe">' + html + "</div>");
            if($("#answer-buttons-"+blockid).hasClass('js-quiz2')){
                var correct_answer = $.parseJSON(data.rightanswer);
                
                $("#answer-buttons-"+blockid).find('.form-check-input').each(function(){
                    var value = $(this).attr('value');

                    if(data.rightanswer != '' && $.inArray(value, selectedAns) != -1 && $.inArray(value, correct_answer) != -1){
                        $(this).removeClass('incorrect').addClass('correct');
                        $(this).parent().removeClass('incorrect').addClass('correct');
                    }
                    else if($.inArray(value, selectedAns) != -1){
                        $(this).removeClass('correct').addClass('incorrect');
                        $(this).parent().removeClass('correct').addClass('incorrect');
                    }
                    $(this).prop('disabled', true);
                });
            }
            else{
                $("#answer-buttons-"+blockid).find('.form-check-input').each(function(){
                    var value = $(this).attr('value');
                    if(data.rightanswer != '' && value == submitAnswer && value == data.rightanswer){
                        $(this).removeClass('incorrect').addClass('correct');
                        $(this).parent().removeClass('incorrect').addClass('correct');
                    }
                    else if(value == submitAnswer){
                        $(this).removeClass('correct').addClass('incorrect');
                        $(this).parent().removeClass('correct').addClass('incorrect');
                    }
                    $(this).prop('disabled', true);
                });
            }
            if( $('#lessonview').length){
                if(data.lessonid !== undefined){
                    if($('[data-lessonid="' + data.lessonid + '"]').hasClass('last')){
                        $('.continue-btn').addClass('d-none').find('button').prop('disabled', true);
                        if(data.enroldata.progress == 100 || data.enroldata.progress == 99){
                            $('.finish-btn').removeClass('d-none').find('button').prop('disabled', false);
                        }
                        
                        if( $('.completedlesson').length == ($(".js-list-lesson").length-1)){
                            $('.finish-btn').removeClass('d-none').find('button').prop('disabled', false);
                        }
                    }
                    else{
                        if($("#resELe").length){
                            $('.continue-btn').removeClass('d-none').find('button').prop('disabled', false);
                        }
                    }
                }
            }
        },
        error: function(xhr){
            console.log(xhr.status);
            if(xhr.status == 401 || xhr.status == 419){
                window.location = login_url;
            }
        }
    });  
});
//quiz submission call end

$(document).on('click','#takeagain',function(){
    var blockid = $(this).data('blockid');
    $('#submit-button-'+blockid).show();
    if($('#resELe').length){ $('#resELe').remove(); }
    $("#answer-buttons-"+blockid).find('.form-check-input').each(function(){
        $(this).removeClass('incorrect').removeClass('correct');
        $(this).parent().removeClass('incorrect').removeClass('correct').removeClass('bg-active');
        $(this).prop('checked', false);
        $(this).prop('disabled', false);
    });
});

//media contents functions
$(document).on("change", ".js-media-assets", function () {
    var folder = $(this).attr("folder");    

    control = $("#lesson-audio")
        .find(".js-lesson-control");
        
    formData = new FormData();
    formData.append("file", $(this)[0].files[0]);
    formData.append("folder", folder);
    formData.append("size", $(this).attr("size"));
    formData.append("lessonid", $(this).attr("lesson"));
    formData.append("extension", $(this).attr("extension"));
    if(media_upload_url != '') {
        $.ajax({
            url: media_upload_url,
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            dataType: "json",
            beforeSend: function (xhr) {
                xhr.setRequestHeader("X-CSRF-Token", csrf_token);
            },
            success: function (response) {
                $('#media_error').addClass('d-none').html('')
                if(folder == 'media_audio'){
                    $("#lesson-audio").removeClass('d-none')
                    .find("source")
                    .attr("src", response.location);
                    if( $("#lesson-audio")){
                        control[0].pause();
                        control[0].load();
                    }
                } 
                
                $('#js-media-popup').modal('hide');
                if(folder == 'media_audio'){
                    $('[data-model="audio"]').removeClass('fill-active').addClass('fill-active');
                }
                else if(folder == 'media_video') {
                    $('[data-model="video"]').removeClass('fill-active').addClass('fill-active');
                }
                else if(folder == 'media_image'){
                    $('[data-model="image"]').removeClass('fill-active').addClass('fill-active');
                }
                
                $.ajax({
                    type: "get",
                    url: media_popup_refresh,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                    },
                    success: function (data) {
                        $('#mediablockpopup').html(data);
                        if(folder == 'media_document'){
                            $('.media-model').addClass('d-none');
                            $('#document').removeClass('d-none');
                            $('#js-media-popup').modal('show');
                            $('[data-model="document"]').removeClass('fill-active').addClass('fill-active').find('a').removeClass('active').addClass('active');
                        }
                    },
                });
            },
            error: function (response) {
               
                    if(response.status == 401 || response.status == 419){
                        window.location = login_url;
                    }
                if (typeof response.responseJSON.errors.file != "undefined") {
                    var error_message = "";
                    $.each(
                        response.responseJSON.errors.file,
                        function (index, value) {
                            error_message += value + "<br/>";
                        }
                    );
                    $('#js-media-popup').modal('show');
                    $('#media_error').removeClass('d-none').html(error_message);
                    
                }
            },
        });
    }
    
});

function popUpImg(){
var popupImages = $('body').find('[id^="js-block-"]').find('img');
popupImages.each(function(){
    $(this).attr('data-mfp-src', $(this).attr('src')).addClass("magnific-thumbnail");
});
popupImages.magnificPopup({type: 'image'});
}
popUpImg();
$('body').on('click','.model-link',function(){
    $('#media_error').addClass('d-none').html('');
    if($('[name="media_audio"]').length){
        $('[name="media_audio"]').val("");
    }
    if($('[name="media_document"]').length){
        $('[name="media_document"]').val("");
    }
    if($('[name="media_image"]').length){
        $('[name="media_image"]').val("");
    }
    $('.media-model').addClass('d-none');
    var model = $(this).attr('data-model');
    $('#'+model).removeClass('d-none');
    var preview = false;
    if($('#exit-preview').length || $('#lessonview').length){
        preview = true;
    }
    if(preview && model == 'audio'){
        if($("#lesson-audio").hasClass('d-none')){
            $("#lesson-audio").removeClass('d-none');
        }
        else{
            $("#lesson-audio").find('audio').trigger('pause');
            $("#lesson-audio").addClass('d-none');
        }
        
    }
    else if(preview && model == 'video'){
        $('#js-media-popup').modal('show');
        var videoUrl = $('#media_video_render').attr('data-url'); 
        if(videoUrl !== undefined){
            $.ajax({
                type: "post",
                url: videorender,
                data: {"url":videoUrl,"media":'yes'},
                beforeSend: function (xhr) {
                    xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                },
                success: function (data) {
                    $("#media_video_render").html(data);
                },
                error: function(xhr){
                    console.log(xhr.status);
                    if(xhr.status == 401 || xhr.status == 419){
                        window.location.href = login_url;
                    }
                }
            });      
        }
    }
    else if(preview && model == 'image'){
        var src = $('#image').find('img').attr('src');
        $.magnificPopup.open({
            items: {
              src: src
            },
            type: 'image' // this is default type
        });
    }
    else{
        $('#js-media-popup').modal('show');
    }
    
});

$(document).on('hidden.bs.modal', '#js-media-popup', function() {
    if($("#media_video_render").length){
        $("#media_video_render").find('iframe').attr("src", $("#media_video_render").find('iframe').attr("src"));
    }
  });

if($('#exit-preview').length || $('#lessonview').length){
    if($('.js-inline-editor').length){
        $(".js-inline-editor").each(function(){
            $(this).removeAttr('contenteditable');
        });
    }
    if($('audio').length){
        $('audio').each(function(){
            $(this).attr('controlsList',"nodownload");
        });
    }
    if($('video').length){
        $('video').each(function(){
            $(this).attr('controlsList',"nodownload");
        });
    }
    if($('.accordion-item').length){
        $('.accordion-item').each(function(){
            $(this).find('.accordion-button').attr('aria-expanded',false);
            $(this).find('.accordion-collapse ').removeClass('show');
        });
    }
}
//media contents functions end
// course builder page functions ends

//front end course view page functions start
function getLessonView(lessonId){
    if(lessonId == 0){
        return;
    }
    else{
        lessonclick = true;
        $('body').scrollTop(0);
        var url = lesson_view_url;
        $.ajax({
            url: url.replace('lessonId',lessonId),
            type: 'GET',
            beforeSend: function (xhr) {
                    xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                },
            success: function(data) {
                $('#lessonview').html(data);
                //submited quiz
                if($('.submited-quiz-answer').length){
                    var data = {id: $('.submited-quiz-answer').attr('quizId'), submitanswer: $('.submited-quiz-answer').html() }
                   // console.log(data,'#submit-button-'+$('.submited-quiz-answer').attr('quizId'));
                    if($("#answer-buttons-"+data.id).hasClass('js-quiz2')){
                        var submited_answer = $.parseJSON(data.submitanswer);
                        
                        $('input[type="checkbox"][name="optcheckbox'+ data.id + '[]"]').each(function() {
                            var checkboxValue = $(this).val();
                            if (submited_answer.includes(checkboxValue)) {
                                $(this).prop('checked', true).parent().addClass('bg-active');
                            }
                        });
                    } else {
                        $('input[type="radio"][name="optradio'+ $('.submited-quiz-answer').attr('quizId') + '"]').filter(function() {
                            return $(this).val() === $('.submited-quiz-answer').html();
                        }).prop('checked', true).parent().addClass('bg-active');
                    }
                    $('#submit-button-'+$('.submited-quiz-answer').attr('quizId')).removeAttr('disabled').trigger('click');
                    $('#submit-button-'+$('.submited-quiz-answer').attr('quizId')).prop('disabled', true);
                }
                else{
                    if($('[data-blocktype="quiz1"]').length == 0 && $('[data-blocktype="quiz2"]').length == 0){
                        $('.continue-btn').removeClass('d-none').find('button').prop('disabled', false);
                    }
                }
                $('.lesson_index').html("01");
                    if($(".js-list-lesson").length){
                        $(".js-list-lesson").removeClass('active');
                        $(".js-list-lesson").each(function(){
                            if($(this).attr('data-lessonid') == lessonId) {
                                $(this).addClass('active');
                                numberstring = $(this).attr('data-index') ;
                                $('.lesson_index').html((numberstring.length === 1) ? '0' + numberstring : numberstring);
                                if($(this).attr('data-index') == $(".js-list-lesson").length)
                                {
                                    $('.continue-btn').addClass('d-none').find('button').prop('disabled', true);
                                    if(($('[data-blocktype="quiz1"]').length == 0 && $('[data-blocktype="quiz2"]').length == 0 && $('.lesson_progress').html() == '100') || ($('[data-blocktype="quiz1"]').length == 0 && $('[data-blocktype="quiz2"]').length == 0 && $('.lesson_progress').html() == '99')){
                                        $('.finish-btn').removeClass('d-none').find('button').prop('disabled', false);
                                    }
                                    if($('[data-blocktype="quiz1"]').length == 0 && $('[data-blocktype="quiz2"]').length == 0 && $('.completedlesson').length == ($(".js-list-lesson").length-1)){
                                        $('.finish-btn').removeClass('d-none').find('button').prop('disabled', false);
                                    }
                                }
                                if($(this).attr('data-index') == 1){
                                    $('.previous-btn').addClass('d-none').find('button').prop('disabled', true);
                                }
                                else{
                                    $('.previous-btn').removeClass('d-none').find('button').prop('disabled', false);
                                }
                            }
                            if($(this).find('img').hasClass('completed')){
                                $(this).addClass('completedlesson');
                            }
                        });
                    }
                //submited quiz
                loadAllVideo();
                afterLessonView();
            },
            error: function(xhr, status, error){
                console.log(xhr.status);
                if(xhr.status == 401 || xhr.status == 419){
                    window.location = login_url;
                }
            }
        });
    }
}

$(document).on("click",".js-list-lesson", function(){
  var lessonid = $(this).data('lessonid');
  if($(this).hasClass('active')){
    // lesson already displayed
  }
  else{
    if($(this).parent().hasClass('ordering-lesson')){
        if($(this).find('img').hasClass('completed')){
            getLessonView(lessonid);
        }
    }
    else{
        getLessonView(lessonid);
    }
  }
})

function afterLessonView(){
    var totallesson = $('.js-list-lesson').length.toString();
  $('.total_lesson_cnt').html((totallesson.length === 1) ? '0' + totallesson : totallesson);
  if($('.js-inline-editor').length){
        $(".js-inline-editor").each(function(){
            $(this).removeAttr('contenteditable');
        });
    }
    if($('audio').length){
        $('audio').each(function(){
            $(this).attr('controlsList',"nodownload");
        });
    }
    if($('video').length){
        $('video').each(function(){
            $(this).attr('controlsList',"nodownload");
        });
    }
    if($('.js-configuration-data').length){
      $('.js-configuration-data').each(function(){
            $(this).remove();
      });
    }
    if($('.js-course-block-id').length){
      $('.js-course-block-id').each(function(){
            $(this).remove();
      });
    }
    popUpImg();
    if($('.accordion-item').length){
        $('.accordion-item').each(function(){
            $(this).find('.accordion-button').attr('aria-expanded',false);
            $(this).find('.accordion-collapse ').removeClass('show');
        });
    }
    sendActiveTime();
}

$('body').on('click','.finish-btn',function(){
    isActive = false;
    lessonclick = false;
    sendActiveTime();
    var ele = $(this);
    setTimeout(function(){
        var course_id = $('[data-courseid]').attr('data-courseid');
        var lesson_id = $(ele).attr('id').replace('lessonfinish-','');
        var url = $(ele).data('url');
        $.ajax({
            url: url,
            type: "get",
            data: "course_id="+course_id+"&lesson_id="+lesson_id,
            success: function (response) {
                $("#result-model-content").html(response.html);
                $('.lesson_progress_bar').css('width',response.enrolData.progress+'%');
                $('.lesson_progress').html(Math.round(response.enrolData.progress));
                if($('.redirection').length && response.enrolData.progress == 100){
                    window.location.replace($('.redirection').attr('data-action'));
                }
            },
            error: function(xhr){
                console.log(xhr.status);
                $(window).off('beforeunload');
                if(xhr.status == 401 || xhr.status == 419){
                    window.location.href = login_url;
                }
            }
        });
    },2000,ele);
    
});

function formatTime(seconds) {
    var hours = Math.floor(seconds / 3600);
    var minutes = Math.floor((seconds % 3600) / 60);
    var remainingSeconds = seconds % 60;

    var formattedTime = hours + "hrs, " + minutes + "mins, " + remainingSeconds + "secs";
    return formattedTime;
}

// security question pop up
function securityQuestionPopup(course_id){
    $('#security-question-model').modal({backdrop: 'static', keyboard: false},'show');
    var url = course_question_url;
    $.ajax({
        url: url,
        type: "get",
        data: "course_id="+course_id,
        success: function (response) {
            $("#security-question-content").html(response);
            $('.js-dashbtn').removeClass('d-none').addClass('d-none');
        },
        error: function(xhr){
            console.log(xhr.status);
            $(window).off('beforeunload');
            if(xhr.status == 401 || xhr.status == 419){
                window.location.href = login_url;
            }
        }
    });
}

$(document).on("click","[id^='lessoncontinue-']",function(){
    lessonclick = true;
    var lessonId = $(this).attr('id').replace('lessoncontinue-','');
    var course = $('[data-courseid]').attr('data-courseid');
    $.ajax({
        type: "post",
        url: submit_lesson_url,
        data: { "lesson": lessonId ,'course': course },
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        success: function (data) {
            data = $.parseJSON(data);  
            $('.lesson_progress_bar').css('width',data.enroldata.progress+'%');
            $('.lesson_progress').html(Math.round(data.enroldata.progress));                     
            if( $('#lessonview').length){
                //apply check mark on lesson sidebar
                if(data.lessonid !== undefined){
                    $(".js-list-lesson").each(function(){
                        if($(this).attr('data-lessonid') == data.lessonid) {
                            var oldsrc = $(this).find('img').attr('src');
                            if(data.answer_status == 'incorrect'){
                                var newsrc = oldsrc.replace('course-uncheckd','course-cancel');
                            }
                            else{
                                var newsrc = oldsrc.replace('course-uncheckd','check-green-success');
                            }
                            $(this).find('img').attr('src',newsrc).addClass('completed').addClass(data.answer_status);
                        }
                    });                    
                }
                $('#lesson_status').html();
            }
          
            if( $('#lessonview').length){
                if(data.lessonid !== undefined){
                    if($('[data-lessonid="' + data.lessonid + '"]').hasClass('last')){
                        $('.continue-btn').addClass('d-none').find('button').prop('disabled', true);
                    }
                    else{
                        if($("#resELe").length){
                            $('.continue-btn').removeClass('d-none').find('button').prop('disabled', false);
                        }
                    }
                }
            }
        },
        error: function(xhr){
            console.log(xhr.status);
            $(window).off('beforeunload');
            if(xhr.status == 401 || xhr.status == 419){
                window.location.href = login_url;
            }
        }
    });
    var nextlessonId = $('[data-lessonid="' + lessonId + '"]').next('.js-list-lesson').attr('data-lessonid');
    if(nextlessonId !== undefined){
        getLessonView(nextlessonId);
    }
});

$(document).on("click","[id^='lessonprevious-']",function(){
    lessonclick = true;
    var lessonId = $(this).attr('id').replace('lessonprevious-','');
    var course = $('[data-courseid]').attr('data-courseid');
    
    var previouslessonId = $('[data-lessonid="' + lessonId + '"]').prev('.js-list-lesson').attr('data-lessonid');
    if(previouslessonId !== undefined){
        getLessonView(previouslessonId);
    }
});
//front end course view page functions end