//camara capture features
var video = document.getElementById("camera");
var canvas = document.getElementById("myCanvas");
var camera = false;
let currentStream = null;
var capturedImage = false;
var ctx = canvas.getContext('2d');
var timeoutcamera;

function StartCamera() {
    
    if (!camera) {
        if (navigator.mediaDevices.getUserMedia) {
            navigator.mediaDevices.getUserMedia(
                {
                    video: true
                }).then(function (stream) {
                    currentStream = stream;
                    video.srcObject = currentStream;
                    video.style.display = 'block';
                    camera = true;
                }).catch(function (err) {
                    console.log(err);
                });
        }
    }

    else {
        camera = false;
        if(currentStream != undefined){
            currentStream.getTracks().forEach(track => track.stop());
        }
        video.srcObject = null;
    }
}


function snapshot() {
    if (camera) {
        ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
        capturedImage = true;
        $('#myCanvas').removeClass('d-none');
        video.style.display = 'none';
        camera = false;
        if(currentStream != undefined){
            currentStream.getTracks().forEach(track => track.stop());
        }
        video.srcObject = null;

        canvas.toBlob(function(blob) {
            // Create a new FormData object
            var formData = new FormData();
            var imgname = $('#capture').data('capname');
           
            // Append the canvas image blob to the form data
            formData.append('image', blob, imgname+'.png');
            // Make an AJAX call
            $.ajax({
              url: capturesave,
              type: 'POST',
              data: formData,
              processData: false,
              contentType: false,
              beforeSend: function (xhr) {
                xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                },
              success: function(response) {
                console.log('Image uploaded successfully.'+response.redirection);
                if(response.redirection != undefined){
                    window.location.href = response.redirection;
                }
              },
              error: function(xhr, status, error) {
                if(xhr.status == 401 || xhr.status == 419){
                    window.location.href = login_url;
                }
              }
            });
          }, 'image/png');
        //save capture event
        $.ajax({
            type: "post",
            url: capturesave,
            beforeSend: function (xhr) {
                xhr.setRequestHeader("X-CSRF-Token", csrf_token);
            },
            data: "filename="+course,
            success: function (data) {
                console.log(data);
                $('#encryptedcont').html(data);
            },
            error: function(xhr){
                console.log(xhr.status);
                if(xhr.status == 401 || xhr.status == 419){
                    window.location.href = login_url;
                }
            }
        });
    }
    else{
        console.log('Capture picture one time only');
    }
}


$(function() {
   if(!$('.uploader-section').length){
     StartCamera();
   }
   $(window).on('beforeunload', function() {
        camera = false;
        if(currentStream != undefined){
            currentStream.getTracks().forEach(track => track.stop());
        }
        video.srcObject = null;
    });
});

$(document).on('click','#capture',function(){ snapshot() });

$(document).on('click','#encryptionimg',function(){
    documentImage();
});

//decrypted image call
function documentImage(){
    var filename = '';
    $.ajax({
        type: "get",
        url: decryptRoute,
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        // data: "filename="+course,
        success: function (data) {
            console.log(data);
            $('#encryptedcont').html(data);
        },
        error: function(xhr){
            console.log(xhr.status);
            if(xhr.status == 401 || xhr.status == 419){
                window.location.href = login_url;
            }
        }
    });
    
}
//decrypted image call
//camara capture features