// Do not remove below code, necessary for Safari browser
let volume = document.querySelector(".volume-button");
let tooltip = document.querySelector(".tooltip");

volume.onclick = () => {
    console.log("");
};

tooltip.onclick = (event) => {
    event.stopPropagation();
    tooltip.classList.add("active");
};

document.addEventListener("click", (event) => {
    if (!tooltip.contains(event.target)) {
        tooltip.classList.remove("active");
    }
});
document.addEventListener("click", (event) => {
    if (!volume.contains(event.target)) {
        volume.classList.remove("active");
    }
});

// PLAYER SETTINGS
let progress = document.getElementById("progress");
let song = document.getElementById("song");
let ctrlIcon = document.getElementById("ctrlIcon");
let playbutton = document.getElementById("playbutton");
let currentTimeDisplay = document.querySelector(".timer .left"); // Select the left timer
let totalTimeDisplay = document.querySelector(".timer .right"); // Select the right timer
let loader = document.querySelector(".loader");
let rewindbtn = document.querySelector(".rewindbtn");
let forwardbtn = document.querySelector(".forwardbtn");

function disableButtonsWhileLoading() {
    document.querySelector(".loader-bg").classList.add("loading");
    playbutton.style.pointerEvents = "none";
    rewindbtn.style.pointerEvents = "none";
    forwardbtn.style.pointerEvents = "none";
}

function enableButtonsWhenLoaded() {
    document.querySelector(".loader-bg").classList.remove("loading");
    playbutton.style.pointerEvents = "auto";
    rewindbtn.style.pointerEvents = "auto";
    forwardbtn.style.pointerEvents = "auto";
}

// Show loader when audio is loading
song.addEventListener("paused", () => {
    disableButtonsWhileLoading();
});

song.addEventListener("waiting", () => {
    disableButtonsWhileLoading();
});

// Hide loader when audio is ready to play
song.addEventListener("canplay", () => {
    enableButtonsWhenLoaded();
});

// Hide loader when audio starts playing
song.addEventListener("playing", () => {
    enableButtonsWhenLoaded();
});

// Show loader if an error occurs
song.addEventListener("error", () => {
    enableButtonsWhenLoaded();
    setTimeout(() => {
        disableButtonsWhileLoading();
    }, 3000);
});

// Prevent user from interacting with the progress bar
progress.style.pointerEvents = "none"; // Blocks clicks and dragging

song.onloadedmetadata = function () {
    progress.max = song.duration;
    progress.value = song.currentTime;
};

function playPause() {
    if (ctrlIcon.classList.contains("fa-pause")) {
        song.pause();
        ctrlIcon.classList.remove("fa-pause");
        ctrlIcon.classList.add("fa-play");
    } else {
        song.play();
        ctrlIcon.classList.add("fa-pause");
        ctrlIcon.classList.remove("fa-play");
    }
}

function forward() {
    if (song.currentTime + 15 < song.duration) {
        song.currentTime += 15;
    } else {
        song.currentTime = song.duration;
    }
    progress.value = song.currentTime;
}

function rewind() {
    if (song.currentTime - 15 > 0) {
        song.currentTime -= 15;
    } else {
        song.currentTime = 0;
    }
    progress.value = song.currentTime;
}

song.addEventListener("timeupdate", () => {
    progress.value = song.currentTime;
});

progress.onchange = function () {
    song.currentTime = progress.value;
    song.play();
    ctrlIcon.classList.add("fa-pause");
    ctrlIcon.classList.remove("fa-play");
};

let volumeSlider = document.querySelector(".volume");
let volumeIcon = document.querySelector(".volume-button i");

volumeSlider.addEventListener("input", function () {
    song.volume = volumeSlider.value / 100;
    updateVolumeIcon();
});

function updateVolumeIcon() {
    if (song.volume === 0) {
        volumeIcon.classList.remove("fa-volume-up", "fa-volume-down");
        volumeIcon.classList.add("fa-volume-off");
    } else if (song.volume < 0.5) {
        volumeIcon.classList.remove("fa-volume-up", "fa-volume-off");
        volumeIcon.classList.add("fa-volume-down");
    } else {
        volumeIcon.classList.remove("fa-volume-down", "fa-volume-off");
        volumeIcon.classList.add("fa-volume-up");
    }
}

// Initialize volume to match slider on page load
song.volume = volumeSlider.value / 100;
updateVolumeIcon();

// Function to format time as mm:ss
function formatTime(seconds) {
    let mins = Math.floor(seconds / 60);
    let secs = Math.floor(seconds % 60);
    return `${mins}:${secs < 10 ? "0" + secs : secs}`;
}

song.onloadedmetadata = function () {
    progress.max = song.duration;
    progress.value = song.currentTime;
    totalTimeDisplay.textContent = formatTime(song.duration); // Set total duration
};

song.addEventListener("timeupdate", () => {
    progress.value = song.currentTime;
    currentTimeDisplay.textContent = formatTime(song.currentTime); // Update current time
});

progress.onchange = function () {
    song.currentTime = progress.value;
    song.play();
    ctrlIcon.classList.add("fa-pause");
    ctrlIcon.classList.remove("fa-play");
};

// AUDIOCONTEXT API FOR VOLUME HANDLING IN ALL BROWSERS
document.addEventListener("DOMContentLoaded", async function () {
    let song = document.getElementById("song");
    let volumeSlider = document.querySelector(".volume");
    let volumeIcon = document.querySelector(".volume-button i");

    // Create Web Audio API context
    let audioContext = new (window.AudioContext || window.webkitAudioContext)();
    let track = audioContext.createMediaElementSource(song);
    let gainNode = audioContext.createGain();

    track.connect(gainNode);
    gainNode.connect(audioContext.destination);

    // Function to set volume
    function setVolume(value) {
        let volumeValue = value / 100;
        gainNode.gain.value = volumeValue; // Update Web Audio volume
        updateVolumeIcon(volumeValue);
    }

    // Update volume on input change
    volumeSlider.addEventListener("input", function () {
        setVolume(volumeSlider.value);
    });

    // Update volume icon based on level
    function updateVolumeIcon(volumeValue) {
        if (volumeValue === 0) {
            volumeIcon.classList.remove("fa-volume-up", "fa-volume-down");
            volumeIcon.classList.add("fa-volume-off");
        } else if (volumeValue < 0.5) {
            volumeIcon.classList.remove("fa-volume-up", "fa-volume-off");
            volumeIcon.classList.add("fa-volume-down");
        } else {
            volumeIcon.classList.remove("fa-volume-down", "fa-volume-off");
            volumeIcon.classList.add("fa-volume-up");
        }
    }

    // Ensure AudioContext is resumed on user interaction (required for Safari)
    function unlockAudio() {
        if (audioContext.state === "suspended") {
            audioContext.resume().then(() => {
                console.log("AudioContext resumed");
            });
        }
        document.removeEventListener("click", unlockAudio);
    }

    document.addEventListener("click", unlockAudio);

    // Set initial volume
    setVolume(volumeSlider.value);
});
