<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="">

<head>
    <title>Chart.js Pie Chart Demo</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<body>
    <canvas id="myChart" width="400" height="400"></canvas>
    <script>
        var ctx = document.getElementById("myChart").getContext("2d");
        var myChart = new Chart(ctx, {
            type: "pie",
            data: {
                labels: ["Red", "Blue", "Yellow"],
                datasets: [{
                    label: "# of Votes",
                    data: [12, 19, 3],
                    backgroundColor: ["red", "blue", "yellow"],
                    borderColor: "white",
                    borderWidth: 1,
                }, ],
            },
            options: {
                responsive: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'right',
                        labels: {
                            boxHeight: 28,
                        }
                    }
                }
            },
        });
    </script>
</body>

</html>