<div class="modal-content">
    <div class="modal-body">
        <div class="card-body pt-0 px-0">
            @if (count($certificates) > 0)
                <div class="state-table-card">
                    <h4 class="font-weight-bold">Below is the list of State Certificates that you qualify for the course: <strong>{{ $title }}</strong>. Click the Certificate icon to view and print each certificate.</h4>
                    <div class="table-responsive mt-4">
                        <table class="table shadow-none table-bordered mb-0" aria-describedby="DataTableDesc">
                            <thead>
                                <tr class="bg-white">
                                    <th scope="col">{{ __('coursecategory.state_th') }}
                                    </th>
                                    <th scope="col">
                                        {{ __('coursecategory.completiondt_th') }}</th>
                                    <th scope="col">
                                        {{ __('coursecategory.approvalnumber_th') }}</th>
                                    <th scope="col">
                                            </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($certificates as $item)
                                    <tr>
                                        <td>{{ $item->fstate }}</td>
                                        <td>{{ $item->enrolcompletiondt }}</td>
                                        <td>{{ $item->approval }}</td>
                                        <td><a href="{{ route('coursepdfcertificateadmin',['lid'=>$item->licensekey,'caid'=>$item->approvalkey,'courseid'=>$courseid, 'id'=>$id]) }}" target="_blank" title="View Certificate" class="text-primary js-certificate-pdf">View</a></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @else
            <div class="state-table-card text-center">No Certificate Found</div>
            @endif

        </div>
    </div>
</div>
