    <div class="modal-content">
        <div class="modal-header">
            <h2 class="text-left modal-title" id="course-name">{{ $course->title }}</h2>
        </div>
        <div class="modal-body">
            <div class="card-body border-top px-0">
                @if($course->description)
                    <h4 class="mb-3 font-weight-bold">
                        @if($course->type == 0) 
                        {{ __('coursecategory.crc_description') }}
                        @else
                        {{ __('coursecategory.bdl_description') }}
                        @endif
                    </h4>
                    <div id="course-description">{!! $course->description !!}</div> 
                @endif
                @if (count($course->courseApproval) > 0)
                    <div class="state-table-card mt-4">
                        <h5><strong>{{ __('coursecategory.states_the_crc_reciprocate') }}</strong></h5>
                        <div class="table-responsive mt-4">
                            <table class="table shadow-none table-bordered mb-0" aria-describedby="DataTableDesc" >
                                <thead>
                                    <tr>
                                        <th class="text-center bg-theme text-white"
                                            colspan="6" scope="col">
                                            {{ __('coursecategory.crc_online_info') }}</th>
                                    </tr>
                                </thead>
                                <thead>
                                    <tr class="bg-white">
                                        <th scope="col">{{ __('coursecategory.state_th') }}
                                        </th>
                                        <th scope="col">
                                            {{ __('coursecategory.credits_th') }}</th>
                                        <th scope="col">
                                            {{ __('coursecategory.approvalnumber_th') }}</th>
                                        <th scope="col">
                                            {{ __('coursecategory.expirationdt_th') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($course->courseApproval as $item)
                                        <tr>
                                            <td>{{ $item->fstate }}</td>
                                            <td>{{ $item->credits }}</td>
                                            <td>{{ $item->approval }}</td>
                                            <td>{{ $item->end_datef }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                @endif

            </div>
        </div>
    </div>
