@guest
@else
@if(empty(Auth::user()->securitycode))
<footer class="text-center footer-box fixed-bottom py-2">
    {{ '©' }} {{  footerCopyRightText() }} {{ siteconfig('footer_title_for_admin',0) }}
</footer>
@endif
@endguest
<div id="externallink-modal" class="modal fade youtube_video_url_popup">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><img src="{{ asset('assets/front/images/close-model.svg') }}" alt="close button"></span>
    </button>
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body data_list" style="background-color: white;">
                <h4 class="semibold mt0">Add youtube video link</h4>
                <div class="row">
                    <div class="form-group col-sm-12">
                        <label class="control-label validator-label">Youtube video link<span
                                class="text-danger">*</span></label>
                        <input type="url" class="form-control" data-validator="required|youtube"
                            id="youtube_video_link" name="youtube_video_link">
                        <div class="errormessage"></div>
                        <small class="form-text text-muted line1 youtube-help-text">Please add youtube share URL
                            [e.g. https://youtu.be/WVZ2PhmDa2M]</small>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button id="add_external_link" type="button" form-name-to-validate="task_dashboard_form"
                    class="btn btn-primary parsley-btn" title="Add youtube video link" onclick="addExtraData()">Add
                    Link</button>
                <button type="button" class="btn btn-dark" data-dismiss="modal" id="youtube_model_close">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="confirm-action-modal" tabindex="-1" role="dialog" aria-labelledby="confirmDeleteSubmitLabel"
    aria-hidden="true">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><img src="{{ asset('assets/front/images/close-model.svg') }}" alt="close button"></span>
    </button>
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2><strong>Confirm</strong></h2>
            </div>
            <div class="modal-body">
                <div id="dependent_msg"></div>
                Are you sure you want to <strong class="modal-action-name"></strong> the selected
                @if(collect(request()->segments())->last() == 'team') team member(s)
                @elseif(collect(request()->segments())->last() == 'faq') FAQ(s)
                @elseif(collect(request()->segments())->last() == 'course-category') category(s)
                @elseif(Route::currentRouteName() == 'comment.type.filter') comment(s)
                @else
                {{ collect(request()->segments())->last() }}(s) @endif?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-dark" data-dismiss="modal">Cancel</button>
                <a href="#" id="confirm-action-submit" class="btn btn-primary">Submit</a>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="slider-confirm-action" tabindex="-1" role="dialog"
    aria-labelledby="confirmDeleteSubmitLabel" aria-hidden="true">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><img src="{{ asset('assets/front/images/close-model.svg') }}" alt="close button"></span>
    </button>
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2><strong>Confirm</strong></h2>
            </div>
            <div class="modal-body">
                <div id="dependent_msg"></div>
                Are you sure you want to <strong class="modal-action-name"></strong> {{ collect(request()->segments())->last() }}?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-dark" data-dismiss="modal">Cancel</button>
                <a href="#" id="confirm-slider-delete" class="btn btn-primary">Submit</a>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="gallery-confirm-action" tabindex="-1" role="dialog"
    aria-labelledby="confirmDeleteSubmitLabel" aria-hidden="true">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><img src="{{ asset('assets/front/images/close-model.svg') }}" alt="close button"></span>
    </button>
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2><strong>Confirm</strong></h2>
            </div>
            <div class="modal-body">
                <div id="dependent_msg">Are you sure you want to <strong class="modal-action-name"></strong> this image/youtube
                    video?</div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-dark" data-dismiss="modal">Cancel</button>
                <a href="#" id="confirm-gallery-delete" class="btn btn-primary">Submit</a>
            </div>
        </div>
    </div>
</div>
{{-- <div class="modal fade" id="courseblock-confirm-action" tabindex="-1" role="dialog"
    aria-labelledby="courseblock-confirm-action" aria-hidden="true">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><img src="{{ asset('assets/front/images/close-model.svg') }}" alt="close button"></span>
    </button>
    <div class="modal-dialog">
        <div class="modal-content delete-model-popup">
            <div class="modal-header align-items-center text-center">
                <h2><strong>Confirm</strong></h2>
            </div>
            <div class="modal-body">
                <div id="dependent_msg"></div>
                Are you sure you want to DELETE the selected course block?
            </div>
            <div class="modal-footer border-0 justify-content-center">
                <button type="button" class="btn btn-cancel px-4" data-dismiss="modal">Cancel</button>
                <a href="#" id="confirm-courseblock-delete" class="btn btn-primary px-5">Yes</a>
            </div>
        </div>
    </div>
</div> --}}
<script type="text/javascript">
    var csrf_token = "{{ csrf_token() }}";
    var upload_url = "{{ route('adminupload') }}";
    var login_url = "{{ route('login') }}";
    var date_standard = "{{ config('app.date_format_js') }}";
    var datetime_standard = "{{ config('app.datetime_format_js') }}";
    var time_standard = "{{ config('app.time_format_js') }}";
    var pagingLenthOptions = [[100,150,200,250,300,350,400,450,500, -1], [100,150,200,250,300,350,400,450,500, "All"]];
    var defaultPagingLenth = "{{ siteconfig('records_per_page',0) ? siteconfig('records_per_page',0) : 100  }}";

    var uploadMultipleFiles = "{{ route('upload.uploadMultipleFile')  }}";
    var max_gallery_image_size_inMB = "10";
    var max_image_size_inMB = "{{ config('image-sizes.slider.sizes.fit-setting.size', 5) }}";
    var max_audio_size_inMB = "{{ getImageUploadSizeInMB('upload_file') }}";
    var max_image_width = "{{ config('image-sizes.slider.sizes.fit-setting.width', 1900) }}";
    var max_image_height = "{{ config('image-sizes.slider.sizes.fit-setting.height',755) }}";
    var password_strength = "{{ siteconfig('password_strength') ? siteconfig('password_strength') : ''  }}";
    var max_image_width_gallery = "{{ config('image-sizes.galleryimage.sizes.fit-setting.width', 1900) }}";
    var max_image_height_gallery = "{{ config('image-sizes.galleryimage.sizes.fit-setting.height', 775)  }}";
    var regx_minimum_password_length = /^(.{<?php echo siteconfig('minimum_password_length') ? siteconfig('minimum_password_length') : 8;?>,})/;
</script>

<!-- fileupload js -->
<link rel="stylesheet" href="{{ asset('assets/admin/css/jquery.fileupload.css') }}">
<!-- The template to display files available for upload -->
<script id="template-upload" type="text/x-tmpl">
    {% for (var i=0, file; file=o.files[i]; i++) { %}

        <tr class="template-upload ">
            <td>
                <span class="preview"></span>
            </td>
            <td>
                {% if (window.innerWidth > 480 || !o.options.loadImageFileTypes.test(file.type)) { %}
                    <p class="name">{%=file.name%}</p>
                {% } %}
                <strong class="error text-danger filevalidationerror" ></strong>
            </td>
            <td>
                <p class="size">Processing...</p>
                <div class="progress progress-striped active" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0"><div class="progress-bar progress-bar-success" style="width:0%;"></div></div>
            </td>
            <td>
                {% if (!o.options.autoUpload && o.options.edit && o.options.loadImageFileTypes.test(file.type)) { %}
                  <button class="btn btn-success edit" data-index="{%=i%}" disabled>
                      <i class="glyphicon glyphicon-edit"></i>
                      <span>Edit</span>
                  </button>
                {% } %}
                {% if (!i && !o.options.autoUpload) { %}
                    <button class="btn btn-primary start" disabled>
                        <i class="glyphicon glyphicon-upload"></i>
                        <span>Upload</span>
                    </button>
                {% } %}
                {% if (!i) { %}
                    <button class="btn btn-dark cancel">
                        <i class="glyphicon glyphicon-ban-circle"></i>
                        <span>Cancel</span>
                    </button>
                {% } %}
            </td>
            <td>
                {% if (!i) { %}
                    <span class="upload-loader"></span>
                {% } %}
            </td>
            <td></td>
            <td></td>
        </tr>
    {% } %}
  </script>

<script id="template-download" type="text/x-tmpl">
    {% for (var i=0, file; file=o.files[i]; i++) { %}

        <tr class="template-download " pk_id={%=file.name %}>
            <td>
                <lable>File Name<span class="text-danger">*</span></lable></br>
                <input name="multiimagefilename[]" placeholder="Enter File Name" type="text" id="multiimagefilename" value="" />
            </td>
            <td>
                <lable>CLE ID<span class="text-danger">*</span></lable></br>
                <input name="multiimagebarid[]" placeholder="Enter CLE ID" type="text" id="multiimagebarid" value="" />
            </td>
            <td>
                <input type="hidden" name="multiimage_ids[]" value="0">
                <input name="multiimage[]" type="hidden" id="multiimage" value="{%=file.name%}" />
                <input name="multiimageduration[]" type="hidden" id="multiimageduration" value="{%=file.duration%}" />
                <input name="multiimagesize[]" type="hidden" id="multiimagesize" value="{%=file.size%}" />
                {% if (window.innerWidth > 480 || !file.thumbnailUrl) { %}
                    <p class="name">
                        {% if (file.url) { %}
                            <a href="{%=file.url%}" title="{%=file.name%}" download="{%=file.name%}" {%=file.thumbnailUrl?'data-gallery':''%}>{%=file.name%}</a>
                        {% } else { %}
                            <span>{%=file.name%}</span>
                        {% } %}
                    </p>
                {% } %}
                {% if (file.error) { %}
                    <div><span class="label label-danger">Error</span> {%=file.error%}</div>
                {% } %}
            </td>
            <td>
                <span class="size"> ({%=file.duration%})</span>
            </td>
            <td></td>
            <td style="text-align: right;"><button type="button" class="btn btn-outline-danger remove_upload_file">X</button></td>
            <td></td>
        </tr>
    {% } %}
  </script>

<script src="{{ asset('assets/admin/js/fileupload/vendor/jquery.ui.widget.js') }}"></script>
<!-- The Templates plugin is included to render the upload/download listings -->
<script src="{{ asset('assets/admin/js/fileupload/tmpl.min.js') }}"></script>
<!-- The Load Image plugin is included for the preview images and image resizing functionality -->
<script src="{{ asset('assets/admin/js/fileupload/load-image.all.min.js') }}"></script>
<!-- The Canvas to Blob plugin is included for image resizing functionality -->
<script src="{{ asset('assets/admin/js/fileupload/canvas-to-blob.min.js') }}"></script>
<!-- blueimp Gallery script -->
<script src="{{ asset('assets/admin/js/fileupload/jquery.blueimp-gallery.min.js') }}"></script>
<!-- The Iframe Transport is required for browsers without support for XHR file uploads -->
<script src="{{ asset('assets/admin/js/fileupload/jquery.iframe-transport.js') }}"></script>
<script src="{{ asset('assets/admin/js/fileupload/jquery.fileupload.js') }}"></script>
<!-- The File Upload processing plugin -->
<script src="{{ asset('assets/admin/js/fileupload/jquery.fileupload-process.js') }}"></script>
<!-- The File Upload image preview & resize plugin -->
<script src="{{ asset('assets/admin/js/fileupload/jquery.fileupload-image.js') }}"></script>
<!-- The File Upload audio preview plugin -->
<script src="{{ asset('assets/admin/js/fileupload/jquery.fileupload-audio.js') }}"></script>
<!-- The File Upload video preview plugin -->
<script src="{{ asset('assets/admin/js/fileupload/jquery.fileupload-video.js') }}"></script>
<!-- The File Upload validation plugin -->
<script src="{{ asset('assets/admin/js/fileupload/jquery.fileupload-validate.js') }}"></script>
<!-- The File Upload user interface plugin -->
<script src="{{ asset('assets/admin/js/fileupload/jquery.fileupload-ui.js') }}"></script>

<!-- Dropify CSS -->
<link rel="stylesheet" href="{{ asset('assets/admin/libraries/dropify/dist/css/dropify.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/common/libraries/jquery-ui/jquery-ui.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/common/libraries/datatables/datatables.min.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/admin/css/select2.min.css') }}" type="text/css" />

<!-- Footer Scripts -->
<script src="{{ asset('assets/common/libraries/jquery-ui/jquery-ui.js') }}"></script>
<script src="{{ asset('assets/admin/libraries/tinymce/js/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('assets/admin/libraries/dropify/dist/js/dropify.min.js') }}"></script>
<script src="{{ asset('assets/common/js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('assets/common/libraries/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/common/libraries/datatables/datatables-bs3.js') }}"></script>
<script src="{{ asset('assets/common/libraries/datatables/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('assets/common/libraries/datatables/jszip.min.js') }}"></script>
<script src="{{ asset('assets/common/libraries/datatables/buttons.html5.min.js') }}"></script>
<!-- Include Magnific Popup -->
<link rel="stylesheet" type="text/css" href="{{ asset('assets/common/libraries/magnific/magnific-popup.css') }}" />
<script src="{{ asset('assets/common/libraries/magnific/jquery.magnific-popup.min.js') }}"></script>

<!-- Include Date Range Picker -->
<script src="{{ asset('assets/admin/js/moment.js') }}"></script>
<script src="{{ asset('assets/admin/js/bootstrap-datetimepicker.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/bootstrap-editable.js') }}"></script>
<script src="{{ asset('assets/admin/js/jquery.form-validation.js') }}"></script>
<script src="{{ asset('assets/admin/js/select2.min.js') }}"></script>

{{-- Bootstrap select js --}}
<script src="{{ asset('assets/admin/js/bootstrap-select.min.js') }}"></script>

<script src="{{ asset('assets/admin/js/bootbox.min.js') }}"></script>
<script src="{{ asset('assets/front/libraries/owl-carousel/owl.carousel.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/footer.js') }}"></script>

<script type="text/javascript">
    slidertitleeditable();
    function slidertitleeditable() {
        //bootstrap-editable turn to inline mode
        $.fn.editable.defaults.mode = 'inline';
        $.fn.editable.defaults.params = function (params) {
            params._token = csrf_token;
            return params;
        };

        $(document).ready(function() {
            $('.slider-title').editable({
                validate: function(value) {
                    if($.trim(value) == '') {
                        return 'The title field is required';
                    }
                }
            });
        });
    }
</script>



<!-- SVG -->
<script type="text/javascript">
    $(function(){
    jQuery('img.svg').each(function(){
        var $img = jQuery(this);
        var imgID = $img.attr('id');
        var imgClass = $img.attr('class');
        var imgURL = $img.attr('src');

        jQuery.get(imgURL, function(data) {
            // Get the SVG tag, ignore the rest
            var $svg = jQuery(data).find('svg');

            // Add replaced image's ID to the new SVG
            if(typeof imgID !== 'undefined') {
                $svg = $svg.attr('id', imgID);
            }
            // Add replaced image's classes to the new SVG
            if(typeof imgClass !== 'undefined') {
                $svg = $svg.attr('class', imgClass+' replaced-svg');
            }

            // Remove any invalid XML tags as per http://validator.w3.org
            $svg = $svg.removeAttr('xmlns:a');

            // Check if the viewport is set, else we gonna set it if we can.
            if(!$svg.attr('viewBox') && $svg.attr('height') && $svg.attr('width')) {
                $svg.attr('viewBox', '0 0 ' + $svg.attr('height') + ' ' + $svg.attr('width'))
            }

            // Replace image with new SVG
            $img.replaceWith($svg);

        }, 'xml');

    });
});
</script>
