<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <!-- Include Head -->
    @include('admin.includes.head')
<body>
    <!-- Include Header -->
    @guest
    @else
        @if(empty(Auth::user()->securitycode))
        @include('admin.includes.header')
        @endif
    @endguest
    @guest
    @else
    <!-- Include Menu -->
        @if(empty(Auth::user()->securitycode))
        @include('admin.includes.menu')
       
    <!-- Include Content -->
    <div class="page-content py-3 px-0 px-md-2" id="main">
        @endif
        @endguest
        @if (Session::has('error'))
        <div class="alert text-center fade show">
            <span class="errormessage text-danger">{!! session('error') !!}</span>
        </div>
        @elseif (Session::has('info'))
        <div class="alert text-center fade show">
            <span class="infomessage text-info">{!! session('info') !!}</span>
        </div>
        @elseif (Session::has('success'))
        <div class="alert text-center fade show">
            <span class="successmessage text-success">{!! session('success') !!}</span>
        </div>
        @endif
        <div class="ajax_message d-none">
            <span></span>
        </div>
        @if(empty(Auth::user()->securitycode))
        @yield('content')
        @else
        <div class="d-flex form-signin-box min-vh-100">
            <div class="form-signin container">
                <div class="row justify-content-center">
                    <div class="col-12 col-md-6 col-xl-6">
                        <div class="login-content p-5 text-center">
                            <p><strong class="capitalize">{{ Auth::user()->fullname}}</strong> unauthorize to access site content. so please verify login by security code. </p>
                            <a href="{{ route('security-code.form') }}" class="mt-2 btn btn-primary" title="Enter security code ">Enter security code</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
        @guest
        @else
        @if(empty(Auth::user()->securitycode))
    </div>
        @endif
    @endguest
        <!-- Include Poup File -->
        @include('admin.includes.popup')
    <!-- Include Footer -->
    @include('admin.includes.footer')
    @yield('extra-js')
    @yield('extra-js-2')
</body>
</html>
