@extends('admin.layouts.app')
@section('content')
    <div class="loader" style="display: none;"></div>
    <div class="d-flex form-signin-box min-vh-100">

        <div class="row justify-content-center form-signin container">
            <div class="col-12 col-md-6 col-xl-6">
                <div class="login-content p-5">

                    <div class="login-logo text-center mb-5">
                        <img src="{{ asset('assets/admin/images/header-logo.png') }}"
                            alt="{{ siteconfig('app_name', 0) }}" width="250">
                    </div>
                    <h1 class="text-center mb-3">{{ __('user.login_title', ['app_name' => siteconfig('app_name', 0)]) }}
                    </h1>

                    @if (Session::has('message'))
                        <div class="alert text-center fade show">
                            <span class="successmessage text-success">{!! Session::get('message') !!} </span>
                        </div>
                    @endif

                    @if (Session::has('access_token_url'))
                    <div class="row mt-4 text-center">
                        <div class="col-10 mx-auto">
                            <a href="{{ Session::get('access_token_url') }}" class="btn btn-primary text-center">
                                Redirect to App
                            </a>
                        </div>
                    </div>
                    @else
                    <div class="row mt-4 text-center">
                        <div class="col-10 mx-auto">
                            <a href="{{ env('CL_APP_URL').'/accountactivated' }}" class="btn btn-primary text-center">
                                Redirect to App
                            </a>
                        </div>
                    </div>
                    @endif

                </div>
            </div>
        </div>

    </div>
@endsection
