@extends('admin.layouts.code')
@section('content')
<div class="loader" style="display: none;"></div>
<div class="d-flex form-signin-box min-vh-100">

    <form method="POST" action="{{ route('security-code.verify') }}" class="form-signin container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-6 col-xl-6">
                <div class="login-content p-5">

                <div class="login-logo text-center mb-5">
                    <img src="{{ asset('assets/admin/images/header-logo.png') }}" alt="{{ siteconfig('app_name',0) }}" width="250">
                </div>
                <h1 class="text-center mb-3">{{ __('user.login_title', ['app_name' => siteconfig('app_name',0)]) }}</h1>
                <h6 class="text-left mt-5 text-success">{{ __('The security code has been successfully sent to ').Auth::user()->email.'.' }}</h6>

                @csrf
                <div class="form-group">

                    <label for="security_code">{{ __('Security Code') }}<span class="text-danger">*</span></label>
                    <input id="security_code" type="text" class="validate form-control @error('security_code') is-invalid @enderror"
                        name="security_code" value="{{ old('security_code') }}" autocomplete="security_code" autofocus data-validator="required">
                    <div class="errormessage" role="alert">
                    @error('security_code')<span>{{ $message }}</span>@enderror
                    </div>
                </div>
                                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-primary mt-2 mb-2 col-12">
                       <strong> {{ __('Submit') }}</strong>
                    </button>
                    <a href="{{ route('security-code.clear') }}" class="btn btn-secondary mt-2 mb-2 col-12" style="font-size: 1.25rem">
                        <strong> {{ __('Back') }}</strong>
                    </a>
                </div>
            </div>
            </div>
    </form>

</div>
@endsection
