@extends('admin.layouts.app')
@section('content')
<div class="loader" style="display: none;"></div>
<div class="d-flex form-signin-box min-vh-100">

    <form method="POST" action="{{ route('login') }}" class="form-signin container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-6 col-xl-6">
                <div class="login-content p-5">

                <div class="login-logo text-center mb-5">
                    <img src="{{ asset('assets/admin/images/header-logo.png') }}" alt="{{ siteconfig('app_name',0) }}" width="250">
                </div>
                <h1 class="text-center mb-3">{{ __('user.login_title', ['app_name' => siteconfig('app_name',0)]) }}</h1>
                <h5 class="text-center mb-5">{{ __('Sign in by entering the information below') }}</h5>

                @csrf
                @if (Session::has('message'))
                <div class="alert text-center fade show">
                    <span class="successmessage text-success">{!! Session::get('message') !!} </span>
                </div>
                @endif
                @error('auth_failed')
                <div class="alert alert-danger" role="alert">
                    <span>{{ $message }}</span>
                </div>
                @enderror
                @error('auth_throttle')
                <div class="alert alert-danger" role="alert">
                    <span>{{ $message }}</span>
                </div>
                @enderror
                <div class="form-group">

                    <label for="email">{{ __('Email') }}<span class="text-danger">*</span></label>
                    <input id="email" type="text" class="validate form-control @error('email') is-invalid @enderror"
                        name="email" value="{{ old('email') }}" autocomplete="email" autofocus data-validator="required|email">
                    <div class="errormessage" role="alert">
                    @error('email')<span>{{ $message }}</span>@enderror
                    </div>
                </div>
                <div class="form-group">
                    <label for="password">{{ __('Password') }}<span class="text-danger">*</span></label>
                    <input id="password" type="password" class="form-control @error('password') is-invalid @enderror"
                        name="password" autocomplete="current-password" data-validator="required">
                    <div class="errormessage" role="alert">
                    @error('password')<span>{{ $message }}</span>@enderror
                    </div>
                </div>
                <div class="form-group d-flex">
                    <div class="custom-checkbox">
                        <input class="custom-control-input" type="checkbox" name="remember" id="remember"
                            {{ old('remember') ? 'checked' : '' }}>
                        <label class="custom-control-label text-gary-1" for="remember">
                            <span class="light">{{ __('Remember Me') }}</span>
                        </label>
                    </div>
                    <a class="text-dark label ml-auto" href="{{ route('password.request') }}">{{ __('Forgot Your Password?') }}</a>
                </div>
                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-primary col-12">
                       <strong> {{ __('Sign In') }}</strong>
                    </button>
                </div>
                @if (Route::has('password.request'))
                @endif
            </div>
            </div>
    </form>

</div>
@endsection
