@extends('admin.layouts.app')

@section('content')
<div class="loader" style="display: none;"></div>
<div class="d-flex form-signin-box min-vh-100">
    <form method="POST" action="{{ route('password.email') }}" class="form-signin container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-6 col-xl-6">
                <div class="login-content p-5">
                    <div class="login-logo text-center mb-3">
                        <img src="{{ asset('assets/admin/images/header-logo.png') }}" alt="{{ siteconfig('app_name',0) }}">
                    </div>
                    <h1 class="text-center mb-5">{{ __('Forgot Password') }}</h1>
                    @csrf
                    @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                    @endif
                    @error('user_does_not_exists')
                    <div class="alert alert-danger" role="alert">
                        <span>{{ $message }}</span>
                    </div>
                    @enderror
                    <div class="form-group">
                        <label for="email">{{ __('Email') }}<span class="text-danger">*</span></label>
                        <input id="email" type="text" class="form-control @error('email') is-invalid @enderror" name="email"
                            value="{{ old('email') }}" autocomplete="email" autofocus data-validator="required|email">
                        <div class="errormessage" role="alert">
                        @error('email')<span> {{ $message }} </span>@enderror
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn  btn-large col s12 z-depth-0 btn-primary">
                            {{ __('Reset password') }}
                        </button>
                    </div>
                    <div class="form-group text-center">
                        <a class="text-theme-gray label" href="{{ route('login') }}">{{ __('Back to Login') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
