@extends('admin.layouts.app')
@section('content')

    <form method="post" action="{{ isset($bar->id) ? route('bar.update', $bar->id) : route('bar.store') }}" name="frmaddedit"
        id="frmaddedit" class="{{!isset($bar->id) ?'confirm-submit':''}}" data-confirm-message="{{__('bar.form_submit_message')}}">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6">
                <h1 class="bar-title">{{ isset($bar->id) ? __('bar.editpagetitle') : __('bar.addpagetitle') }}</h1>
            </div>
            <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        @if (isset($bar->id) && $bar->users->count() > 0)
                            <a tabindex="500" id="btnviewlawyer" href="{{ route('student.list') . '?bar_id=' . $bar->id }}"
                                class="btn btn-sm btn-info mr-1"> <span>{{ __('bar.viewalllawyers') }}</span></a>
                        @endif
                        <a tabindex="500" id="btncancel" href="{{ route('bar.index') }}"
                            class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em>
                            <span>{{ __('common.cancel') }}</span></a>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.save') }}</span></button>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.savecontinue') }}</span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            @csrf
            @if (isset($bar->id))
                @method('PUT')
            @endif
            <div class="row">
                <div class="col-md-12">
                    <h2>{{ __('bar.bar_content') }}</h2>
                </div>
                <div class="form-group col-md-6">
                    <label for="state_id">{{ __('bar.state_id') }}<span class="text-danger">*</span></label>
                    <select id="state_id" type="text"
                        class="form-control barfield @error('state_id') is-invalid @enderror" name="state_id" data-validator-label="state"
                        data-validator="required" tabindex="4">
                        <option value>Select {{ __('bar.state_id') }}</option>
                        @foreach ($states as $state_id => $state)
                            <option @if (old('state_id', $bar->state_id) == $state_id) selected="selected" @endif
                                value="{{ $state_id }}" data-name="{{ $state }}">{{ $state }}</option>
                        @endforeach
                    </select>
                    <input id="state_name" type="hidden" class="form-control @error('state_name') is-invalid @enderror"
                        name="state_name" value="{{ old('state_name', $bar->state_name) }}" tabindex="3">
                    <div class="errormessage">
                        @error('state_id')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="cycle_length">{{ __('bar.cycle_length') }}<span class="text-danger">*</span></label>
                    <select id="cycle_length" type="text"
                        class="form-control @error('cycle_length') is-invalid @enderror" name="cycle_length"
                        data-validator="required" tabindex="18">
                        <option value>Select {{ __('bar.cycle_length') }}</option>
                        @foreach (config('cyclelength') as $length)
                            <option value="{{ $length }}"
                                {{ (int) old('cycle_length', $bar->cycle_length) === $length ? 'selected' : '' }}>
                                {{ $length }}</option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('cycle_length')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-4">
                    <label for="hours_needed_per_cycle">{{ __('bar.hours_needed_per_cycle') }}<span
                            class="text-danger">*</span></label>
                    <input id="hours_needed_per_cycle" type="text"
                        class="form-control @error('hours_needed_per_cycle') is-invalid @enderror"
                        name="hours_needed_per_cycle"
                        value="{{ old('hours_needed_per_cycle', $bar->hours_needed_per_cycle) }}"
                        data-validator-label="hours needed per cycle" data-validator="required|max:100" data-mask='00000' tabindex="3">

                    <div class="errormessage"> @error('hours_needed_per_cycle')
                            {{ $message }}
                        @enderror
                    </div>
                </div>




                <div class="form-group col-md-4">
                    <label for="general">{{ __('bar.general') }}<span class="text-danger">*</span></label>
                    <input id="general" type="text"
                        class="form-control barfield @error('general') is-invalid @enderror" name="general"
                        data-validator="required" data-mask='00000' value="{{ old('general', $bar->general) }}" tabindex="4">

                    <div class="errormessage">
                        @error('general')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
                <div class="form-group col-md-4">
                    <label for="ethics">{{ __('bar.ethics') }}<span class="text-danger">*</span></label>
                    <input id="ethics" type="text" data-mask='00000' class="form-control barfield @error('ethics') is-invalid @enderror"
                        name="ethics" value="{{ old('ethics', $bar->ethics) }}" data-validator="required" tabindex="4">

                    <div class="errormessage">
                        @error('ethics')
                            {{ $message }}
                        @enderror
                    </div>

                </div>

                <div class="form-group col-md-6">
                    <label for="shortest_length_accepted">{{ __('bar.shortest_length_accepted') }}<span
                            class="text-danger">*</span></label>
                    <select id="shortest_length_accepted" type="text"
                        class="form-control @error('shortest_length_accepted') is-invalid @enderror"
                        name="shortest_length_accepted" data-validator="required" tabindex="18">
                        <option value>Select {{ __('bar.shortest_length_accepted') }}</option>
                        @foreach (config('lengthInMinutes') as $length)
                            <option value="{{ $length }}"
                                {{ (int) old('shortest_length_accepted', $bar->shortest_length_accepted) === $length ? 'selected' : '' }}>
                                {{ $length }}</option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('shortest_length_accepted')
                            {{ $message }}
                        @enderror
                    </div>
                </div>


                <div class="form-group col-md-6">
                    <label for="credit_upload_method">{{ __('bar.credit_upload_method') }}<span
                            class="text-danger">*</span></label>
                    <textarea id="credit_upload_method" type="text"
                        class="form-control @error('credit_upload_method') is-invalid @enderror" name="credit_upload_method"
                        data-validator="required" tabindex="4">{{ old('credit_upload_method', $bar->credit_upload_method) }}</textarea>
                    <div class="errormessage">
                        @error('credit_upload_method')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
                @if (isset($bar->id))
                    <div class="form-group col-md-6">
                        @component('admin.component.status_dropdown', [
                            'refModel' => 'bar',
                            'status' => $bar->status,
                            'required' => false,
                            'default' => 1,
                            'tabindex' => 5,
                        ])
                        @endcomponent
                    </div>
                @endif



                <div class="form-group col-md-6">
                    <label>{{ __('bar.voluntary_bar') }}</label>
                    <label class="switch ml-2">
                        @if (isset($bar->voluntary_bar) && $bar->voluntary_bar == 1)
                            {{ $checked = 1 }}
                        @else
                            {{ $checked = old('voluntary_bar') }}
                        @endif
                        <input type="checkbox" id="voluntary_bar" name="voluntary_bar" value="1"
                            {{ $checked != '' ? 'checked' : '' }} tabindex="4">
                        <span class="slider round"></span>
                    </label>
                    <div class="errormessage"> @error('voluntary_bar')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label>{{ __('bar.cle_mandatory') }}</label>
                    <label class="switch ml-2">
                        @if (isset($bar->cle_mandatory) && $bar->cle_mandatory == 1)
                            {{ $checkedcl = 1 }}
                        @else
                            {{ $checkedcl = old('cle_mandatory') }}
                        @endif
                        <input type="checkbox" id="cle_mandatory" name="cle_mandatory" value="1"
                            {{ $checkedcl != '' ? 'checked' : '' }} tabindex="4">
                        <span class="slider round"></span>
                    </label>
                    <div class="errormessage"> @error('cle_mandatory')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label>{{ __('bar.podcast_accepted') }}</label>
                    <label class="switch ml-2">
                        @if (isset($bar->podcast_accepted) && $bar->podcast_accepted == 1)
                            {{ $checkedpa = 1 }}
                        @else
                            {{ $checkedpa = old('podcast_accepted') }}
                        @endif
                        <input type="checkbox" id="podcast_accepted" name="podcast_accepted" value="1"
                            {{ $checkedpa != '' ? 'checked' : '' }} tabindex="4">
                        <span class="slider round"></span>
                    </label>
                    <div class="errormessage">
                        @error('podcast_accepted')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label>{{ __('bar.auto_credit_upload') }}</label>
                    <label class="switch ml-2">
                        @if (isset($bar->auto_credit_upload) && $bar->auto_credit_upload == 1)
                            {{ $checkedacu = 1 }}
                        @else
                            {{ $checkedacu = old('auto_credit_upload') }}
                        @endif
                        <input type="checkbox" id="auto_credit_upload" name="auto_credit_upload" value="1"
                            {{ $checkedacu != '' ? 'checked' : '' }} tabindex="4">
                        <span class="slider round"></span>
                    </label>
                    <div class="errormessage">
                        @error('auto_credit_upload')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
            </div>
            @if (Auth::user()->user_type_id == 1)

                <div class="row">
                    <div class="col-md-12">
                        <h2>{{ __('bar.subscription_details') }}</h2>
                    </div>
                    <div class="col-md-4 pl-0">
                        <div class="form-group col-md-12">
                            <label for="annual_price_stripe_price_id">{{ __('bar.annual_price_stripe_price_id') }}<span
                                    class="text-danger">*</span></label>
                            <select class="form-control" name="annual_price_stripe_price_id" id="annual_price_stripe_price_id" data-validator="required" @disabled(isset($bar->id))>
                                <option value>{{__('bar.select_annual_price_stripe_price_id')}}</option>
                                @foreach(retrieveStripePriceListByPriceForMetaData(config('priceformetadata')['annual_price']) as $prod)
                                    <option class="form-control" value="{{ $prod['product'] }}"
                                    {{old('annual_price_stripe_price_id', $bar->annual_price_stripe_price_id) === $prod['product'] ? 'selected' : '' }}>
                                        {{ getPricePrefix($prod['unit_amount_decimal']/100) }} ( {{$prod['metadata']['productName']}} )</option>
                                @endforeach
                                <option value="other" {{old('annual_price_stripe_price_id', $bar->annual_price_stripe_price_id) === 'other' ? 'selected' : '' }}>{{__('bar.add_annual_price_new_price')}}</option>
                            </select>
                            <div class="errormessage">
                                @error('annual_price_stripe_price_id')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>
                        <div class="form-group col-md-12 otherAnnualPriceOption">
                            <label for="other_annual_price_name">{{ __('bar.other_annual_price_name') }}<span class="text-danger">*</span></label>
                            <input id="other_annual_price_name" type="text"
                                class="form-control @error('other_annual_price_name') is-invalid @enderror" name="other_annual_price_name"
                                value="{{ old('other_annual_price_name', $bar->other_annual_price_name) }}" tabindex="7" @disabled(isset($bar->id))>
                            <div class="errormessage"> @error('other_annual_price_name')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>
                        <div class="form-group col-md-12 otherAnnualPriceOption">
                            <label for="other_annual_price_amount">{{ __('bar.other_annual_price_amount') }}<span class="text-danger">*</span></label>
                            <input id="other_annual_price_amount" type="text"
                                class="form-control @error('other_annual_price_amount') is-invalid @enderror" name="other_annual_price_amount"
                                value="{{ old('other_annual_price_amount', $bar->other_annual_price_amount) }}" tabindex="7" data-mask='00000' @disabled(isset($bar->id))>
                            <div class="errormessage"> @error('other_annual_price_amount')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 pl-0">
                        <div class="form-group col-md-12">
                            <label for="surcharge_fees_stripe_price_id">{{ __('bar.surcharge_fees_stripe_price_id') }}<span
                                    class="text-danger">*</span></label>
                            <select class="form-control" name="surcharge_fees_stripe_price_id" id="surcharge_fees_stripe_price_id" data-validator="required" @disabled(isset($bar->id))>
                                <option value>{{__('bar.select_surcharge_fees_stripe_price_id')}}</option>
                                @foreach(retrieveStripePriceListByPriceForMetaData(config('priceformetadata')['surcharge_fees']) as $prod)
                                    <option class="form-control" value="{{ $prod['product'] }}"
                                    {{old('surcharge_fees_stripe_price_id', $bar->surcharge_fees_stripe_price_id) === $prod['product'] ? 'selected' : '' }}>
                                        {{ getPricePrefix($prod['unit_amount_decimal']/100) }} ( {{$prod['metadata']['productName']}} )</option>
                                @endforeach
                                <option value="other" {{old('surcharge_fees_stripe_price_id', $bar->surcharge_fees_stripe_price_id) === 'other' ? 'selected' : '' }}>{{__('bar.add_surcharge_fees_new_price')}}</option>
                            </select>
                            <div class="errormessage">
                                @error('surcharge_fees_stripe_price_id')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>
                        <div class="form-group col-md-12 otherSurchrgeFeesOption">
                            <label for="other_surcharge_fees_name">{{ __('bar.other_surcharge_fees_name') }}<span class="text-danger">*</span></label>
                            <input id="other_surcharge_fees_name" type="text"
                                class="form-control @error('other_surcharge_fees_name') is-invalid @enderror" name="other_surcharge_fees_name"
                                value="{{ old('other_surcharge_fees_name', $bar->other_surcharge_fees_name) }}" tabindex="7" @disabled(isset($bar->id))>
                            <div class="errormessage"> @error('other_surcharge_fees_name')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>
                        <div class="form-group col-md-12 otherSurchrgeFeesOption">
                            <label for="other_surcharge_fees_amount">{{ __('bar.other_surcharge_fees_amount') }}<span class="text-danger">*</span></label>
                            <input id="other_surcharge_fees_amount" type="text"
                                class="form-control @error('other_surcharge_fees_amount') is-invalid @enderror" name="other_surcharge_fees_amount"
                                value="{{ old('other_surcharge_fees_amount', $bar->other_surcharge_fees_amount) }}" tabindex="7" data-mask='00000' @disabled(isset($bar->id))>
                            <div class="errormessage"> @error('other_surcharge_fees_amount')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 pl-0">
                        <div class="form-group col-md-12">
                            <label for="submission_fees_stripe_price_id">{{ __('bar.submission_fees_stripe_price_id') }}<span
                                    class="text-danger">*</span></label>
                            <select class="form-control" name="submission_fees_stripe_price_id" id="submission_fees_stripe_price_id" data-validator="required" @disabled(isset($bar->id))>
                                <option value>{{__('bar.select_submission_fees_stripe_price_id')}}</option>
                                @foreach(retrieveStripePriceListByPriceForMetaData(config('priceformetadata')['submission_fees']) as $prod)
                                    <option class="form-control" value="{{ $prod['product'] }}"
                                    {{old('submission_fees_stripe_price_id', $bar->submission_fees_stripe_price_id) === $prod['product'] ? 'selected' : '' }}>
                                        {{ getPricePrefix($prod['unit_amount_decimal']/100) }} ( {{$prod['metadata']['productName']}} )</option>
                                @endforeach
                                <option value="other" {{old('submission_fees_stripe_price_id', $bar->submission_fees_stripe_price_id) === 'other' ? 'selected' : '' }}>{{__('bar.add_submission_fees_new_price')}}</option>
                            </select>
                            <div class="errormessage">
                                @error('submission_fees_stripe_price_id')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>
                        <div class="form-group col-md-12 otherSubmissionFeesOption">
                            <label for="other_submission_fees_name">{{ __('bar.other_submission_fees_name') }}<span class="text-danger">*</span></label>
                            <input id="other_submission_fees_name" type="text"
                                class="form-control @error('other_submission_fees_name') is-invalid @enderror" name="other_submission_fees_name"
                                value="{{ old('other_submission_fees_name', $bar->other_submission_fees_name) }}" tabindex="7" @disabled(isset($bar->id))>
                            <div class="errormessage"> @error('other_submission_fees_name')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>
                        <div class="form-group col-md-12 otherSubmissionFeesOption">
                            <label for="other_submission_fees_amount">{{ __('bar.other_submission_fees_amount') }}<span class="text-danger">*</span></label>
                            <input id="other_submission_fees_amount" type="text"
                                class="form-control @error('other_submission_fees_amount') is-invalid @enderror" name="other_submission_fees_amount"
                                value="{{ old('other_submission_fees_amount', $bar->other_submission_fees_amount) }}" tabindex="7" data-mask='00000' @disabled(isset($bar->id))>
                            <div class="errormessage"> @error('other_submission_fees_amount')
                                    {{ $message }}
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </form>

    <script>
        $(document).ready(function() {

            // $('#frmaddedit').submit(function(e){
            //     e.preventDefault();
            //     if(confirm("Are you sure you want to submit this form?")) {
            //         this.submit();
            //     } else {
            //         return false;
            //     }
            // });

            //hide if value is not other
            if($('#annual_price_stripe_price_id').val() != 'other'){
                $('.otherAnnualPriceOption').hide();
            }
            if($('#surcharge_fees_stripe_price_id').val() != 'other'){
                $('.otherSurchrgeFeesOption').hide();
            }
            if($('#submission_fees_stripe_price_id').val() != 'other'){
                $('.otherSubmissionFeesOption').hide();
            }

            //Manage or add new option or other option based on annual price of other
            $(document).on('change', '#annual_price_stripe_price_id', function(data) {
                var selectedValue = this.value;
                $("#other_annual_price_name").val('');
                $("#other_annual_price_amount").val('');
                if (selectedValue === 'other') {
                    $('.otherAnnualPriceOption').show();
                    let selectedOption = $('#state_id').find('option:selected');
                    let dataNameValue = selectedOption.data('name') || '';
                    $('#other_annual_price_name').val('{{getEnvPrefix()}}'+'Annual Price-'+ dataNameValue);
                    $('#other_annual_price_name').attr("data-validator", "required|max:100");
                    $('#other_annual_price_amount').attr("data-validator", "required|max:100");
                }else{
                    $('.otherAnnualPriceOption').hide();
                    $('.otherAnnualPriceOption input').each(function(i) {
                        $(this).removeAttr("data-validator");
                        $(this).removeClass("is-invalid");
                    });
                }
            });

            //Manage or add new option or other option based on surcharge fees of other
            $(document).on('change', '#surcharge_fees_stripe_price_id', function(data) {
                var selectedValue = this.value;
                $("#other_surcharge_fees_name").val('');
                $("#other_surcharge_fees_amount").val('');
                if (selectedValue === 'other') {
                    $('.otherSurchrgeFeesOption').show();
                    let selectedOption = $('#state_id').find('option:selected');
                    let dataNameValue = selectedOption.data('name') || '';
                    $('#other_surcharge_fees_name').val('{{getEnvPrefix()}}'+'Surcharge Fees-'+ dataNameValue);
                    $('#other_surcharge_fees_name').attr("data-validator", "required|max:100");
                    $('#other_surcharge_fees_amount').attr("data-validator", "required|max:100");
                }else{
                    $('.otherSurchrgeFeesOption').hide();
                    $('.otherSurchrgeFeesOption input').each(function(i) {
                        $(this).removeAttr("data-validator");
                        $(this).removeClass("is-invalid");
                    });
                }
            });

            //Manage or add new option or other option based on submission fees of other
            $(document).on('change', '#submission_fees_stripe_price_id', function(data) {
                var selectedValue = this.value;
                $("#other_submission_fees_name").val('');
                $("#other_submission_fees_amount").val('');
                if (selectedValue === 'other') {
                    $('.otherSubmissionFeesOption').show();
                    let selectedOption = $('#state_id').find('option:selected');
                    let dataNameValue = selectedOption.data('name') || '';
                    $('#other_submission_fees_name').val('{{getEnvPrefix()}}'+'Submission Fees-'+ dataNameValue);
                    $('#other_submission_fees_name').attr("data-validator", "required|max:100");
                    $('#other_submission_fees_amount').attr("data-validator", "required|max:100");
                }else{
                    $('.otherSubmissionFeesOption').hide();
                    $('.otherSubmissionFeesOption input').each(function(i) {
                        $(this).removeAttr("data-validator");
                        $(this).removeClass("is-invalid");
                    });
                }
            });
        });
    </script>
@endsection

