@extends('admin.layouts.app')
@section('content')
    @if ($errors->any())
        {!! implode('', $errors->all('<div class="d-none">:message</div>')) !!}
    @endif
    <form method="POST" action="{{ route('proctoring.update', $proctoring->id) }}" name="frmaddedit" id="frmaddedit"
        class="formCustomEdit">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6 px-2">
                <h1 class="page-title pb-0">
                    {{ isset($proctoring->id) ? __('proctoring.editpagetitle') : __('proctoring.addpagetitle') }}</h1>
                <h5 class="font-weight-bold lh-26"><span class="text-secondary">Course Name:</span>
                    {{ $proctoring->coursename }}</h5>
            </div>
            <div class="col-lg-6 px-2 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        <a tabindex="500" id="btncancel" href="{{ route('proctoring.index') }}"
                            class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em>
                            <span>{{ __('common.cancel') }}</span></a>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.save') }}</span></button>
                    </div>
                </div>
            </div>
        </div>
        @csrf
        @if(isset($proctoring->id)) @method('PUT') @endif
    <section class="w-100 position-relative pb-5">
        <div class="container">
            <div class="row mx-0 d-flex align-items-stretch">
                <div class="col-xl-5 col-lg-4 col-md-6 col-sm-6 col-12 px-2">
                    <div class="bg-white shadow-sm h-100">
                        <figure class="proctoring-lg-thumb rounded mb-0">
                            <img src="{{ $documentImage }}" alt="{{ siteconfig('app_name', 0) }}"
                                class="js-restricted-image img-fluid rounded">
                            <figcaption class="d-none">
                                <h4><span>Student ID</span> 3762DKSH</h4>
                            </figcaption>
                        </figure>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-4 col-md-6 col-sm-6 col-12 px-2 mt-sm-0 mt-3">
                    <div id="js-append-thumb" class="bg-white shadow-sm rounded h-100 studentThumb">
                        <figure class="mb-0">
                            <img src="{{ asset('assets/admin/images/placeholder-img.png') }}"
                                alt="{{ siteconfig('app_name', 0) }}" class="img-fluid">
                            <figcaption class="d-none">
                                <h4><span>Student Image</span> 3762DKSH</h4>
                            </figcaption>
                        </figure>
                    </div>
                </div>

                <div class="col-xl-2 col-lg-4 col-md-12 col-sm-12 col-12 px-2 mt-lg-0 mt-3">
                    <div class="p-3 bg-white shadow-sm rounded h-100">
                        <div class="position-relative pb-1">
                            <h6 class="mb-1 text-secondary">Student Name</h6>
                            <h5 class="font-weight-bold">{{ $proctoring->studentname }}</h5>
                        </div>
                        <div class="form-group mb-0 border-top pt-1">
                            <label for="statuscontrol">Select Status</label>
                            @php $selected_value = 0 @endphp
                            @if (!is_null(old('status',$proctoring->status)))
                                @php $selected_value = old('status',$proctoring->status); @endphp
                            @endif
                            <select name="status" class="form-control rounded" id="statuscontrol">
                                @foreach (config('protoringstatus') as $key => $method)
                                    <option  @if ($selected_value == $key) {{ 'selected=selected' }} @endif
                                    value="{{ $key }}">{{ $method }}</option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                </div>

            </div>
            <!--End Row-->

            <div class="row mx-0 mt-lg-0 mt-3">
                <div class="col-md-12 mt-3 position-relative">
                    <div id="js-thumbSlider" class="owl-carousel owl-theme arrow-circle">
                        @if (!empty($captureImages))
                            @foreach ($captureImages as $image)
                                <div class="item">
                                    <div class="position-relative slider-proctoring">
                                        <figure class="mb-0">
                                            <img src="{{ getImageUrl($image, 'capture_image') }}" alt="{{ $image }}"
                                                class="img-fluid rounded">
                                            <figcaption class="d-none">
                                                <h4><span>Student Image</span> 3762DKSH</h4>
                                            </figcaption>
                                        </figure>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
            <!--End Row-->
        </div>
    </section>
    </form>
@endsection
@section('extra-js')
    <script>
        $(document).ready(function() {
            $(".slider-proctoring").on("click", function(e) {
                e.target.nodeName === "IMG";
                $("#js-append-thumb").empty();
                var appendThummb = $(this).clone();
                $("#js-append-thumb").append(appendThummb);

            });
            $(".slider-proctoring:first").click();

            $('#js-thumbSlider').owlCarousel({
                loop: false,
                nav: true,
                dots: false,
                autoplay: false,
                autoplayTimeout: 5000,
                autoplayHoverPause: true,
                responsiveClass: true,
                responsive: {
                    0: {
                        items: 2,
                        nav: true,
                        dots: false,
                        margin: 10
                    },
                    600: {
                        items: 3,
                        nav: true,
                        dots: false,
                        margin: 10
                    },
                    1000: {
                        items: 5,
                        nav: true,
                        dots: false,
                        margin: 10
                    },
                    1200: {
                        items: 5,
                        nav: true,
                        dots: false,
                        margin: 10
                    },

                }
            });
        })
    </script>
@endsection
