@extends('admin.layouts.app')
@section('content')
<div class="row mx-0 mb-3">
    <div class="col-6">
        <h1 class="page-title"><?php echo __('proctoring.pagetitle'); ?></h1>
    </div>
    <div class="top-btn-box col-6" id="normal_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
            <a tabindex="1" href="javascript:void(0)" class="btn search-btn btn-sm show hide btn-primary mr-1" id="search-btn">
                <em class="icon-search-icon top-icon"></em>
                <span class="btn-title">{{ __('common.search') }}</span>
            </a>
        </div>
    </div>
</div>
<div class="col-12 admin-holder">
    <div class="row">
        <div class="{{  Request::has('search') ? 'show' : 'hide' }}" id="searchbox">
            <form name="frmsearch" id="frmsearch" action="{{ $proctorings->appends(prepareInputRequestArray())->url(1) }}" method="GET" class="col-12">
                @foreach (Request::all() as $key=>$value)
                @if (in_array($key,['search','status','btnsearch']))
                @continue
                @else
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endif
                @endforeach
                <div class="row">
                    <div class="form-proctoring col-md-6 col-12">
                        <label>{{ __('proctoring.coursename') ." / ". __('proctoring.studentname') }}</label>
                        <input tabindex="3" name="search" id="search" placeholder="{{ __('common.search') ." ". __('proctoring.coursename') ." / ". __('proctoring.studentname') }}" type="text" class="form-control" value="{{ Request::get('search') }}">
                    </div>
                    <div class="form-proctoring col-12 mt-3">
                        <button tabindex="5" type="submit" class="btn submit-btn btn-primary mr-1" id="btnsearch" name="btnsearch">{{ __('common.search') }}</button>
                        <a href="{{ route('proctoring.index', ['search' => '', 'status' => '']) }}" class="btn btn-primary reset-btn">{{ __('common.reset') }}</a>
                        <button tabindex="7" type="button" class="btn close-btn btn-dark" id="search-btn-h">{{ __('common.close') }}</button>
                        <hr>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-12 photos-main">
            <section id="wrapper">
                <div class="table-responsive">
                    <table data-orders="5" data-target="1" defaultdir="desc" class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                        <thead>
                            <tr>
                                <th class="hide" scope="col">

                                </th>
                                <th scope="col" class="control nosort">
                                    <!-- this blank column is responsive controll -->
                                </th>
                                <th scope="col">
                                    <span>{{ __('proctoring.coursename') }}</span>
                                </th>
                                <th scope="col">
                                    <span>{{ __('proctoring.studentname') }}</span>
                                </th>
                                <th scope="col">
                                    <span>{{ __('proctoring.status') }}</span>
                                </th>
                                <th scope="col">
                                    <span>{{ __('proctoring.updated-at') }}</span>
                                </th>
                                @if(canUserAccess('manage-proctoring'))
                                <th class="text-right nosort" scope="col">{{__('common.action')}}</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($proctorings as $proctoring)
                            <tr>
                                <td class="active-box hide">
                                    <em style="display:none">{{$proctoring->id}}</em>
                                </td>
                                
                                <td></td>
                                <td>
                                    {{ $proctoring->coursename }}
                                </td>
                                <td>
                                    {{ $proctoring->studentname }}
                                </td>
                                <td>
                                    {{ config('protoringstatus')[$proctoring->status] }}
                                </td>
                                <td data-sort="{{ \Carbon\Carbon::parse( $proctoring->updated_at)->format('Y/m/d H:i:s')}}">
                                    {{ $proctoring->updated_at  }}
                                </td>
                                @if(canUserAccess('manage-proctoring'))
                                <td class="text-right">
                                    <a href="{{ route('proctoring.edit',$proctoring->id) }}"><em class="icon-edit-icon left"></em></a>
                                </td>
                                @endif
                            </tr>
                            @endforeach
                            @if ($proctorings->total() == 0)
                            <tr class="noreocrd">
                                <td colspan="9" class="text-center">
                                    {{ __('proctoring.no_result') }}
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection