@extends('admin.layouts.app')
@section('content')
    <div class="row mx-0 mb-3">
        <div class="col-6">
            <h1 class="page-title"><?php echo __('contact-us.pagetitle'); ?></h1>
        </div>
        <div class="top-btn-box col-6" id="normal_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
                <a tabindex="1" href="javascript:void(0)" class="btn btn-primary mr-1 search-btn btn-sm show hide"
                    id="search-btn">
                    <em class="icon-search-icon top-icon"></em>
                    <span class="btn-title">{{ __('common.search') }}</span>
                </a>
            </div>
        </div>

        <div class="top-btn-box hide col-6" id="action_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
                <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');"
                    id="delete-btn" title="{{ __('common.delete') }}">
                    <em class="icon-close-icon top-icon"></em>
                    <span class="btn-title">{{ __('common.delete') }}</span>
                </a>
            </div>

        </div>
    </div>

    <div class="col-12 admin-holder">
        <div class="row">
            <div class="{{ Request::has('search') ? 'show' : 'hide' }}" id="searchbox">
            <form name="frmsearch" id="frmsearch" action="{{ $contacts->appends(prepareInputRequestArray())->url(1) }}"
                method="GET" class="col-12">
                @foreach (Request::all() as $key => $value)
                @if (in_array($key, ['search', 'status', 'btnsearch']))
                @continue
                @else
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endif
                @endforeach
                <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label>{{ __('contact-us.name') }} / {{ __('contact-us.email') }} / {{ __('contact-us.phone_number') }}</label>
                        <input tabindex="3" name="search" id="search"
                            placeholder="{{ __('common.search') ." ". __('contact-us.pagetitle') }}" type="text"
                            class="form-control rounded" value="{{ Request::get('search') }}">
                    </div>


                    <div class="form-group col-12">
                        <button tabindex="6" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                            name="btnsearch">{{ __('common.search') }}</button>
                        <a href="{{ $reset_link }}"
                            class="btn btn-primary reset-btn" id="search_reset">{{ __('common.reset') }}</a>
                        <button tabindex="7" type="button" class="btn btn-dark close-btn"
                            id="search-btn-h">{{ __('common.close') }}</button>
                        <hr>
                    </div>
                </div>
            </form>
        </div>

            <div class="col-12 photos-main">
                <section id="wrapper">
                    <form name="frmlist" id="frmlist" action="{{ route('contact-us.bulkaction') }}" method="POST">
                        @csrf
                        <input type="hidden" name="bulk-action" value="">
                        <div class="table-responsive">
                        <table data-orders="1" data-target="@if (canUserAccess('manage-contactus')) 3 @else 1 @endif"
                            class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                            <thead>
                                <tr>
                                    <th class="hide" scope="col">
                                        <!-- this blank column is for primary column -->

                                    </th>
                                    @if (canUserAccess('manage-contactus'))
                                    <th class="active-box"></th>
                                        <th class="check-box nosort" scope="col">
                                            <div class="custom-control custom-checkbox text-center">
                                                <input type="checkbox" class="custom-control-input" name="selectAll"
                                                    id="selectAll" onclick="checkAll();">
                                                <label class="custom-control-label" for="selectAll"></label>
                                            </div>
                                        </th>
                                    @endif
                                    <th scope="col" class="control nosort">
                                        <!-- this blank column is responsive controll -->

                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('contact-us.first_name') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('contact-us.last_name') }}
                                            </span>
                                        </div>
                                    </th>

                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('contact-us.phone_number') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('contact-us.email') }}
                                            </span>
                                        </div>
                                    </th>

                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('contact-us.created_at') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('contact-us.comment') }}
                                            </span>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($contacts as $contact)
                                    <tr>
                                        <td class="active-box hide">
                                            <em style="display:none">{{$contact->id}}</em>
                                        </td>
                                        @if (canUserAccess('manage-contactus'))
                                        <td></td>
                                            <td class="check-box">
                                                <div class="custom-control custom-checkbox text-center">
                                                    <input type="checkbox" class="custom-control-input chkbox action-checkbox" id="filled-in-box_{{ $contact->id }}" name="id[]" value="{{$contact->id}}">
                                                    <label class="custom-control-label" for="filled-in-box_{{ $contact->id }}"></label>
                                                </div>
                                            </td>
                                        @endif
                                        <td></td>
                                        <td>{{ $contact->first_name }}</td>
                                        <td>{{ $contact->last_name }}</td>
                                        <td>{{ formatPhoneNumber($contact->phone_number) }}</td>

                                        <td>
                                            <div class="email-add"><a
                                                    href="mailto:{{ $contact->email }}">{{ $contact->email }}</a>
                                            </div>
                                        </td>

                                        <td
                                            data-sort="{{ \Carbon\Carbon::parse($contact->created_at)->format('Y/m/d H:i:s') }}">
                                            {{ $contact->created_at }}</td>

                                        <td><p>{{ $contact->comment }}</p></td>

                                    </tr>
                                @endforeach
                                @if ($contacts->total() == 0)
                                    <tr class="noreocrd">
                                        <td colspan="10" class="text-center">

                                            {{ __(Request::segment(2) . '.no_result') }}
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        </div>
                    </form>
                </section>
            </div>
        </div>
    </div>
@endsection
