@extends('admin.layouts.app')
@section('content')
    <form method="post" action="{{ isset($content->id) ? route('content.update', $content->id) : route('content.store') }}"
        name="frmaddedit" id="frmaddedit">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6">
                <h1 class="content-title">
                    {{ isset($content->id) ? __('content.editpagetitle') : __('content.addpagetitle') }}</h1>
            </div>
            <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        <a tabindex="500" id="btncancel" href="{{ route('content.index') }}"
                            class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em>
                            <span>{{ __('common.cancel') }}</span></a>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1 formbtnsave" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.save') }}</span></button>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.savecontinue') }}</span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            @csrf
            @if (isset($content->id))
                @method('PUT')
            @endif
            <div class="row">
                <div class="col-md-12">
                    <h2>{{ __('content.content_content') }}</h2>
                </div>
                {{-- <div class="form-group col-md-6">
                    <label>{{ __('content.content_type') }}</label>
                    <label class="switch ml-2">
                        @if (isset($content->content_type) && $content->content_type == 1)
                            {{ $checked = 1 }}
                        @else
                            {{ $checked = old('content_type') }}
                        @endif
                        <input type="checkbox" id="content_type" name="content_type" value="1"
                            {{ $checked != '' ? 'checked' : '' }} tabindex="4">
                        <span class="slider round"></span>
                    </label>
                    <div class="errormessage"> @error('content_type')
                            {{ $message }}
                        @enderror
                    </div>

                </div>

                <div class="form-group col-md-6">
                    <div class="row">
                        <div class="col-md-12 banner-section">
                            <div class="form-group @if (old('content_type', $content->content_type) == '1') d-none @endif" id="singleupload">
                                <label for="temp_upload_file">{{ __('content.upload_file') }}<span
                                        class="text-danger">*</span></label>
                                <input type="file" id="temp_upload_file"
                                    data-size="{{ getImageUploadSizeInMB('upload_file') }}" class="dropify image-upload"
                                    name="temp_upload_file" data-folder="upload_file" tabindex="17"
                                    {{ old('upload_file', $content->upload_file) != '' ? 'data-default-file=' . getImageUrl(old('upload_file', $content->upload_file), 'upload_file') : '' }}
                                    tabindex="6" data-extension="mp3,oga,ogg,wav">
                                <div><small>{{ getImageRecommendedSize('upload_file') }}</small></div>
                                <input name="upload_file" type="hidden"
                                    value="{{ old('upload_file', $content->upload_file) }}">
                                <div id="error_upload_file"
                                    class="errormessage  @error('upload_file') @else{{ 'd-none' }} @enderror">
                                    @error('upload_file')
                                        {{ $message }}
                                    @enderror
                                </div>
                                <div class="table-responsive mt-4">
                                    @isset($content)
                                        @foreach (json_decode($content->upload_file) ?? [] as $file)
                                            <tr>
                                                <td>
                                                    <a href="{{ getImageUrl($file, 'upload_file') }}"
                                                        target="_blank">{{ $file }}</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endisset
                                </div>
                            </div>
                            <div id="basic-uploader-audio" style="padding-top: 15px;"
                                @if (old('content_type', $content->content_type) == '0') class="d-none" @elseif(empty(old('content_type', $content->content_type))) class="d-none" @endif>
                                <div class="row fileupload-buttonbar mb-1">
                                    <div class="col-lg-7">
                                        <!-- The fileinput-button span is used to style the file input field as button -->
                                        <span class="btn btn-success fileinput-button" id="addfiles_audio">
                                            <em class="glyphicon glyphicon-plus"></em>
                                            <span>Add files...</span>
                                            <input type="file" name="files[]" multiple>
                                        </span>
                                        <button type="submit" id="startall" class="btn btn-primary start">
                                            <em class="glyphicon glyphicon-upload"></em>
                                            <span>Start Upload</span>
                                        </button>
                                        <span class="fileupload-process"></span>
                                    </div>
                                    <!-- The global progress state -->
                                    <div class="col-lg-5 fileupload-progress">
                                        <!-- The global progress bar -->
                                        <div class="progress progress-striped active hide" role="progressbar"
                                            aria-valuemin="0" aria-valuemax="100">
                                            <div class="progress-bar progress-bar-success" style="width:0%;"></div>
                                        </div>
                                        <!-- The extended global progress state -->
                                        <div class="progress-extended">&nbsp;</div>
                                    </div>
                                    <div class="col-lg-12">
                                        <em class="text-muted"><small>{{ getImageRecommendedSize('upload_file') }}
                                            </small></em>
                                    </div>
                                </div>

                                <!-- dropzone -->
                                <div class="dropzone table-layout well mb-2 d-flex justify-content-center align-items-center"
                                    style="box-shadow:none;border-style:dashed;height:200px;">
                                    <div class="col-xs-11 text-center">
                                        <h3 class="text-muted"><em class="ico-file-plus2 mr5"></em> Drag and drop your file
                                            here!</h3>
                                    </div>
                                </div>

                                <!-- file list -->
                                <div class="table-responsive">
                                    <table class="table table-striped table-hovered upload-lists"
                                        aria-describedby="DataTableDesc">
                                        <thead style="display:none">
                                            <tr>
                                                <th scope="col"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="files">
                                            @isset($content)
                                                @foreach (json_decode($content->upload_file) ?? [] as $file)
                                                    <tr>
                                                        <td>
                                                            <a href="{{ getImageUrl($file, 'upload_file') }}"
                                                                target="_blank">{{ $file }}</a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @endisset

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <p class="text-primary single-audio-upload-file-name">Uploaded File name : <span
                                    class="fw-bold" id="single-audio-upload-file-name"></span></p>
                        </div>
                    </div>
                </div> --}}

                <div class="form-group col-md-6">
                    <label for="podcast_title">{{ __('content.podcast_title') }}<span class="text-danger">*</span></label>
                    <input id="podcast_title" type="text"
                        class="form-control @error('podcast_title') is-invalid @enderror" name="podcast_title"
                        value="{{ old('podcast_title', $content->podcast_title) }}" data-validator="required|max:100"
                        tabindex="1">

                    <div class="errormessage"> @error('podcast_title')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6" style="visibility:hidden;">
                    <label for="internal_cl_podcast_id">{{ __('content.internal_cl_podcast_id') }}<span
                            class="text-danger">*</span></label>
                    <input id="internal_cl_podcast_id" type="text"
                        class="form-control @error('internal_cl_podcast_id') is-invalid @enderror"
                        name="internal_cl_podcast_id"
                        value="{{ old('internal_cl_podcast_id', $content->internal_cl_podcast_id) }}"
                        data-validator="required|max:100" tabindex="2" disabled>

                    <div class="errormessage"> @error('internal_cl_podcast_id')
                            {{ $message }}
                        @enderror
                    </div>
                </div>


                <div class="form-group col-md-12">
                    <label for="short_description">{{ __('content.short_description') }}</label>
                    <textarea id="short_description" type="text" class="form-control @error('short_description') is-invalid @enderror"
                        name="short_description" tabindex="3">{{ old('short_description', $content->short_description) }}</textarea>
                    <div class="errormessage">
                        @error('short_description')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="provider_type">{{ __('content.provider_type') }}
                        <span class="text-danger">*
                            <div id="tooltip" class="tooltip"></div>
                            <img src={{ asset('assets/admin/images/info-black-popup.svg') }}
                                onclick="showTitle(this, event)">
                        </span>
                    </label>

                    <select id="provider_type" type="text"
                        class="form-control contentfield @error('provider_type') is-invalid @enderror" name="provider_type"
                        data-validator="required" tabindex="4">
                        <option value>Select {{ __('content.provider_type') }}</option>
                        @foreach (config('provider_type') as $value => $label)
                            <option value="{{ $value }}"
                                {{ (int) old('provider_type', $content->provider_type) === $value ? 'selected' : '' }}>
                                {{ $label }}</option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('provider_type')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="provider_id">{{ __('content.provider_id') }}<span class="text-danger">*</span></label>
                    <input type="hidden" id="selected_provider_id"
                        value="{{ old('provider_id', $content->provider_id) }}">

                    <select id="provider_id" type="text"
                        class="form-control contentfield @error('provider_id') is-invalid @enderror" name="provider_id"
                        data-validator="required" tabindex="5">
                        <option value>Select {{ __('content.provider_id') }}</option>
                        @foreach ($providersList as $value => $label)
                            <option value="{{ $value }}"
                                {{ old('provider_id', $content->provider_id) === $value ? 'selected' : '' }}>
                                {{ $label }}</option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('provider_id')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div id="otherOption" style="display: none;" class="form-group col-md-6">
                    <label for="provider_name">{{ __('content.provider_name') }}<span class="text-danger">*</span></label>
                    <input id="provider_name" type="text"
                        class="form-control @error('provider_name') is-invalid @enderror" name="provider_name"
                        value="{{ old('provider_name', $content->provider_name) }}" tabindex="6">

                    <div class="errormessage"> @error('provider_name')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6" style="display:none">
                    <label for="file_type">{{ __('content.file_type') }}<span class="text-danger">*</span></label>
                    <select id="file_type" type="text"
                        class="form-control contentfield @error('file_type') is-invalid @enderror" name="file_type"
                        data-validator="required" tabindex="7">
                        <option value>Select {{ __('content.file_type') }}</option>
                        @foreach (config('file_type') as $value => $label)
                            <option value="{{ $value }}"
                                {{ (int) old('file_type', $content->file_type) === $value || $value == 1 ? 'selected' : '' }}>
                                {{ $label }}</option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('file_type')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label for="speaker">{{ __('content.speaker') }}<span class="text-danger">*</span></label>
                    <input type="hidden" id="selected_speaker" value="{{ old('speaker', $content->speaker) }}">

                    <select id="speaker" class="form-control selectpicker @error('speaker') is-invalid @enderror"
                        name="speaker[]" multiple data-live-search="true" title="Select Speakers"
                        data-validator="required" tabindex="5">
                        @php
                            $selectedSpeakers = isset($podcastSpeakers)
                                ? $podcastSpeakers->pluck('speaker_id')->toArray()
                                : [];
                        @endphp

                        @foreach ($faculty as $value)
                            <option value="{{ $value->id }}"
                                {{ in_array($value->id, old('speaker', $selectedSpeakers)) ? 'selected' : '' }}>
                                {{ $value->name }}
                            </option>
                        @endforeach

                    </select>

                    <div class="errormessage">
                        @error('speaker')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <!-- Add Speaker Modal -->
                <div class="modal fade" id="addSpeakerModal" tabindex="-1" role="dialog"
                    aria-labelledby="addSpeakerModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="addSpeakerModalLabel">Add New Speaker</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <label for="newSpeakerName">Speaker Name<span class="text-danger">*</span></label>
                                <input type="text" id="newSpeakerName" class="form-control"
                                    placeholder="Enter speaker name">

                                <div class="errormessage">
                                    <span id="namefounderror" class="text-danger"></span>
                                </div>
                                <label for="newSpeakerEmail">Speaker Email<span class="text-danger">*</span></label>
                                <input type="text" id="newSpeakerEmail" class="form-control"
                                    placeholder="Enter speaker email">

                                <div class="errormessage">
                                    <span id="emailfounderror" class="text-danger"></span>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                <button type="button" id="saveSpeaker" class="btn btn-primary">Save Speaker</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label for="category_id">{{ __('content.category') }}<span class="text-danger">*</span></label>
                    <select id="category_id" class="form-control contentfield @error('category') is-invalid @enderror"
                        name="category_id" data-validator="required" tabindex="8">
                        <option value>Select {{ __('content.category') }}</option>
                        @foreach ($categories as $category)
                            <option value="{{ $category->id }}"
                                {{ isset($content->category_id) ? ($content->category_id == $category->id ? 'selected' : '') : '' }}>
                                {{ $category->name ?? '' }}</option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('category_id')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="cl_type">{{ __('content.cl_type') }}<span class="text-danger">*</span></label>
                    <select id="cl_type" type="text"
                        class="form-control contentfield @error('cl_type') is-invalid @enderror" name="cl_type"
                        data-validator="required" tabindex="9">
                        <option value>Select {{ __('content.cl_type') }}</option>
                        @foreach (config('cl_type') as $value => $label)
                            <option value="{{ $value }}"
                                {{ (int) old('cl_type', $content->cl_type) === $value ? 'selected' : '' }}>
                                {{ $label }}</option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('cl_type')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label>{{ __('content.expire_date') }}</label>
                    <input id="expire_date" type="text"
                        class="form-control datepicker @error('expire_date') is-invalid @enderror" name="expire_date"
                        value="{{ old('expire_date', $content->expire_date != null ? \Carbon\Carbon::parse($content->expire_date)->format(config('app.db_date_format')) : null) }}"
                        tabindex="11">
                    <div class="errormessage">
                        @error('expire_date')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6">
                    @component('admin.component.status_dropdown', [
                        'refModel' => 'content',
                        'status' => $content->status,
                        'required' => false,
                        'default' => 1,
                        'tabindex' => 12,
                    ])
                    @endcomponent
                </div>

                <div class="form-group col-md-6">
                    <label>{{ __('content.published_on') }}</label>
                    <input id="published_on" type="text"
                        class="form-control datetimepicker @error('published_on') is-invalid @enderror"
                        name="published_on" value="{{ old('published_on', $content->published_on) }}" tabindex="11">
                    <div class="errormessage" id="published_on_error">
                        @error('published_on')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-12">
                    <label for="prerequisites">{{ __('content.prerequisites') }}</label>
                    <textarea id="prerequisites" type="text" class="form-control @error('prerequisites') is-invalid @enderror"
                        name="prerequisites" value="{{ old('prerequisites', $content->prerequisites) }}" tabindex="10"maxlength="240"></textarea>
                    <div class="errormessage">
                        @error('prerequisites')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="col-md-12 banner-section">
                    <div class="form-group">
                        <label for="temp_image">{{ __('content.image') }}</label>
                        <input type="file" id="temp_image" data-size="{{ getImageUploadSizeInMB('coursecategory') }}"
                            class="dropify image-upload" name="temp_image" data-folder="content"
                            {{ old('image', $content->image) != '' ? 'data-default-file=' . getImageUrl(old('image', $content->image), 'content') : '' }}
                            tabindex="14">
                        <div><small>{{ getImageRecommendedSize('coursecategory') }}</small></div>
                        <input name="image" type="hidden" value="{{ old('image', $content->image) }}">
                        <div id="error_image" class="errormessage  @error('image') @else{{ 'd-none' }} @enderror">
                            @error('image')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="image_alt">{{ __('content.image_alt') }}</label>
                    <input id="image_alt" type="text" class="form-control @error('image_alt') is-invalid @enderror"
                        name="image_alt" value="{{ old('image_alt', $content->image_alt ?? '') }}" tabindex="13">
                    <div class="errormessage">
                        @error('image_alt')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <h2>{{ __('content.upload_file') }}</h2>
                </div>
                <div class="form-group col-md-12">
                    <div class="banner-section">
                        {{-- <div class="form-group @if (old('content_type', $content->content_type) == '1') d-none @endif" id="singleupload">
                            <label for="temp_upload_file">{{ __('content.upload_file') }}<span
                                    class="text-danger">*</span></label>
                            <input type="file" id="temp_upload_file"
                                data-size="{{ getImageUploadSizeInMB('upload_file') }}" class="dropify image-upload"
                                name="temp_upload_file" data-folder="upload_file" tabindex="17"
                                {{ old('upload_file', $content->upload_file) != '' ? 'data-default-file=' . getImageUrl(old('upload_file', $content->upload_file), 'upload_file') : '' }}
                                tabindex="6" data-extension="mp3,oga,ogg,wav">
                            <div><small>{{ getImageRecommendedSize('upload_file') }}</small></div>
                            <input name="upload_file" type="hidden"
                                value="{{ old('upload_file', $content->upload_file) }}">
                            <div id="error_upload_file"
                                class="errormessage  @error('upload_file') @else{{ 'd-none' }} @enderror">
                                @error('upload_file')
                                    {{ $message }}
                                @enderror
                            </div>
                            <div class="table-responsive mt-4">
                                @isset($content)
                                    @foreach (json_decode($content->upload_file) ?? [] as $file)
                                        <tr>
                                            <td>
                                                <a href="{{ getImageUrl($file, 'upload_file') }}"
                                                    target="_blank">{{ $file }}</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endisset
                            </div>
                        </div> --}}
                        {{-- <div id="basic-uploader-audio" style="padding-top: 15px;"
                            @if (old('content_type', $content->content_type) == '0') class="d-none" @elseif(empty(old('content_type', $content->content_type))) class="d-none" @endif> --}}
                        <div id="basic-uploader-audio" style="padding-top: 15px;">
                            <div class="row fileupload-buttonbar mb-1">
                                <div class="col-lg-7">
                                    <!-- The fileinput-button span is used to style the file input field as button -->
                                    <span class="btn btn-success fileinput-button" id="addfiles_audio">
                                        <em class="glyphicon glyphicon-plus"></em>
                                        <span>Add files...</span>
                                        <input type="file" name="files[]" multiple>
                                    </span>
                                    <button type="submit" id="startall" class="btn btn-primary start">
                                        <em class="glyphicon glyphicon-upload"></em>
                                        <span>Start Upload</span>
                                    </button>
                                    <span class="fileupload-process"></span>
                                    <div id="multiimage_error_image"
                                        class="errormessage  @error('multiimage') @else{{ 'd-none' }} @enderror">
                                        @error('multiimage')
                                            {{ $message }}
                                        @enderror
                                    </div>
                                </div>
                                <!-- The global progress state -->
                                <div class="col-lg-5 fileupload-progress">
                                    <!-- The global progress bar -->
                                    <div class="progress progress-striped active hide" role="progressbar"
                                        aria-valuemin="0" aria-valuemax="100">
                                        <div class="progress-bar progress-bar-success" style="width:0%;"></div>
                                    </div>
                                    <!-- The extended global progress state -->
                                    <div class="progress-extended">&nbsp;</div>
                                </div>
                                <div class="col-lg-12">
                                    <em class="text-muted"><small>{{ getImageRecommendedSize('upload_file') }}
                                        </small></em>
                                </div>
                            </div>

                            <!-- dropzone -->
                            {{-- <div class="dropzone table-layout well mb-2 d-flex justify-content-center align-items-center"
                                style="box-shadow:none;border-style:dashed;height:200px;">
                                <div class="col-xs-11 text-center">
                                    <h3 class="text-muted"><em class="ico-file-plus2 mr5"></em> Drag and drop your file
                                        here!</h3>
                                </div>
                            </div> --}}

                            <!-- file list -->
                            <div class="table-responsive">
                                <table class="table table-striped table-hovered upload-lists"
                                    aria-describedby="DataTableDesc">
                                    <thead style="display:none">
                                        <tr>
                                            <th scope="col"></th>
                                        </tr>
                                        <tr>
                                            <th scope="col"></th>
                                        </tr>

                                    </thead>
                                    <tbody class="files">

                                        @if (count(old('state_id', [])))
                                            @foreach (old('multiimage_ids', []) as $key => $imageIds)
                                                <tr>
                                                    <td>
                                                        <lable>File Name<span class="text-danger">*</span></lable></br>
                                                        <input type="text" name="multiimagefilename[]"
                                                            value="{{ old("multiimagefilename.$key") }}">
                                                        <div class="errormessage">
                                                            @error("multiimagefilename.$key")
                                                                {{ $message }}
                                                            @enderror
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <lable>CLE ID<span class="text-danger">*</span></lable></br>
                                                        <input type="text" name="multiimagebarid[]"
                                                            value="{{ old("multiimagebarid.$key") }}">
                                                        <div class="errormessage">
                                                            @error("multiimagebarid.$key")
                                                                {{ $message }}
                                                            @enderror
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="hidden" name="multiimage_ids[]"
                                                            value="{{ $imageIds }}">
                                                        <input type="hidden" name="multiimage[]"
                                                            value="{{ old("multiimage.$key") }}">
                                                        <input type="hidden" name="multiimageduration[]"
                                                            value="{{ old("multiimageduration.$key") }}">
                                                        <input type="hidden" name="multiimagesize[]"
                                                            value="{{ old("multiimagesize.$key") }}">
                                                        <a href="{{ getImageUrl(old("multiimage.$key"), 'upload_file') }}"
                                                            target="_blank">{{ old("multiimage.$key") }} </a>
                                                    </td>
                                                    <td>({{ old("multiimageduration.$key") }})</td>
                                                    <td></td>
                                                    <td style="text-align: right;">
                                                        @if ($imageIds == 0)
                                                            <button type="button"
                                                                class="btn btn-outline-danger remove_upload_file ">X</button>
                                                        @endif
                                                    </td>
                                                    <td></td>
                                                </tr>
                                            @endforeach
                                        @elseif ($content)
                                            @foreach ($content->contentFiles as $key => $file)
                                                <tr>
                                                    <td>
                                                        <lable>File Name<span class="text-danger">*</span></lable></br>
                                                        <input type="text" name="multiimagefilename[]"
                                                            value="{{ $file->view_file_name }}">
                                                        <div class="errormessage">
                                                            @error("multiimagefilename.$key")
                                                                {{ $message }}
                                                            @enderror
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <lable>CLE ID<span class="text-danger">*</span></lable></br>
                                                        <input type="text" name="multiimagebarid[]"
                                                            value="{{ $file->bar_id }}">
                                                        <div class="errormessage">
                                                            @error("multiimagebarid.$key")
                                                                {{ $message }}
                                                            @enderror
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="hidden" name="multiimage_ids[]"
                                                            value="{{ $file->id }}">
                                                        <input type="hidden" name="multiimage[]"
                                                            value="{{ $file->file }}">
                                                        <input type="hidden" name="multiimageduration[]"
                                                            value="{{ secondsToMinuteSecond($file->length) }}">
                                                        <input type="hidden" name="multiimagesize[]"
                                                            value="{{ bytesToMB($file->size) }}">
                                                        <a href="{{ getImageUrl($file->file, 'upload_file') }}"
                                                            target="_blank">{{ $file->file }} </a>
                                                    </td>
                                                    <td>({{ secondsToMinuteSecond($file->length) }})</td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        {{-- <p class="text-primary single-audio-upload-file-name">Uploaded File name : <span
                                class="fw-bold" id="single-audio-upload-file-name"></span></p> --}}
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 d-flex" style="justify-content: space-between">
                    <h2>{{ __('content.add_state') }}</h2>
                    <button type="button" class="btn btn-primary addnew-btn btn-sm" id="add_approve_state_btn"><em
                            class="icon-addnew top-icon"></em></button>
                </div>
                <div class="col-md-12">
                    <div class="add_more_approved_state">
                        @if (count(old('state_id', [])))
                            @foreach (old('state_id', []) as $key => $stateId)
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <input type="hidden" name="state_id[]" value="{{ $stateId }}">
                                        <label for="state">{{ __('content.state') }}<span
                                                class="text-danger">*</span></label>
                                        <select id="state" type="text"
                                            class="form-control contentfield stateSelectCheck" data-validator="required"
                                            name="state[]" tabindex="15"
                                            data-validator-label="{{ __('content.state') }}">
                                            <option value>Select {{ __('content.state') }}</option>
                                            @foreach ($approvedstates as $value)
                                                <option value="{{ $value->id }}"
                                                    @if (old("state.$key") == $value->id) selected @endif>
                                                    {{ $value->state_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <div class="errormessage">
                                            @error("state.$key")
                                                {{ $message }}
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label
                                            for="credit_provided_by_the_course">{{ __('content.credit_provided_by_the_course') }}<span
                                                class="text-danger">*</span></label>

                                        <div class="input-group ">
                                            <select id="credit_provided_by_the_course" type="text"
                                                class="form-control contentfield credit_field_by_the_course"
                                                data-validator="required" name="credit_provided_by_the_course[]"
                                                tabindex="16"
                                                data-validator-label="{{ __('content.credit_provided_by_the_course') }}">
                                                <option value>Select
                                                    {{ __('content.credit_provided_by_the_course') }}
                                                </option>
                                                @foreach (config('lengthInMinutes') as $length)
                                                    <option value="{{ $length }}"
                                                        @if (old("credit_provided_by_the_course.$key") == $length) selected @endif
                                                        @if (old("state.$key") >= $length) disabled @endif>
                                                        {{ $length }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <div class="input-group-append">
                                                <button type="button"
                                                    class="btn btn-outline-danger remove_approved_state_row">X</button>
                                            </div>
                                        </div>

                                        <div class="errormessage">
                                            @error("credit_provided_by_the_course.$key")
                                                {{ $message }}
                                            @enderror
                                        </div>
                                    </div>

                                    <input type="hidden" class="form-control contentfield " name="state_bar_id[]"
                                        placeholder="CLE ID" tabindex="17" value="0">

                                    {{-- <div class="form-group col-md-4 ">
                                        <label for="state_bar_id">{{ __('content.state_bar_id') }}<span
                                                class="text-danger">*</span></label>
                                        <div id="state_container">
                                            <div class="input-group">
                                                <input type="text"
                                                    class="form-control contentfield @error('state_bar_id') is-invalid @enderror"
                                                    name="state_bar_id[]" data-validator="required"
                                                    data-validator-label="{{ __('content.state_bar_id') }}"
                                                    placeholder="Bar ID" tabindex="17"
                                                    value="{{ old("state_bar_id.$key") }}">
                                                @if ($loop->index != 0 && $stateId == 0)
                                                    <div class="input-group-append">
                                                        <button type="button"
                                                            class="btn btn-outline-danger remove_approved_state_row">X</button>
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="errormessage">
                                                @error("state_bar_id.$key")
                                                    {{ $message }}
                                                @enderror
                                            </div>
                                        </div>
                                    </div> --}}


                                </div>
                            @endforeach
                        @elseif ($content->contentsStates && count($content->contentsStates) > 0)
                            @foreach ($content->contentsStates as $key => $contentsState)
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <input type="hidden" name="state_id[]" value="{{ $contentsState->id }}">
                                        <label for="state">{{ __('content.state') }}<span
                                                class="text-danger">*</span></label>

                                        <select id="state" type="text"
                                            class="form-control contentfield stateSelectCheck" data-validator="required"
                                            name="state[]" tabindex="18"
                                            data-validator-label="{{ __('content.state') }}">
                                            <option value>Select {{ __('content.state') }}</option>
                                            @foreach ($approvedstates as $value)
                                                <option value="{{ $value->id }}" @selected($value->id == $contentsState->bar_id)>
                                                    {{ $value->state_name }}</option>
                                            @endforeach
                                        </select>
                                        <div class="errormessage">
                                            @error("state.$key")
                                                {{ $message }}
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label
                                            for="credit_provided_by_the_course">{{ __('content.credit_provided_by_the_course') }}<span
                                                class="text-danger">*</span></label>

                                        <div class="input-group ">
                                            <select id="credit_provided_by_the_course" type="text"
                                                class="form-control contentfield credit_field_by_the_course"
                                                data-validator="required" name="credit_provided_by_the_course[]"
                                                tabindex="19"
                                                data-validator-label="{{ __('content.credit_provided_by_the_course') }}">
                                                <option value>Select {{ __('content.credit_provided_by_the_course') }}
                                                </option>
                                                @foreach (config('lengthInMinutes') as $length)
                                                    <option value="{{ $length }}" @disabled($getStatesMinLength[$contentsState->bar_id] > $length)
                                                        @selected($length == $contentsState->credit_provided_by_the_course && !($getStatesMinLength[$contentsState->bar_id] > $length))>
                                                        {{ $length }}</option>
                                                @endforeach
                                            </select>
                                            <div class="input-group-append">
                                                <button type="button"
                                                    class="btn btn-outline-danger remove_approved_state_row">X</button>
                                            </div>
                                        </div>

                                        <div class="errormessage">
                                            @error("credit_provided_by_the_course.$key")
                                                {{ $message }}
                                            @enderror
                                        </div>
                                    </div>

                                    <input type="hidden" class="form-control contentfield " name="state_bar_id[]"
                                        placeholder="CLE ID" tabindex="17" value="0">

                                    {{-- <div class="form-group col-md-4 ">
                                        <label for="state_bar_id">{{ __('content.state_bar_id') }}<span
                                                class="text-danger">*</span></label>
                                        <div id="state_container">

                                                <input type="text"
                                                    class="form-control contentfield @error('state_bar_id') is-invalid @enderror"
                                                    name="state_bar_id[]" data-validator="required"
                                                    value="{{ $contentsState->state_bar_id }}"
                                                    data-validator-label="{{ __('content.state_bar_id') }}"
                                                    placeholder="Bar ID" tabindex="20">

                                                <div class="errormessage">
                                                    @error('state_bar_id')
                                                        {{ $message }}
                                                    @enderror
                                                </div>

                                        </div>
                                    </div> --}}


                                </div>
                            @endforeach
                        @else
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <input type="hidden" name="state_id[]" value="0">
                                    <label for="state">{{ __('content.state') }}<span
                                            class="text-danger">*</span></label>
                                    <select id="state" type="text"
                                        class="form-control contentfield stateSelectCheck" name="state[]"
                                        data-validator="required" data-validator-label="{{ __('content.state') }}"
                                        tabindex="21">
                                        <option value>Select {{ __('content.state') }}</option>
                                        @foreach ($approvedstates as $value)
                                            <option value="{{ $value->id }}">
                                                {{ $value->state_name }}</option>
                                        @endforeach
                                    </select>
                                    <div class="errormessage">
                                        @error('state')
                                            {{ $message }}
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label
                                        for="credit_provided_by_the_course">{{ __('content.credit_provided_by_the_course') }}<span
                                            class="text-danger">*</span></label>

                                    <select id="credit_provided_by_the_course" type="text"
                                        class="form-control contentfield credit_field_by_the_course"
                                        data-validator="required" name="credit_provided_by_the_course[]" tabindex="22"
                                        data-validator-label="{{ __('content.credit_provided_by_the_course') }}">
                                        <option value>Select {{ __('content.credit_provided_by_the_course') }}</option>
                                        @foreach (config('lengthInMinutes') as $length)
                                            <option value="{{ $length }}">
                                                {{ $length }}</option>
                                        @endforeach
                                    </select>
                                    <div class="errormessage">
                                        @error('credit_provided_by_the_course')
                                            {{ $message }}
                                        @enderror
                                    </div>
                                </div>

                                <input type="hidden" class="form-control contentfield " name="state_bar_id[]"
                                    placeholder="CLE ID" tabindex="17" value="0">

                                {{-- <div class="form-group col-md-4 ">
                                    <label for="state_bar_id">{{ __('content.state_bar_id') }}<span
                                            class="text-danger">*</span></label>
                                    <div id="state_container">

                                            <input type="text"
                                                class="form-control contentfield @error('state_bar_id') is-invalid @enderror"
                                                name="state_bar_id[]" data-validator="required"
                                                data-validator-label="{{ __('content.state_bar_id') }}" placeholder="Bar ID"
                                                tabindex="23">
                                            <div class="errormessage">
                                                @error('state_bar_id')
                                                    {{ $message }}
                                                @enderror
                                            </div>

                                    </div>
                                </div> --}}
                            </div>
                        @endif


                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group col-sm-2">
                        <!-- comment as per discussion on call with rahul -->
                        {{-- <button type="button" id="add_approve_state_btn" class="btn btn-primary">Add More</button> --}}
                    </div>
                </div>
            </div>

        </div>
    </form>

    <script>
        function repopulateProviderIdDropdown(providerTypeValue) {
            $('#provider_id').empty();
            $('#provider_id').append($('<option>', {
                value: "",
                text: "Select {{ __('content.provider_id') }}"
            }));

            let url = '';

            if (providerTypeValue == 1) {
                url = '{{ route('user.getAdminUsers') }}';
            } else if (providerTypeValue == 2) {
                url = '{{ route('user.getSponsoredList') }}';
            } else if (providerTypeValue == 3) {
                url = '{{ route('user.getPartnerList') }}';
            }

            // Make AJAX request to repopulate the dropdown
            $.ajax({
                url: url,
                type: 'GET',
                success: function(response) {
                    // Append new options based on the response data
                    $.each(response.data, function(index, element) {
                        $('#provider_id').append($('<option>', {
                            value: index,
                            text: element
                        }));
                    });
                    var selectedProviderId = $('#selected_provider_id').val();
                    if (selectedProviderId != 0) {
                        $('#provider_id').val(selectedProviderId)
                        if (selectedProviderId == "other") {
                            $('#otherOption').show();
                            $('#provider_name').attr("data-validator", "required|max:100");
                        }
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });


        }

        function removeValidateForcly() {
            // based on changes
            //if all okay then remove all data-validator class. and this code also
            $('input').each(function(i) {
                $(this).removeAttr("data-validator");
            });
            $('select').each(function(i) {
                $(this).removeAttr("data-validator");
            });
        }
        $(document).ready(function() {
            removeValidateForcly(); // based on changes
            var providerTypeValue = $('#provider_type').val(); // Store the selected value
            if (providerTypeValue) {
                // Repopulate the dropdown based on the stored value
                repopulateProviderIdDropdown(providerTypeValue);
            }
            //Manage or add new option or other option based on provider selection of other
            $(document).on('change', '#provider_id', function(data) {
                var selectedValue = this.value;
                $("#provider_name").val('');
                if (selectedValue === 'other') {
                    $('#otherOption').show();
                    $('#provider_name').attr("data-validator", "required|max:100");
                } else {
                    $('#otherOption').hide();
                    $('#provider_name').removeAttr("data-validator");
                    $('#provider_name').addClass("is-invalid");
                }
                removeValidateForcly(); // based on changes
            });

            //load provider name based on selection of provider_type
            $(document).on('change', '#provider_type', function(data) {
                var providerTypeValue = $(this).val(); // Get the selected value
                // Repopulate the dropdown based on the selected value
                $('#selected_provider_id').val(0);
                repopulateProviderIdDropdown(providerTypeValue);
            });



            $(document).on('change', '.stateSelectCheck', function(data) {

                if ($(this).val() != '') {
                    $(this).parent().find('.errormessage').text("");
                    var selectedId = $(this).val();
                    var minLength = {!! json_encode($getStatesMinLength) !!}[selectedId];

                    $(this).parent().parent().find('.credit_field_by_the_course option').each(function() {
                        if (parseInt(minLength) <= parseInt($(this).val())) {
                            $(this).prop('disabled', false);
                        } else {
                            $(this).prop('disabled', true);
                        }
                    });
                    $(this).parent().parent().find('.credit_field_by_the_course').val(parseInt(minLength))

                    var selectedValueArray = [];
                    $('.stateSelectCheck').not(this).each(function() {
                        selectedValueArray.push($(this).val());
                    });

                    if (selectedValueArray.includes($(this).val())) {
                        $(this).parent().find('.errormessage').text(
                            "{{ __('content.duplicate_selection_found') }}");
                        $(this).val('');
                    }
                }
            });


            /*$('.single-audio-upload-file-name').hide();
            $(document).on('change', '#temp_upload_file', function(data) {
                var fileList = event.target.files;
                if (fileList.length > 0) {
                    var uploadedFile = fileList[0];
                    var fileName = uploadedFile.name;
                    console.log('Uploaded file name:', fileName);
                    $('#single-audio-upload-file-name').text(fileName);
                    $('.single-audio-upload-file-name').show();
                }
            });
            $(document).on('click', '.dropify-clear', function(data) {
                $('.single-audio-upload-file-name').hide();
            }); */

            //Add more approved state button functionality
            $(document).on('click', '.remove_upload_file', function() {

                // let row = $(this).closest('tr');
                // let file = row.find('input[name="multiimage[]"]').val(); // Get the file Name
                // if (file) {
                //     $.ajax({
                //         url: "{{ route('upload.deleteFile') }}",
                //         type: "POST",
                //         data: {
                //             _token: "{{ csrf_token() }}",
                //             file: file
                //         },
                //         success: function(response) {
                //             if (response.success) {
                //                 // alert("Success: " + response.message);

                //             } else {
                //                 console.log("Error: " + response.message);
                //             }
                //         },
                //         error: function() {
                //            console.log('Something went wrong. Please try again.')
                //         }
                //     });
                // }
                $(this).parent().parent().remove();
            });
            $(document).on('click', '#add_approve_state_btn', function() {
                var row_col = `<div class="row remove"><div class="form-group col-md-6">
                    <input type="hidden" name="state_id[]" value="0">
                        <label for="state">{{ __('content.state') }}<span
                                class="text-danger">*</span></label>
                        <select id="state" type="text" class="form-control contentfield stateSelectCheck"
                            name="state[]" tabindex="24" data-validator="required" data-validator-label="{{ __('content.state') }}">
                            <option value>Select {{ __('content.state') }}</option>
                            @foreach ($approvedstates as $value)
                                <option value="{{ $value->id }}">
                                    {{ $value->state_name }}</option>
                            @endforeach
                        </select>
                        <div class="errormessage">
                            @error('state')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="credit_provided_by_the_course">{{ __('content.credit_provided_by_the_course') }}<span class="text-danger">*</span></label>

                        <div class="input-group ">
                        <select id="credit_provided_by_the_course" type="text" class="form-control contentfield credit_field_by_the_course"
                            data-validator="required" name="credit_provided_by_the_course[]" tabindex="25"
                            data-validator-label="{{ __('content.credit_provided_by_the_course') }}">
                            <option value>Select {{ __('content.credit_provided_by_the_course') }}</option>
                            @foreach (config('lengthInMinutes') as $length)
                                <option value="{{ $length }}">
                                    {{ $length }}</option>
                            @endforeach
                        </select>
                        <div class="input-group-append">
                            <button type="button" class="btn btn-outline-danger remove_approved_state_row">X</button>
                        </div>
                        </div>

                        <div class="errormessage">
                            @error('credit_provided_by_the_course')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                    <input type="hidden" class="form-control contentfield " name="state_bar_id[]" placeholder="CLE ID" tabindex="17" value="0">

                </div>`;

                // <div class="form-group col-md-4 ">
                //         <label for="state_bar_id">{{ __('content.state_bar_id') }}<span
                //                 class="text-danger">*</span></label>
                //         <div id="state_container">
                //             <div class="input-group ">
                //                 <input type="text"
                //                     class="form-control contentfield @error('state_bar_id') is-invalid @enderror"
                //                     name="state_bar_id[]" placeholder="State id" data-validator="required"
                //                     value="" data-validator-label="state"
                //                     aria-label="State id" >
                //                 <div class="input-group-append">
                //                     <button type="button"
                //                         class="btn btn-outline-danger remove_approved_state_row">X</button>
                //                 </div>
                //             </div>
                //             <div class="errormessage">
                //                     @error('state_bar_id')
                //                         {{ $message }}
                //                     @enderror
                //                 </div>
                //         </div>
                //     </div>
                $('.add_more_approved_state').append(row_col);
                removeValidateForcly(); // based on changes
            });

            $(document).on('click', '.remove_approved_state_row', function() {
                $(this).closest('.row').remove();
            });
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const publishedOnInput = document.getElementById("published_on");
            const form = document.querySelector("#frmaddedit");
            const errorMessage = document.querySelector("#published_on_error");

            // Date format: MM/DD/YYYY HH:mm (24-hour format)
            function isValidDateFormat(dateStr) {
                const dateTimeRegex = /^\d{2}\/\d{2}\/\d{4} \d{2}:\d{2}$/; // MM/DD/YYYY HH:mm
                return dateTimeRegex.test(dateStr);
            }

            // Validate on input change
            publishedOnInput.addEventListener("input", function() {
                if (!isValidDateFormat(publishedOnInput.value)) {

                    if (publishedOnInput.value == "") {
                        publishedOnInput.classList.remove("is-invalid");
                        errorMessage.textContent = "";
                    } else {
                        publishedOnInput.classList.add("is-invalid");
                        errorMessage.textContent = "Invalid date format. Use MM/DD/YYYY HH:mm.";
                    }

                } else {
                    publishedOnInput.classList.remove("is-invalid");
                    errorMessage.textContent = "";
                }
            });

            // Validate on form submission
            form.addEventListener('submit', event => {
                if (!isValidDateFormat(publishedOnInput.value)) {
                    console.log("Invalid date format detected, preventing submission");
                    if (publishedOnInput.value == "") {
                        errorMessage.textContent = "";
                    } else {
                        // event.preventDefault(); // Stop form submission
                        publishedOnInput.classList.add("is-invalid");
                        errorMessage.textContent = "Invalid date format. Use MM/DD/YYYY HH:mm.";
                        // return false; // Ensure it stops execution
                    }

                }
            });
        });
    </script>

    <!-- JavaScript to Handle Search & Adding Speaker -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let speakerSelect = document.getElementById("speaker");
            let selectpicker = $(".selectpicker");
            let typingTimer;
            const typingDelay = 500; // Time in milliseconds to wait after user stops typing

            function updateAddSpeakerOption() {

                $(speakerSelect).on("shown.bs.select", function() {
                    let searchInput = document.querySelector(".bs-searchbox input");

                    if (searchInput) {
                        searchInput.addEventListener("input", function() {

                            clearTimeout(typingTimer);

                            typingTimer = setTimeout(() => {

                                let searchValue = this.value.trim().toLowerCase();
                                let found = false;

                                $("#speaker option").each(function() {
                                    if ($(this).text().toLowerCase().includes(
                                            searchValue)) {

                                        found = true;
                                    }
                                });

                                let noResultsMessage = $(".no-results");
                                let addNewSpeakerOption = $("#add_new_speaker_option");

                                // Remove old "Add Speaker" option if it exists
                                addNewSpeakerOption.remove();

                                if (!found && searchValue.length > 0) {

                                    if (noResultsMessage.length > 0) {
                                        // Append the "Add Speaker" button right after "No results found"
                                        noResultsMessage.after(
                                            `<li id="add_new_speaker_option" class="text-primary dropdown-item add-speaker-btn" style="cursor: pointer;">
                                            + Add "${searchValue}"
                                        </li>`
                                        );
                                    }
                                }
                            }, typingDelay);
                        });
                    }
                });
            }

            selectpicker.on("shown.bs.select", updateAddSpeakerOption());

            // Listen for clicks on the "Add New Speaker" option
            $(document).on("click", "#add_new_speaker_option", function() {
                let searchValue = $(".bs-searchbox input").val();
                $("#newSpeakerName").val(searchValue);
                $("#namefounderror").text("");
                $("#emailfounderror").text("");
                $("#addSpeakerModal").modal("show");

                // Close the dropdown
                selectpicker.selectpicker("toggle");
            });

            document.getElementById("saveSpeaker").addEventListener("click", function() {
                let newSpeakerName = document.getElementById("newSpeakerName").value.trim();
                let newSpeakerEmail = document.getElementById("newSpeakerEmail").value.trim();

                if (newSpeakerName !== "") {
                    $.ajax({
                        url: "{{ route('speaker.store') }}",
                        type: "POST",
                        data: {
                            name: newSpeakerName,
                            email: newSpeakerEmail,
                            _token: $('meta[name="csrf-token"]').attr("content") // CSRF token
                        },
                        success: function(data) {
                            if (data.success) {
                                let newOption = new Option(newSpeakerName, data.id, false,
                                    true);
                                $("#speaker").append(newOption);
                                $(".selectpicker").selectpicker("refresh");
                                $("#addSpeakerModal").modal("hide");
                                $("#speaker").val([...$("#speaker").val(), data.id])
                                    .selectpicker("refresh").trigger('change');

                                // success toast
                                var html = "Speaker added successfully."
                                $(".ajax_message").removeClass("d-none");
                                $(".ajax_message")
                                    .find("span")
                                    .addClass("successmessage")
                                    .addClass("text-success")
                                    .html(html);
                                setTimeout(function() {
                                    $(".ajax_message")
                                        .find("span")
                                        .html("");
                                }, 2000);
                            }
                        },
                        error: function(xhr) {
                            try {
                                let response = JSON.parse(xhr.responseText); // manually parse
                                if (response.errors) {
                                    if (response.errors.name) {
                                        $("#namefounderror").text(response.errors.name[0]);
                                    } else {
                                        $("#namefounderror").text("");
                                    }

                                    if (response.errors.email) {
                                        $("#emailfounderror").text(response.errors.email[0]);
                                    } else {
                                        $("#emailfounderror").text("");
                                    }
                                } else {
                                    alert("Error adding speaker.");
                                }
                            } catch (e) {
                                alert("Error adding speaker.");
                            }
                        }
                    });

                } else {
                    $("#namefounderror").text("Speaker name is required.");
                    $("#emailfounderror").text("Speaker email is required.");
                }
            });
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('form'); // Change selector if needed
            form.addEventListener('submit', function(e) {
                let isValid = true;

                // Clear previous error messages
                document.querySelectorAll('.errormessage').forEach(div => {
                    div.innerHTML = '';
                });

                // Loop through all rows
                document.querySelectorAll('tr').forEach(function(row, index) {
                    const fileInput = row.querySelector('input[name="multiimage[]"]');
                    const fileNameInput = row.querySelector('input[name="multiimagefilename[]"]');
                    const cleIdInput = row.querySelector('input[name="multiimagebarid[]"]');

                    if (fileInput && fileInput.value) {
                        if (!fileNameInput || !fileNameInput.value.trim()) {
                            const errorDiv = fileNameInput.nextElementSibling;
                            if (errorDiv) {
                                errorDiv.innerHTML = 'File Name is required.';
                            }
                            isValid = false;
                        }

                        if (!cleIdInput || !cleIdInput.value.trim()) {
                            const errorDiv = cleIdInput.nextElementSibling;
                            if (errorDiv) {
                                errorDiv.innerHTML = 'CLE ID is required.';
                            }
                            isValid = false;
                        }
                    }
                });

                if (!isValid) {
                    e.preventDefault(); // Prevent form submit if validation fails
                }
            });
        });
    </script>

@endsection
