@extends('admin.layouts.app')
@section('content')
    <div class="container-fluid dashboard-cms pb-5">
        <h1 class="page-title">{{__('dashboard.pagetitle')}}</h1>
        <div class="col-12 dashboard-holder">
            <div class="row">
                @foreach ($menu as $item)
                @if (!empty($item['exclude_dashboard']) || strpos($item['url'], collect(request()->segments())->last()))
                @continue
                @endif
                <div class="col-xl-2 col-lg-4 col-sm-6 col-12 item">
                    <a href="{{ $item['url'] }}"
                        class="dashboard-item d-flex flex-column justify-content-center align-items-center"
                        data-title="{{ $item['title'] }}" tabindex="3">
                        <img class="svg" src="{{ $item['imageurl'] }}" alt="{{ $item['title'] }}" />
                        <span class="dashborad-title text-center">{{ $item['title'] }}</span>
                    </a>
                </div>
                @endforeach

            </div>
        </div>
    </div>

@endsection
