@extends('admin.layouts.app')
@section('content')
    <div class="row mx-0 mb-3">
        <div class="col-lg-6">
            <h1 class="bar-title">{{ __('events.viewpagetitle') }}</h1>
        </div>
        <div class="top-btn-box col-6 d-flex justify-content-end align-items-center" id="normal_btns">
            <a tabindex="1" href="{{ route('events.index') }}" class="btn search-btn btn-sm show hide btn-primary ml-2" id="search-btn">
                {{ __('common.back') }}
            </a>
            </div>
    </div>
    <div class="col-12 admin-holder">
        <div class="card mb-4">
            <div class="card-body">
                <p><b>Event Title:</b> {{ $event->event_name }}</p>
                <div class="row">
                    <div class="col-sm-6">
                        <p><b>Event Description:</b> {{ $event->description }}</p>
                    </div>
                    <div class="col-sm-6">
                        <p><b>QR Endpoint:</b> {{ $event->qr_endpoint }}</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-6">
                        <p><b>Total Scan Attempts: </b>{{ $event->qrScanTotalAttempts()  }}</p>
                    </div>
                    <div class="col-6">
                        <p><b>Status: </b>{!! $event->status == 1
                            ? '<span class="badge bg-success text-light">Active</span>'
                            : '<span class="badge bg-danger text-light">Inactive</span>' !!}</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12 d-flex justify-content-end">
                        <a href="{{ route('events.downloadQr', $event->id) }}" class="btn btn-primary">Download QR</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-box">
            @if ($statistics->isNotEmpty())
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="episode-container">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0 nested-table" id="datatable" data-target="0">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            {{-- <th>Client User Agent</th> --}}
                                            <th>Client Browser</th>
                                            <th>Client IP Address</th>
                                            <th>Client Platform</th>
                                            <th>Scan Attempts</th>
                                            <th>Updated On</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($statistics as $stats)
                                            <tr>
                                                <td></td>
                                                {{-- <td class="site-name">{{ $stats->client_user_agent }}</td> --}}
                                                <td>{{ $stats->client_browser }}</td>
                                                <td>{{ $stats->client_ipaddress }}</td>
                                                <td>{{ $stats->client_platform }}</td>
                                                <td>{{ $stats->scan_attempts }}</td>
                                                <td>{{ $stats->updated_at }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('.nested-table').each(function() {
                var table = $(this).DataTable({
                    lengthChange: true,
                    ordering: false,
                    searching: true,
                    order: [],
                    pageLength: parseInt(defaultPagingLenth), // Default pagination size
                    language: {
                        paginate: {
                            next: "&#187;",
                            previous: "&#171;"
                        }
                    },
                    emptyTable: "No data available",

                });

                // Initial pagination visibility check
                table.draw();
            });
        });
    </script>
@endsection
