@extends('admin.layouts.app')
@section('content')
    <form method="post" action="{{ isset($faculty->id) ? route('faculty.update', [$faculty->id]) : route('faculty.store') }}"
        name="frmaddedit" id="frmaddedit">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6">
                <h1 class="page-title">{{ isset($faculty->id) ? __('faculty.editpagetitle') : __('faculty.addpagetitle') }}
                </h1>
            </div>
            <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        <a tabindex="500" id="btncancel" href="{{ route('faculty.index') }}"
                            class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em>
                            <span>{{ __('common.cancel') }}</span></a>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.save') }}</span></button>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.savecontinue') }}</span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            @csrf
            @if (isset($faculty->id))
                @method('PUT')
            @endif
            <div class="row">
                <div class="col-md-12">
                    <h2>{{ __('faculty.page_content') }}</h2>
                </div>
                <div class="form-group col-md-6">
                    <label for="name">{{ __('faculty.name') }}<span class="text-danger">*</span></label>
                    <input id="name" type="text" class="form-control @error('name') is-invalid @enderror"
                        name="name" value="{{ old('name', $faculty->name) }}" data-validator="required|max:100"
                        tabindex="3">

                    <div class="errormessage"> @error('name')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label for="email">{{ __('faculty.email') }}<span class="text-danger">*</span></label>
                    <input id="email" type="text" class="form-control @error('email') is-invalid @enderror"
                        name="email" value="{{ old('email', $faculty->email) }}" data-validator="required"
                        tabindex="3">

                    <div class="errormessage"> @error('email')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6">
                    @component('admin.component.status_dropdown', [
                        'refModel' => 'page',
                        'status' => $faculty->status,
                        'required' => false,
                        'default' => 1,
                        'tabindex' => 5,
                    ])
                    @endcomponent
                </div>

                <div class="form-group col-md-6">
                    <label for="firm_name">{{ __('faculty.firm_name') }}</label>
                    <input id="firm_name" type="text" class="form-control @error('firm_name') is-invalid @enderror"
                        name="firm_name" value="{{ old('firm_name', $faculty->firm_name) }}"
                        tabindex="3">

                    <div class="errormessage"> @error('firm_name')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label for="profile_url">{{ __('faculty.profile_url') }}</label>
                    <input id="profile_url" type="text" class="form-control @error('profile_url') is-invalid @enderror"
                        name="profile_url" value="{{ old('profile_url', $faculty->profile_url) }}"
                        tabindex="3">

                    <div class="errormessage"> @error('profile_url')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                @if (isset($faculty->id) && isset($faculty->display_order))
                    <div class="form-group col-md-6">
                        <label for="display_order">{{ __('faculty.display_order') }}<span
                                class="text-danger">*</span></label>
                        <input id="display_order" type="text"
                            class="form-control @error('display_order') is-invalid @enderror" name="display_order"
                            value="{{ old('display_order', $faculty->display_order) }}" data-validator="required"
                            tabindex="3">
                @endif
                <div class="errormessage"> @error('display_order')
                        {{ $message }}
                    @enderror
                </div>
            </div>
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-12 banner-section">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <label for="temp_image">{{ __('faculty.image') }}</label>
                                        <input type="file" id="temp_image"
                                            data-size="{{ getImageUploadSizeInMB('faculty') }}"
                                            class="dropify image-upload" name="temp_image" data-folder="faculty"
                                            {{ old('image', $faculty->image) != '' ? 'data-default-file=' . getImageUrlForModule(old('image', $faculty->image), 'faculty', '', 'faculty') : '' }}
                                            tabindex="14">
                                        <div><small>{{ getImageRecommendedSize('faculty') }}</small></div>
                                        <input name="image" type="hidden" value="{{ old('image', $faculty->image) }}">
                                        <div id="error_image"
                                            class="errormessage  @error('image') @else{{ 'd-none' }} @enderror">
                                            @error('image')
                                                {{ $message }}
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group col-md-12">
                <label for="description">{{ __('faculty.description') }}</label>
                <textarea id="description" class="tinymce form-control @error('description') is-invalid @enderror" name="description"
                    data-validator-label="description" rows="20" tabindex="10">{{ old('description', $faculty->description) }}</textarea>

                <div class="errormessage">
                    @error('description')
                        {{ $message }}
                    @enderror
                </div>

            </div>
        </div>
        </div>
    </form>
@endsection
