@extends('admin.layouts.app')
@section('content')
    <form method="post" action="{{ isset($faqs->id) ? route('faqs.update', $faqs->id) : route('faqs.store') }}"
        name="frmaddedit" id="frmaddedit">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6">
                <h1 class="page-title">
                    {{ isset($faqs->id) ? __('faqs.editfaqstitle') : __('faqs.addfaqstitle') }}</h1>
            </div>
            <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        <a tabindex="500" id="btncancel" href="{{ route('faqs.index') }}"
                            class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em>
                            <span>{{ __('common.cancel') }}</span></a>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.save') }}</span></button>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.savecontinue') }}</span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            @csrf
            @if (isset($faqs->id))
                @method('PUT')
            @endif
            <div class="row">
                <div class="col-md-12">
                    <h2>{{ __('faqs.faqs_content') }}</h2>
                </div>

                <div class="form-group col-md-6">
                    @component('admin.component.status_dropdown', [
                        'refModel' => 'faqs',
                        'status' => $faqs->status,
                        'required' => false,
                        'default' => 1,
                        'tabindex' => 5,
                    ])
                    @endcomponent
                </div>
                @if (isset($faqs->id) && isset($faqs->display_order))
                    <div class="form-group col-md-6">
                        <label for="display_order">{{ __('faqs.display_order') }}<span class="text-danger">*</span></label>
                        <input id="display_order" type="text"
                            class="form-control @error('display_order') is-invalid @enderror" name="display_order"
                            value="{{ old('display_order', $faqs->display_order) }}" data-validator="required"
                            tabindex="3">
                        <div class="errormessage"> @error('display_order')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                @endif

                <div class="form-group col-md-12">
                    <label for="question">{{ __('faqs.question') }}<span class="text-danger">*</span></label>
                    <textarea id="question" class="form-control @error('question') is-invalid @enderror" name="question"
                        data-validator="required" data-validator-label="question" rows="5" tabindex="10">{{ old('question', $faqs->question) }}</textarea>

                    <div class="errormessage">
                        @error('question')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
                <div class="form-group col-md-12">
                    <label for="answer">{{ __('faqs.answer') }}<span class="text-danger">*</span></label>
                    <textarea id="answer" class="form-control @error('answer') is-invalid @enderror" name="answer"
                        data-validator="required" data-validator-label="answer" rows="10" tabindex="10">{{ old('answer', $faqs->answer) }}</textarea>

                    <div class="errormessage">
                        @error('answer')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
            </div>
        </div>
    </form>
@endsection
