@extends('admin.layouts.app')
@section('content')

    <form method="post" action="{{ isset($firm->id) ? route('firm.update', $firm->id) : route('firm.store') }}"
        name="frmaddedit" id="frmaddedit">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6">
                <h1 class="firm-title">{{ isset($firm->id) ? __('firm.editpagetitle') : __('firm.addpagetitle') }}</h1>
            </div>
            <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        <a tabindex="500" id="btncancel" href="{{ route('firm.index') }}"
                            class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em>
                            <span>{{ __('common.cancel') }}</span></a>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.save') }}</span></button>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.savecontinue') }}</span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            @csrf
            @if (isset($firm->id))
                @method('PUT')
            @endif
            <div class="row">
                <div class="col-md-12">
                    <h2>{{ __('firm.firm_content') }}</h2>
                </div>
                <div class="form-group col-md-6">
                    <label for="name">{{ __('firm.name') }}<span class="text-danger">*</span></label>
                    <input id="name" type="text" class="form-control @error('name') is-invalid @enderror"
                        name="name" value="{{ old('name', $firm->name) }}" data-validator="required|max:100"
                        tabindex="3" data-validator-label="firm name">
                    <div class="errormessage"> @error('name')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                @if (isset($firm->user_id))
                    <div class="form-group col-md-6">
                        <label for="code">{{ __('firm.code') }}<span class="text-danger">*</span></label>
                        <input id="code" type="text" class="form-control @error('code') is-invalid @enderror"
                            name="code" value="{{ old('code', $firm->code) }}" disabled tabindex="3">
                        <div class="errormessage"> @error('adminname')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                @endif
                <div class="form-group col-md-6">
                    <label for="adminname">{{ __('firm.adminname') }}<span class="text-danger">*</span></label>
                    <input id="adminname" type="text" class="form-control @error('adminname') is-invalid @enderror"
                        name="adminname" value="{{ old('adminname', $firm->adminname) }}" data-validator="required|max:100"
                        data-validator-label="admin name" tabindex="3">

                    <div class="errormessage"> @error('adminname')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="email">{{ __('firm.adminemail') }}<span class="text-danger">*</span></label>
                    <input id="email" type="text" class="form-control @error('email') is-invalid @enderror"
                        name="email" value="{{ old('email', $firm->email) }}" data-validator-label="admin email"
                        data-validator="required|max:100" tabindex="3" @if (isset($firm->user_id)) disabled @endif>

                    <div class="errormessage"> @error('email')
                            {{ $message }}
                        @enderror
                    </div>
                    @if (isset($firm->user_id))
                        <input type="hidden" name="user_id" value="{{ $firm->user_id }}" />
                    @endif
                </div>
                <div class="form-group col-md-6">
                    <label for="adminphone">{{ __('firm.adminphone') }}<span class="text-danger">*</span></label>
                    <input id="adminphone" type="text" class="form-control @error('adminphone') is-invalid @enderror"
                        name="adminphone" data-mask='000-000-0000' placeholder="___-___-____"
                        value="{{ old('adminphone', $firm->adminphone) }}" data-validator-label="admin phone number"
                        data-validator="required|max:100" tabindex="3">

                    <div class="errormessage"> @error('adminphone')
                            {{ $message }}
                        @enderror
                    </div>

                </div>

                <div class="form-group col-md-6">
                    <label for="address1">{{ __('firm.address1') }}<span class="text-danger">*</span></label>
                    <input id="address1" type="text"
                        class="form-control firmfield @error('address1') is-invalid @enderror" name="address1"
                        value="{{ old('address1', $firm->address1) }}" data-validator="required" tabindex="4">

                    <div class="errormessage">
                        @error('address1')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
                <div class="form-group col-md-6">
                    <label for="address2">{{ __('firm.address2') }}</label>
                    <input id="address2" type="text"
                        class="form-control firmfield @error('address2') is-invalid @enderror" name="address2"
                        value="{{ old('address2', $firm->address2) }}" tabindex="4">

                    <div class="errormessage">
                        @error('address2')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
                <div class="form-group col-md-6">
                    <label for="city">{{ __('firm.city') }}<span class="text-danger">*</span></label>
                    <input id="city" type="text"
                        class="form-control firmfield @error('city') is-invalid @enderror" name="city"
                        value="{{ old('city', $firm->city) }}" data-validator="required" tabindex="4">

                    <div class="errormessage">
                        @error('city')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
                <div class="form-group col-md-6">
                    <label for="state_id">{{ __('firm.state_id') }}<span class="text-danger">*</span></label>
                    <select id="state_id" type="text"
                        class="form-control firmfield @error('state_id') is-invalid @enderror" name="state_id" data-validator-label="{{ __('firm.state_id') }}"
                        data-validator="required" tabindex="4">
                        <option value>Select {{ __('firm.state_id') }}</option>
                        @foreach ($states as $state)
                            <option @if (old('state_id', $firm->state_id) == $state->id) selected="selected" @endif
                                value="{{ $state->id }}">{{ $state->name }}</option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('state_id')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="zipcode">{{ __('firm.zipcode') }}<span class="text-danger">*</span></label>
                    <input id="zipcode" type="text"
                        class="form-control firmfield @error('zipcode') is-invalid @enderror" name="zipcode"
                        data-mask='00000' value="{{ old('zipcode', $firm->zipcode) }}" data-validator="required|min:5|max:5"
                        maxlength="5" tabindex="4">
                    <div class="errormessage">
                        @error('zipcode')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="col-md-12">
                    <h2>{{ __('firm.billing_information') }}</h2>
                </div>
                <div class="form-group col-md-6">
                    <label for="billing_name">{{ __('firm.billing_name') }}<span class="text-danger">*</span></label>
                    <input id="billing_name" type="text"
                        class="form-control @error('billing_name') is-invalid @enderror" name="billing_name"
                        value="{{ old('billing_name', $firm->billing_name) }}" data-validator="required" tabindex="4">
                    <div class="errormessage">
                        @error('billing_name')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="billing_email">{{ __('firm.billing_email') }}<span class="text-danger">*</span></label>
                    <input id="billing_email" type="text"
                        class="form-control @error('billing_email') is-invalid @enderror" name="billing_email"
                        value="{{ old('billing_email', $firm->billing_email) }}" data-validator="required"
                        tabindex="4">

                    <div class="errormessage">
                        @error('billing_email')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
                <div class="form-group col-md-12 align-items-center d-flex">
                    <label>{{ __('firm.sameasfirm') }}</label>
                    <label class="switch ml-2">
                        @php
                            $checked = 0;
                        @endphp
                        @if (isset($firm->sameasfirm) && $firm->sameasfirm == 1)
                            {{ $checked = 1 }}
                        @else
                            {{ $checked = old('sameasfirm') }}
                        @endif
                        <input type="checkbox" id="sameasfirm" name="sameasfirm" value="1"
                            {{ $checked != '' ? 'checked' : '' }} tabindex="4">
                        <span class="slider round"></span>
                    </label>
                </div>

                <div class="form-group col-md-6">
                    <label for="billing_address1">{{ __('firm.billing_address1') }}<span
                            class="text-danger">*</span></label>
                    <input id="billing_address1" type="text"
                        class="form-control @error('billing_address1') is-invalid @enderror" name="billing_address1"
                        value="{{ old('billing_address1', $firm->billing_address1) }}" data-validator="required"
                        tabindex="4">
                    <div class="errormessage">
                        @error('billing_address1')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="billing_address2">{{ __('firm.billing_address2') }}</label>
                    <input id="billing_address2" type="text"
                        class="form-control @error('billing_address2') is-invalid @enderror" name="billing_address2"
                        value="{{ old('billing_address2', $firm->billing_address2) }}" tabindex="4">
                    <div class="errormessage">
                        @error('billing_address2')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="billing_city">{{ __('firm.billing_city') }}<span class="text-danger">*</span></label>
                    <input id="billing_city" type="text"
                        class="form-control @error('billing_city') is-invalid @enderror" name="billing_city"
                        value="{{ old('billing_city', $firm->billing_city) }}" data-validator="required" tabindex="4">
                    <div class="errormessage">
                        @error('billing_city')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="billing_state_id">{{ __('firm.billing_state_id') }}<span
                            class="text-danger">*</span></label>
                    <select id="billing_state_id" type="text"
                        class="form-control @error('billing_state_id') is-invalid @enderror" name="billing_state_id" data-validator-label="{{ __('firm.billing_state_id') }}"
                        data-validator="required" tabindex="4">
                        <option value>Select {{ __('firm.billing_state_id') }}</option>
                        @foreach ($states as $state)
                            <option @if (old('billing_state_id', $firm->billing_state_id) == $state->id) selected="selected" @endif
                                value="{{ $state->id }}">{{ $state->name }}</option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('billing_state_id')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="billing_zipcode">{{ __('firm.billing_zipcode') }}<span
                            class="text-danger">*</span></label>
                    <input id="billing_zipcode" type="text" data-mask='00000'
                        class="form-control @error('billing_zipcode') is-invalid @enderror" name="billing_zipcode"
                        value="{{ old('billing_zipcode', $firm->billing_zipcode) }}" data-validator="required|min:5|max:5"
                        maxlength="5" tabindex="4">
                    <div class="errormessage">
                        @error('billing_zipcode')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="col-md-12">
                    <hr>
                </div>
                <div class="form-group col-md-6">
                    <label for="user_subscription">{{ __('firm.user_subscription') }}<span
                            class="text-danger">*</span></label>
                    @if (isset($firm->user_subscription) && !is_null(old('user_subscription', $firm->user_subscription)))
                        @php $selected_value = old('user_subscription',$firm->user_subscription); @endphp
                    @else
                        @php $selected_value = old('user_subscription'); @endphp
                    @endif
                    <select id="user_subscription" class="form-control @error('user_subscription') is-invalid @enderror"
                        name="user_subscription" data-validator="required" tabindex="4">
                        @foreach (config('firmusersubscription') as $value => $label)
                            <option value="{{ $value }}"
                                @if (0 == $value && $selected_value === null) {{ 'selected=selected' }} @endif
                                @if ((string) $selected_value == (string) $value) {{ 'selected=selected' }} @endif>{{ $label }}
                            </option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('user_subscription')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="firm_size">{{ __('firm.firm_size') }}<span class="text-danger">*</span></label>
                    @if (isset($firm->firm_size) && !is_null(old('firm_size', $firm->firm_size)))
                        @php $selected_value = old('firm_size',$firm->firm_size); @endphp
                    @else
                        @php $selected_value = old('firm_size'); @endphp
                    @endif
                    <select id="firm_size" class="form-control @error('firm_size') is-invalid @enderror"
                        name="firm_size" data-validator="required" tabindex="4">
                        @foreach (config('firmsize') as $value => $label)
                            <option value="{{ $value }}"
                                @if (0 == $value && $selected_value === null) {{ 'selected=selected' }} @endif
                                @if ((string) $selected_value == (string) $value) {{ 'selected=selected' }} @endif>{{ $label }}
                            </option>
                        @endforeach
                    </select>
                    <div class="errormessage">
                        @error('firm_size')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                @if (isset($firm->id))
                    <div class="form-group col-md-6">
                        @component('admin.component.status_dropdown', [
                            'refModel' => 'firm',
                            'status' => $firm->status,
                            'required' => false,
                            'default' => 1,
                            'tabindex' => 5,
                        ])
                        @endcomponent
                    </div>
                @endif
            </div>
        </div>
    </form>
@endsection
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const checkbox = document.getElementById('sameasfirm');
        const billing_address1 = document.getElementById('billing_address1');
        const billing_address2 = document.getElementById('billing_address2');
        const billing_city = document.getElementById('billing_city');
        const billing_zipcode = document.getElementById('billing_zipcode');
        const billing_state_id = document.getElementById('billing_state_id');

        checkbox.addEventListener('change', function() {
            billing_address1.readOnly = this.checked;
            billing_address2.readOnly = this.checked;
            billing_city.readOnly = this.checked;
            billing_zipcode.readOnly = this.checked;
            billing_state_id.disabled = this.checked;
        });

        // Set initial state of input field based on checkbox status
        billing_address1.readOnly = checkbox.checked;
        billing_address2.readOnly = checkbox.checked;
        billing_city.readOnly = checkbox.checked;
        billing_zipcode.readOnly = checkbox.checked;
        billing_state_id.disabled = checkbox.checked;

        document.getElementById('frmaddedit').addEventListener('submit', function() {
            document.getElementById('billing_state_id').disabled = false; // Enable the select box before submission
        });
    });
</script>
