@extends('admin.layouts.app')
@section('content')
    <form method="post" action="{{ isset($member->id) ? route('members.update', [$member->id]) : route('members.store') }}"
        name="frmaddedit" id="frmaddedit">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6">
                <h1 class="page-title">{{ isset($member->id) ? __('member.editpagetitle') : __('member.addpagetitle') }}
                </h1>
            </div>
            <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        <a tabindex="500" id="btncancel" href="{{ route('members.index') }}"
                            class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em>
                            <span>{{ __('common.cancel') }}</span></a>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.save') }}</span></button>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.savecontinue') }}</span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            @csrf
            @if (isset($member->id))
                @method('PUT')
            @endif
            <div class="row">
                <div class="col-md-12">
                    <h2>{{ __('member.page_content') }}</h2>
                </div>
                <div class="form-group col-md-6">
                    <label for="name">{{ __('member.name') }}<span class="text-danger">*</span></label>
                    <input id="name" type="text" class="form-control @error('name') is-invalid @enderror"
                        name="name" value="{{ old('name', $member->name) }}" data-validator="required|max:100"
                        tabindex="3">

                    <div class="errormessage"> @error('name')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6">
                    @component('admin.component.status_dropdown', [
                        'refModel' => 'page',
                        'status' => $member->status,
                        'required' => false,
                        'default' => 1,
                        'tabindex' => 5,
                    ])
                    @endcomponent
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-12 banner-section">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="form-group col-md-12">
                                            <label for="temp_image">{{ __('member.image') }}</label>
                                            <input type="file" id="temp_image"
                                                data-size="{{ getImageUploadSizeInMB('member') }}"
                                                class="dropify image-upload" name="temp_image" data-folder="members"
                                                {{ old('image', $member->image) != '' ? 'data-default-file=' . getImageUrlForModule(old('image', $member->image), 'members', '', 'member') : '' }}
                                                tabindex="14">
                                            <div><small>{{ getImageRecommendedSize('member') }}</small></div>
                                            <input name="image" type="hidden"
                                                value="{{ old('image', $member->image) }}">
                                            <div id="error_image"
                                                class="errormessage  @error('image') @else{{ 'd-none' }} @enderror">
                                                @error('image')
                                                    {{ $message }}
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group col-md-12">
                    <label for="description">{{ __('member.description') }}<span class="text-danger">*</span></label>
                    <textarea id="description" class="tinymce form-control @error('description') is-invalid @enderror" name="description"
                        data-validator="required" data-validator-label="page content" rows="20" tabindex="10">{{ old('description', $member->description) }}</textarea>

                    <div class="errormessage">
                        @error('description')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
            </div>
        </div>
    </form>
@endsection
