@extends('admin.layouts.app')
@section('content')

<form method="post" action="{{ (isset($news->id) ? route('news.update',$news->id) : route('news.store'))  }}"
    name="frmaddedit" id="frmaddedit">
    <div class="row mx-0 mb-3">
        <div class="col-lg-6">
            <h1 class="page-title">{{ (isset($news->id) ? __('news.editnewstitle') : __('news.addnewstitle'))  }}</h1>
        </div>
        <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
            <div class="top-btn-box">
                <div class="top-btn-box d-flex">
                    <a tabindex="500" id="btncancel" href="{{ route('news.index') }}" class="btn btn-sm btn-dark mr-1"><em
                            class="icon-close-icon top-icon"></em> <span>{{ __('common.cancel') }}</span></a>
                    <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave" name="btnsave"
                        value='save'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.save') }}</span></button>
                    <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave" name="btnsave"
                        value='savecontinue'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.savecontinue') }}</span></button>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        @csrf
        @if(isset($news->id)) @method('PUT') @endif
        <div class="row">
            <div class="col-md-12">
                <h2>{{ __('news.news_content') }}</h2>
            </div>
            <div class="form-group col-md-6">
                <label for="title">{{ __('news.title') }}<span class="text-danger">*</span></label>
                <input id="title" type="text" class="form-control @error('title') is-invalid @enderror" name="title"
                    value="{{old('title',$news->title)}}" data-validator="required|max:100" tabindex="3">

                <div class="errormessage"> @error('title') {{ $message }} @enderror</div>

            </div>
            @if(isset($news->id))
            <div class="form-group col-md-6">
                <label for="slug">{{ __('news.slug') }}</label>
                <input id="slug" type="text" class="form-control @error('slug') is-invalid @enderror" name="slug"
                    value="{{old('slug',$news->slug)}}" readonly data-validator="required" tabindex="4">

                <div class="errormessage">@error('slug') {{ $message }} @enderror</div>

            </div>
            @endif
            <div class="form-group col-md-6">
                <label for="author">{{ __('news.author') }}<span class="text-danger">*</span></label>
                <input id="author" type="text" class="form-control @error('author') is-invalid @enderror" name="author"
                    value="{{old('author',$news->author)}}" data-validator="required|max:100" tabindex="3">

                <div class="errormessage"> @error('author') {{ $message }} @enderror</div>

            </div>
            <div class="form-group col-md-6">
                @component('admin.component.status_dropdown',['refModel'=>'news','status'=>
                $news->status,'required'=>false,'default'=>1,'tabindex'=>5] )
                @endcomponent
            </div>
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-12 banner-section">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <label for="temp_banner">{{ __('news.banner') }}</label>
                                        <input type="file" data-size="{{ getImageUploadSizeInMB('news') }}"
                                            class="dropify image-upload" name="temp_banner" tabindex="7" data-folder="news"
                                            @if(old('banner',$news->banner)) @endif
                                        {{ old('banner',$news->banner) != '' ? 'data-default-file='.getImageUrlForModule(old('banner',$news->banner),'banner', '', 'news') : '' }} id="temp_banner">
                                        <div><small>{{ getImageRecommendedSize('news') }}</small></div>
                                        <input name="banner" type="hidden" value="{{old('banner',$news->banner)}}">
                                        <div id="error_banner"
                                            class="errormessage  @error('banner') @else{{  'd-none'  }} @enderror">
                                            @error('banner'){{ $message }}@enderror</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group col-md-12">
                <label for="description">{{ __('news.description') }}<span class="text-danger">*</span></label>
                <textarea id="description" class="tinymce form-control @error('description') is-invalid @enderror"
                    name="description" data-validator="required" data-validator-label="page content"
                    rows="20" tabindex="10">{{old('description',$news->description)}}</textarea>

                <div class="errormessage">@error('description') {{ $message }} @enderror</div>

            </div>
        </div>
    </div>
</form>
@endsection
