@extends('admin.layouts.app')
@section('content')
<div class="row mx-0 mb-3">
    <div class="col-6">
        <h1 class="page-title"><?php echo __('news.pagetitle'); ?></h1>
    </div>
    <div class="top-btn-box col-6" id="normal_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
            <a tabindex="1" href="javascript:void(0)" class="btn search-btn btn-sm show hide btn-primary mr-1" id="search-btn">
                <em class="icon-search-icon top-icon"></em>
                <span class="btn-title">{{ __('common.search') }}</span>
            </a>
            {{-- @if (canUserAccess('manage-content') || canUserAccess('manage-content')) --}}
                <a tabindex="2" href="{{ route('news.create') }}" class="btn btn-primary addnew-btn btn-sm"
                    id="add-btn">
                    <em class="icon-addnew top-icon"></em>
                    <span class="btn-title">{{ __('common.add') }}</span>
                </a>
            {{-- @endif--}}
        </div>
    </div>
    <div class="top-btn-box hide col-6" id="action_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm active-btn"
                onclick="submitactionform('active');" id="active-btn" title="{{ __('common.active') }}">
                <em class="icon-radiobutton_checked top-icon"></em>
                <span class="btn-title">{{ __('common.active') }}</span>
            </a>
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm inactive-btn"
                onclick="submitactionform('inactive');" id="inactive-btn" title="{{ __('common.inactive') }}">
                <em class="icon-radio_button_unchecked top-icon"></em>
                <span class="btn-title">{{ __('common.inactive') }}</span>
            </a>
            <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');" id="delete-btn" title="{{ __('common.delete') }}">
                <em class="icon-close-icon top-icon"></em>
                <span class="btn-title">{{ __('common.delete') }}</span>
            </a>
        </div>
    </div>
</div>
<div class="col-12 admin-holder">
    <div class="row">
        <div class="{{ Request::has('status') && Request::has('search') ? 'show' : 'hide' }}" id="searchbox">
            <form name="frmsearch" id="frmsearch" action="{{ $news->appends(prepareInputRequestArray())->url(1) }}" method="GET" class="col-12">
                @foreach (Request::all() as $key=>$value)
                @if (in_array($key,['search','status','btnsearch']))
                @continue
                @else
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endif
                @endforeach
                <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label>{{ __('news.title') }}/{{ __('news.content') }}/{{ __('news.slug') }}</label>
                        <input tabindex="3" name="search" id="search" placeholder="{{ __('common.search') ." ". __('news.pagetitle') }}" type="text" class="form-control rounded" value="{{ Request::get('search') }}">
                    </div>
                    <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                        <label>{{ __('news.status') }}</label>
                        <select tabindex="4" name="status" id="status" class="form-control rounded">
                            <option value="">{{ __('common.select_status') }}</option>
                            @foreach (config('status') as $value => $label)
                            <option value="{{$value}}" {{ Request::get('status') != "" && intval(Request::get('status')) === $value ? 'selected' : '' }}>
                                {{ $label }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-12">
                        <button tabindex="5" type="submit" class="btn submit-btn btn-primary mr-1" id="btnsearch" name="btnsearch">{{ __('common.search') }}</button>
                        <a href="{{ route('news.index', ['search' => '', 'status' => '']) }}" class="btn btn-primary reset-btn">{{ __('common.reset') }}</a>
                        <button tabindex="7" type="button" class="btn close-btn btn-dark" id="search-btn-h">{{ __('common.close') }}</button>
                        <hr>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-12 photos-main">
            <section id="wrapper">
                <form name="frmlist" id="frmlist" action="{{ route('news.bulkaction') }}" method="POST">
                    @csrf
                    <input type="hidden" name="bulk-action" value="">
                    <div class="table-responsive">
                    <table data-orders="6" defaultdir="desc" data-target=" @if(canUserAccess('manage-page')) 3 @else 1 @endif" class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                        <thead>
                            <tr>
                                <th class="hide" scope="col">

                                </th>
                                @if(canUserAccess('manage-page'))
                                <th class="active-box status-column" scope="col">
                                    <em class="sort"></em>
                                </th>
                                <th class="check-box nosort" scope="col">
                                    <div class="custom-control custom-checkbox text-center">
                                        <input type="checkbox" class="custom-control-input" name="selectAll" id="selectAll" onclick="checkAll();">
                                        <label class="custom-control-label" for="selectAll"></label>
                                    </div>
                                </th>
                                @endif
                                <th scope="col" class="control nosort">
                                    <!-- this blank column is responsive controll -->

                                </th>
                                <th scope="col">
                                    <span>{{ __('news.title') }}</span>
                                </th>
                                <th scope="col">
                                    <span>{{ __('news.slug') }}</span>
                                </th>
                                <th scope="col">
                                    <span>{{ __('news.status') }}</span>
                                </th>
                                <th scope="col">
                                    <span>{{ __('news.updated-at') }}</span>
                                </th>
                                @if(canUserAccess('manage-page'))
                                <th class="text-right nosort" scope="col">{{__('common.action')}}</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($news as $fcl)
                            <tr>
                                <td class="active-box hide">
                                    <em style="display:none">{{$fcl->id}}</em>
                                </td>
                                @if(canUserAccess('manage-page'))
                                <td class="active-box">
                                    <a href="{{ route('news.changestatus', ['id' => $fcl->id]) }} ">
                                        <em style="display:none">{{$fcl->status}}</em>
                                        <span class="sort {{ $fcl->status == 1 ? 'active' : 'inactive' }} "></span>
                                    </a>
                                </td>
                                <td class="check-box">
                                    <div class="custom-control custom-checkbox text-center">
                                        <input type="checkbox" class="custom-control-input chkbox action-checkbox" id="filled-in-box_{{ $fcl->id }}" name="id[]" value="{{$fcl->id}}">
                                        <label class="custom-control-label" for="filled-in-box_{{ $fcl->id }}"></label>
                                    </div>
                                </td>
                                @endif
                                <td></td>
                                <td>
                                    @if(canUserAccess('manage-page'))
                                    <a href="{{ route('news.edit', ['news' => $fcl->id]) }}">{{ $fcl->title }}</a>
                                    @else {{ $fcl->title}}
                                    @endif
                                </td>
                                <td>{{ $fcl->slug }}</td>
                                <td>{!! $fcl->status == 1 ? '<span class="badge bg-success text-light">Active</span>' : '<span class="badge bg-danger text-light">Inactive</span>' !!}</td>

                                <td data-sort="{{ \Carbon\Carbon::parse( $fcl->updated_at)->format('Y/m/d H:i:s')}}">
                                    {{ $fcl->updated_at  }}
                                </td>
                                @if(canUserAccess('manage-page'))
                                <td class="text-right">
                                    <a href="{{ route('news.edit', ['news' => $fcl->id]) }}"><em class="icon-edit-icon left"></em></a>
                                </td>
                                @endif
                            </tr>
                            @endforeach
                            @if ($news->total() == 0)
                            <tr class="noreocrd">
                                <td colspan="9" class="text-center">
                                    {{ __('news.no_result') }}
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                    </div>
                </form>
            </section>
        </div>
    </div>
</div>
@endsection