@extends('admin.layouts.app')
@section('content')

<form method="post" action="{{ (isset($page->id) ? route('page.update',$page->id) : route('page.store'))  }}"
    name="frmaddedit" id="frmaddedit">
    <div class="row mx-0 mb-3">
        <div class="col-lg-6">
            <h1 class="page-title">{{ (isset($page->id) ? __('page.editpagetitle') : __('page.addpagetitle'))  }}</h1>
        </div>
        <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
            <div class="top-btn-box">
                <div class="top-btn-box d-flex">
                    <a tabindex="500" id="btncancel" href="{{ route('page.index') }}" class="btn btn-sm btn-dark mr-1"><em
                            class="icon-close-icon top-icon"></em> <span>{{ __('common.cancel') }}</span></a>
                    <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave" name="btnsave"
                        value='save'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.save') }}</span></button>
                    <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave" name="btnsave"
                        value='savecontinue'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.savecontinue') }}</span></button>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        @csrf
        @if(isset($page->id)) @method('PUT') @endif
        <div class="row">
            <div class="col-md-12">
                <h2>{{ __('page.page_content') }}</h2>
            </div>
            <div class="form-group col-md-6">
                <label for="title">{{ __('page.title') }}<span class="text-danger">*</span></label>
                <input id="title" type="text" class="form-control @error('title') is-invalid @enderror" name="title"
                    value="{{old('title',$page->title)}}" data-validator="required|max:100" tabindex="3">

                <div class="errormessage"> @error('title') {{ $message }} @enderror</div>

            </div>
            @if(isset($page->id))
            <div class="form-group col-md-6">
                <label for="slug">{{ __('page.slug') }}</label>
                <input id="slug" type="text" class="form-control @error('slug') is-invalid @enderror" name="slug"
                    value="{{old('slug',$page->slug)}}" readonly data-validator="required" tabindex="4">

                <div class="errormessage">@error('slug') {{ $message }} @enderror</div>

            </div>
            @endif
            <div class="form-group col-md-6">
                @component('admin.component.status_dropdown',['refModel'=>'page','status'=>
                $page->status,'required'=>false,'default'=>1,'tabindex'=>5] )
                @endcomponent
            </div>
            <div class="col-md-12">
                <div class="row">
                    <div class="form-group col-md-12 align-items-center d-flex">
                        <label>{{ __('page.banner') }}</label>
                        <label class="switch ml-2">
                            @if (isset($page->banner))
                            {{ $banner_checked = 1 }}
                            @else
                            {{ $banner_checked  = old('has_banner') }}
                            @endif
                            <input type="checkbox" id="has_banner" name="has_banner" data-show=".banner-section" value="1"
                                {{ $banner_checked  != '' ? 'checked' : '' }} tabindex="6">
                            <span class="slider round"></span>
                        </label>
                    </div>
                    <div class="col-md-12 banner-section">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <label for="temp_banner">{{ __('page.banner') }}<span
                                                class="text-danger">*</span></label>
                                        <input type="file" data-size="{{ getImageUploadSizeInMB('banner') }}"
                                            class="dropify image-upload" name="temp_banner" tabindex="7" data-folder="banner"
                                            @if(old('banner',$page->banner)) @else
                                        data-validator="required_if:has_banner" @endif
                                        {{ old('banner',$page->banner) != '' ? 'data-default-file='.getImageUrl(old('banner',$page->banner),'banner') : '' }} id="temp_banner">
                                        <div><small>{{ getImageRecommendedSize('banner') }}</small></div>
                                        <input name="banner" type="hidden" value="{{old('banner',$page->banner)}}">
                                        <div id="error_banner"
                                            class="errormessage  @error('banner') @else{{  'd-none'  }} @enderror">
                                            @error('banner'){{ $message }}@enderror</div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="banner_alt">{{ __('page.banner_alt') }}</label>
                                        <input id="banner_alt" type="text"
                                            class="form-control @error('banner_alt') is-invalid @enderror" tabindex="8"
                                            name="banner_alt" value="{{old('banner_alt',$page->banner_alt)}}">
                                        <div class="errormessage">@error('banner_alt') {{ $message }} @enderror</div>

                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-12">
                                <label for="banner_content">{{ __('page.banner_content') }}</label>
                                <textarea id="banner_content"
                                    class="tinymce form-control @error('banner_content') is-invalid @enderror"
                                    name="banner_content"
                                    rows="20" tabindex="9">{{old('banner_content',$page->banner_content)}}</textarea>

                                <div class="errormessage">@error('banner_content') {{ $message }} @enderror</div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group col-md-12">
                <label for="description">{{ __('page.description') }}<span class="text-danger">*</span></label>
                <textarea id="description" class="tinymce form-control @error('description') is-invalid @enderror"
                    name="description" data-validator="required" data-validator-label="page content"
                    rows="20" tabindex="10">{{old('description',$page->description)}}</textarea>

                <div class="errormessage">@error('description') {{ $message }} @enderror</div>

            </div>
            <div class="col-md-12">
                <h2>{{ __('common.seo') }}</h2>
            </div>
            <div class="form-group col-md-6">
                <label for="meta_title">{{ __('page.meta_title') }}<span class="text-danger">*</span></label>
                <input id="meta_title" type="text" class="form-control @error('meta_title') is-invalid @enderror"
                    name="meta_title" value="{{old('meta_title',$page->meta_title)}}" data-validator="required" tabindex="11">

                <div class="errormessage">@error('meta_title') {{ $message }} @enderror</div>

            </div>
            <div class="form-group col-md-6">
                <label for="meta_desc">{{ __('page.meta_desc') }}<span class="text-danger">*</span></label>
                <textarea id="meta_desc" class="form-control @error('meta_desc') is-invalid @enderror" name="meta_desc"
                    rows="5" data-validator="required"
                    data-validator-label="meta description" tabindex="12">{{old('meta_desc',$page->meta_desc)}}</textarea>

                <div class="errormessage">@error('meta_desc') {{ $message }} @enderror</div>

            </div>
        </div>
    </div>
</form>
@endsection
