@extends('admin.layouts.app')
@section('content')
<div class="row mx-0 mb-3">
    <div class="col-6">
        <h1 class="page-title"><?php echo __('podcaststatistics.pagetitle'); ?></h1>
    </div>
    <div class="top-btn-box col-6" id="normal_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
            <a tabindex="1" href="javascript:void(0)" class="btn search-btn btn-sm show hide btn-primary mr-1" id="search-btn">
                <em class="icon-search-icon top-icon"></em>
                <span class="btn-title">{{ __('common.search') }}</span>
            </a>
        </div>
    </div>
    <div class="top-btn-box hide col-6" id="action_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm active-btn"
                onclick="submitactionform('active');" id="active-btn" title="{{ __('common.active') }}">
                <em class="icon-radiobutton_checked top-icon"></em>
                <span class="btn-title">{{ __('common.active') }}</span>
            </a>
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm inactive-btn"
                onclick="submitactionform('inactive');" id="inactive-btn" title="{{ __('common.inactive') }}">
                <em class="icon-radio_button_unchecked top-icon"></em>
                <span class="btn-title">{{ __('common.inactive') }}</span>
            </a>
            <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');" id="delete-btn" title="{{ __('common.delete') }}">
                <em class="icon-close-icon top-icon"></em>
                <span class="btn-title">{{ __('common.delete') }}</span>
            </a>
        </div>
    </div>
</div>
<div class="col-12 admin-holder">
    <div class="row">
        <div class="{{ Request::has('published_on') && Request::has('search') ? 'show' : 'hide' }}" id="searchbox">
            <form name="frmsearch" id="frmsearch" action="{{ route('podcast.index') }}" method="GET" class="col-12">
                @foreach (Request::all() as $key=>$value)
                @if (in_array($key,['search','published_on','btnsearch']))
                @continue
                @else
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endif
                @endforeach
                <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label>{{ __('podcaststatistics.podcast_title') }}/{{ __('podcaststatistics.podcast_internal_id') }}</label>
                        <input tabindex="3" name="search" id="search" placeholder="{{ __('common.search') ." ". __('podcaststatistics.pagetitle') }}" type="text" class="form-control rounded" value="{{ Request::get('search') }}">
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label>{{ __('podcaststatistics.published_on') }}</label>
                        <input tabindex="3" name="published_on" type="text" class="form-control datepicker" value="{{ Request::get('published_on') }}">
                    </div>
                    <div class="form-group col-12">
                        <button tabindex="5" type="submit" class="btn submit-btn btn-primary mr-1" id="btnsearch" name="btnsearch">{{ __('common.search') }}</button>
                        <a href="{{ route('podcast.index', ['search' => '', 'published_on' => '']) }}" class="btn btn-primary reset-btn">{{ __('common.reset') }}</a>
                        <button tabindex="7" type="button" class="btn close-btn btn-dark" id="search-btn-h">{{ __('common.close') }}</button>
                        <hr>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-12 photos-main">
            <section id="wrapper">
                <form name="frmlist" id="frmlist" method="POST">
                    @csrf
                    <input type="hidden" name="bulk-action" value="">
                    <div class="table-responsive">
                    <table id="serverside-datatable" ajax-call="{{ route('podcast.getdata') }}" data-orders="0" defaultdir="desc" data-target="0" class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                        <thead>
                            <tr>
                                <th scope="col" class="control nosort">
                                    <!-- this blank column is responsive controll -->
                                </th>
                                <th scope="col">
                                    <span>{{ __('podcaststatistics.podcast_internal_id') }}</span>
                                </th>
                                <th scope="col">
                                    <span>{{ __('podcaststatistics.podcast_title') }}</span>
                                </th>
                                <th scope="col">
                                    <span>{{ __('podcaststatistics.published_on') }}</span>
                                </th>
                                <th scope="col">
                                    <span>{{ __('podcaststatistics.total_play_count') }}</span>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($podcaststatistics as $stats)
                            <tr>
                                <td class="active-box hide">
                                    <em style="display:none"></em>
                                </td>
                                <td>
                                </td>
                                <td><a href={{ route('podcast.show',$stats->id) }}>{{ $stats->content->internal_cl_podcast_id ?? 'N/A' }}</a></td>
                                <td>{{ $stats->content->podcast_title ?? 'N/A' }}</td>
                                <td>{{ $stats->content->published_on }}</td>
                                <td>{{ $stats->calculateTotalPlays() }}</td>
                            </tr>
                            @endforeach
                            @if ($podcaststatistics->total() == 0)
                            <tr class="noreocrd">
                                <td colspan="9" class="text-center">
                                    {{ __('podcaststatistics.no_result') }}
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                    </div>
                </form>
            </section>
        </div>
    </div>
</div>
@endsection