@extends('admin.layouts.app')
@section('content')
    <div class="row mx-0 mb-3">
        <div class="col-lg-6">
            <h1 class="bar-title">{{ __('podcaststatistics.viewpagetitle') }}</h1>
        </div>
        <div class="top-btn-box col-6 d-flex justify-content-end align-items-center" id="normal_btns">
            <div class="form-group position-relative mb-0 w-100">
                <input type="text" id="search-input" class="form-control form-control-sm pr-4" placeholder="Search by Site Name">
                <button type="button" id="clear-btn" class="btn btn-sm position-absolute" 
                        style="right: 10px; top: 50%; transform: translateY(-55%); border: none; background: transparent; display: none;">
                    ×
                </button>
            </div>
            <a tabindex="1" href="{{ route('podcast.index') }}" class="btn search-btn btn-sm show hide btn-primary ml-2" id="search-btn">
                {{ __('common.back') }}
            </a>
        </div>
    </div>
    <div class="col-12 admin-holder">
        <div class="card mb-4">
            <div class="card-body">
                <p><b>Name:</b> {{ $podcast->content->podcast_title }}</p>
                <div class="row">
                    <div class="col-sm-6">
                        <p><b>Author:</b> {{ $podcast->content->provider_name }}</p>
                    </div>
                    <div class="col-sm-6">
                        <p><b>Speakers:</b>@if(!$podcast->content->speakers->isEmpty())@foreach ($podcast->content->speakers as $key => $speaker)
                            @if($speaker->speaker->status == 1)
                                {{ optional($speaker->speaker)->name ?? '' }}
                                @if ($key !== count($podcast->content->speakers) - 1 && $speaker->speaker->status == 1 && count($podcast->content->speakers) > 1)
                                    ,
                                @endif
                            @endif
                        @endforeach @endif</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-6">
                        <p><b>Length:</b> {{ $podcast->content->lengthOfPodcast() }} mins</p>
                    </div>
                    <div class="col-6">
                        <p><b>Size:</b> {{ $podcast->content->sizeOfPodcast() }} MB</p>
                    </div>
                </div>
                <div>
                    <p><b>Total Play Count :</b> {{ $podcast->calculateTotalPlays() }}</p>
                </div>
            </div>
        </div>

        {{-- <div class="col-12 photos-main" id="episodes-container"> --}}
        <div class="card-box">
            @foreach ($podcast->content->contentFiles as $index => $episode)
                @if ($episode->episodeStats()->isNotEmpty())
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="episode-container">
                                <p><b>Episode : </b>{{ $episode->view_file_name }}</p>
                                <div class="table-responsive">
                                    <table class="table table-hover mb-0 nested-table" id="datatable-{{ $index }}"
                                        data-target="0">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th>Site Name</th>
                                                <th>Android</th>
                                                <th>iOS</th>
                                                <th>Web</th>
                                                <th>Home Page</th>
                                                <th>Library</th>
                                                <th>Browser</th>
                                                <th>IP Address</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($episode->episodeStats() as $stats)
                                                <tr>
                                                    <td></td>
                                                    <td class="site-name">{{ $stats->site_name }}</td>
                                                    <td>{{ $stats->android }}</td>
                                                    <td>{{ $stats->iphone }}</td>
                                                    <td>{{ $stats->web }}</td>
                                                    <td>{{ $stats->home_page }}</td>
                                                    <td>{{ $stats->library }}</td>
                                                    <td>{{ $stats->browser }}</td>
                                                    <td>{{ $stats->ipaddress }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @endforeach
            {{-- </div> --}}
            {{-- <p id="no-results" class="text-center mt-3" style="display: none;"><b>No results found</b></p> --}}
        </div>
    </div>


    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const searchInput = document.getElementById("search-input");
            const clearBtn = document.getElementById("clear-btn");
    
            searchInput.addEventListener("input", function () {
                clearBtn.style.display = this.value ? "block" : "none";
            });
    
            clearBtn.addEventListener("click", function () {
                searchInput.value = "";
                clearBtn.style.display = "none";
                searchInput.focus();
                window.location.reload();
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('.nested-table').each(function() {
                var table = $(this).DataTable({
                    lengthChange: false,
                    ordering: false,
                    searching: false, // No individual table search
                    order: [],
                    pageLength: parseInt(defaultPagingLenth), // Default pagination size
                    language: {
                        paginate: {
                            next: "&#187;",
                            previous: "&#171;"
                        }
                    },
                    emptyTable: "No data available",
                    drawCallback: function() {
                        var api = this.api();
                        var rowCount = api.rows({
                            filter: 'applied'
                        }).count();
                        var pageLength = api.page.len();

                        // Hide pagination if all results fit on one page
                        $(this).parent().find('.dataTables_paginate').toggle(rowCount >
                            pageLength);
                    }
                });

                // Initial pagination visibility check
                table.draw();
            });

            $('#search-input').on('keyup', function() {
                var searchValue = $(this).val().trim().toLowerCase();
                var anyVisible = false;

                $('.episode-container').each(function() {
                    var episode = $(this);
                    var table = episode.find('.nested-table').DataTable();
                    var hasMatch = false;

                    table.rows().every(function() {
                        var row = $(this.node());
                        var siteName = row.find('.site-name').text().toLowerCase();
                        if (siteName.includes(searchValue)) {
                            $(this.node()).show();
                            hasMatch = true;
                        } else {
                            $(this.node()).hide();
                        }
                    });

                    // Show/hide episode container based on search results
                    episode.toggle(hasMatch);
                    anyVisible = anyVisible || hasMatch;

                    // Remove entire `.card` wrapper if no matching results
                    episode.closest('.card').toggle(hasMatch);

                    // Redraw DataTable for correct pagination
                    table.draw();
                });

                // Show "No results found" if nothing matches
                $('#no-results-message').toggle(!anyVisible);
            });

            // Add "No results found" message placeholder
            $('.card-box').append(
                '<p id="no-results-message" style="display: none; text-align: center; font-weight: bold;">No results found</p>'
            );
        });
    </script>
@endsection
