@extends('admin.layouts.app')
@section('content')
    <form method="post"
        action="{{ isset($releases->id) ? route('releases.update', $releases->id) : route('releases.store') }}"
        name="frmaddedit" id="frmaddedit">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6">
                <h1 class="page-title">
                    {{ isset($releases->id) ? __('releases.editreleasestitle') : __('releases.addreleasestitle') }}</h1>
            </div>
            <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        <a tabindex="500" id="btncancel" href="{{ route('releases.index') }}"
                            class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em>
                            <span>{{ __('common.cancel') }}</span></a>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.save') }}</span></button>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.savecontinue') }}</span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            @csrf
            @if (isset($releases->id))
                @method('PUT')
            @endif
            <div class="row">
                <div class="col-md-12">
                    <h2>{{ __('releases.releases_content') }}</h2>
                </div>
                <div class="form-group col-md-6">
                    <label for="name">{{ __('releases.name') }}<span class="text-danger">*</span></label>
                    <input id="name" type="text" class="form-control @error('name') is-invalid @enderror"
                        name="name" value="{{ old('name', $releases->name) }}" data-validator="required|max:100"
                        tabindex="3">

                    <div class="errormessage"> @error('name')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                {{-- <div class="form-group col-md-6">
                    <label>{{ __('releases.released_on') }}</label>
                        <input id="released_on" type="text"
                        class="form-control datepicker @error('released_on') is-invalid @enderror" name="released_on"
                        value="{{ old('released_on', ($releases->released_on != null ? \Carbon\Carbon::parse($releases->released_on)->format(config('app.db_date_format')) : null)) }}"
                        tabindex="11">
                    <div class="errormessage">
                        @error('released_on')
                            {{ $message }}
                        @enderror
                    </div>
                </div> --}}
                <div class="form-group col-md-6">
                    <label>{{ __('releases.released_on') }}</label>
                        <input id="released_on" type="text"
                        class="form-control datetimepicker @error('released_on') is-invalid @enderror" name="released_on"
                        value="{{ old('released_on', $releases->released_on) }}"
                        tabindex="11">
                    <div class="errormessage">
                        @error('released_on')
                            {{ $message }}
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-6">
                    @component('admin.component.status_dropdown', [
                        'refModel' => 'releases',
                        'status' => $releases->status,
                        'required' => false,
                        'default' => 1,
                        'tabindex' => 5,
                    ])
                    @endcomponent
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-12 banner-section">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="form-group col-md-12">
                                            <label for="temp_image">{{ __('releases.image') }}</label>
                                            <input type="file" id="temp_image"
                                                data-size="{{ getImageUploadSizeInMB('releases') }}"
                                                class="dropify image-upload" name="temp_image" data-folder="releases"
                                                {{ old('image', $releases->image) != '' ? 'data-default-file=' . getImageUrlForModule(old('image', $releases->image), 'releases', '', 'release') : '' }}
                                                tabindex="14">
                                            <div><small>{{ getImageRecommendedSize('releases') }}</small></div>
                                            <input name="image" type="hidden"
                                                value="{{ old('image', $releases->image) }}">
                                            <div id="error_image"
                                                class="errormessage  @error('image') @else{{ 'd-none' }} @enderror">
                                                @error('image')
                                                    {{ $message }}
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group col-md-12">
                    <label for="description">{{ __('releases.description') }}<span class="text-danger">*</span></label>
                    <textarea id="description" class="tinymce form-control @error('description') is-invalid @enderror" name="description"
                        data-validator="required" data-validator-label="page content" rows="20" tabindex="10">{{ old('description', $releases->description) }}</textarea>

                    <div class="errormessage">
                        @error('description')
                            {{ $message }}
                        @enderror
                    </div>

                </div>
            </div>
        </div>
    </form>
@endsection
