@extends('admin.layouts.app')
@section('content')

<form method="post" action="{{ (isset($role->id) ? route('role.update',$role->id) : route('role.store'))  }}" name="frmaddedit" id="frmaddedit">
    <div class="row mx-0 mb-3">
        <div class="col-lg-6">
            <h1 class="page-title">{{ (isset($role->id) ? __('role.editpagetitle') : __('role.addpagetitle'))  }}</h1>
        </div>
        <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
            <div class="top-btn-box">
                <div class="top-btn-box d-flex">
                    <a tabindex="5" href="{{ route('role.index') }}" class="btn btn-dark mr-1 btn-sm"><em class="icon-close-icon top-icon"></em> <span>{{ __('common.cancel') }}</span></a>
                    <button tabindex="9" type="submit" class="btn btn-primary mr-1 btn-sm" id="btnsave" name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.save') }}</span></button>
                    <button tabindex="9" type="submit" class="btn btn-primary btn-sm" id="btnsave" name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.savecontinue') }}</span></button>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        @csrf
        @if(isset($role->id)) @method('PUT') @endif
        <div class="row">
            <div class="form-group col-md-6">
                <label for="title">{{ __('role.rolename') }}<span class="text-danger">*</span></label>
                <input id="title" type="text" class="form-control" value="{{ ucfirst(($role->name!='') ? $role->name : $role->shortname) }}" readonly>
            </div>
            <div class="form-group col-md-6">
                <label for="status">{{ __('role.status') }}</label>
                <select class="form-control" id="status" name="status">
                    @foreach (config('status') as $value => $label)
                    <option value="{{ $value }}" @if( old('status', $role->status) == $value ) selected
                        @endif>{{ $label }}</option>
                    @endforeach
                </select>
                <div class="errormessage"> @error('status') {{ $message }} @enderror</div>
            </div>

            <div class="form-group col-md-6">
                <label for="redirect_url">{{ __('role.redirect_url') }}
                </label>
                <input id="redirect_url" type="text" name="redirect_url" class="form-control" value={{$role->redirect_url}}>
                <small>{{url('')}}/</small>
            </div>
            
        </div>
        <div class="row">
            <div class="col-md-12 site-config">
                <div class="accordion" id="site-config-accordion">
                    <div class="card rounded-0">
                        <div class="card-body">
                            <div class="row">
                                @foreach (config('userrolepermissions') as $item)
                                @if(
                                (empty($item['blacklist']) && empty($item['whitelist'])) ||
                                (!empty($item['blacklist']) && !in_array($role->shortname, $item['blacklist'])) ||
                                (!empty($item['whitelist']) && in_array($role->shortname, $item['whitelist']))
                                )
                                <div class="col-md-4 mb-3">
                                    <h2 class="permission-title">{{ $item['title'] }}</h2>
                                    @foreach ($item['permissions'] as $permission)
                                    <div class="form-group d-inline-block col-12">
                                        <input type="checkbox" id="permission_{{ $role->id }}_{{ $permission['key'] }}" name="permission[{{ $role->id }}][]" value="{{ $permission['key'] }}" @empty(!$role->permission){{ in_array($permission['key'], $role->permission) ? "checked" : "" }}@endempty>
                                        <label for="permission_{{ $role->id }}_{{ $permission['key'] }}">{{$permission['title']}}</label>
                                    </div>
                                    @endforeach
                                </div>
                                @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection