@extends('admin.layouts.app')
@section('content')
<div class="row mx-0 mb-3">
    <div class="col-6">
        <h1 class="page-title"><?php echo __('role.pagetitle'); ?></h1>
    </div>

    <div class="top-btn-box col-6" id="normal_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
            <a tabindex="1" href="javascript:void(0)" class="btn btn-primary search-btn btn-sm show hide mr-1" id="search-btn">
                <em class="icon-search-icon top-icon"></em>
                <span class="btn-title">{{ __('common.search') }}</span>
            </a>
        </div>
    </div>

    <div class="top-btn-box hide col-6" id="action_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm active-btn"
                onclick="submitactionform('active');" id="active-btn" title="{{ __('common.active') }}">
                <em class="icon-radiobutton_checked top-icon"></em>
                <span class="btn-title">{{ __('common.active') }}</span>
            </a>
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm inactive-btn"
                onclick="submitactionform('inactive');" id="inactive-btn" title="{{ __('common.inactive') }}">
                <em class="icon-radio_button_unchecked top-icon"></em>
                <span class="btn-title">{{ __('common.inactive') }}</span>
            </a>
        </div>

    </div>

</div>

<div class="col-12 admin-holder">
    <div class="row">
        <div class="{{ Request::has('status') && Request::has('search') ? 'show' : 'hide' }}" id="searchbox">
            <form name="frmsearch" id="frmsearch" action="{{ route('role.index') }}" method="GET" class="col-12">
                @foreach (Request::all() as $key=>$value)
                @if (in_array($key,['search','status','btnsearch']))
                @continue
                @else
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endif
                @endforeach
                <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label>{{ __('role.rolename')}}/ {{__('role.roleshortname') }}</label>
                        <input tabindex="3" name="search" id="search" placeholder="{{ __('common.search') ." ". __('role.title')}}" type="text" class="form-control" value="{{ Request::get('search') }}">
                    </div>
                    <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                        <label>{{ __('role.status') }}</label>
                        <select tabindex="4" name="status" id="status" class="form-control">
                            <option value="">{{ __('common.select_status') }}</option>
                            @foreach (config('status') as $value => $label)
                            <option value="{{$value}}" {{ Request::get('status') != "" && intval(Request::get('status')) === $value ? 'selected' : '' }}>
                                {{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-12">
                        <button tabindex="5" type="submit" class="btn btn-primary submit-btn" id="btnsearch" name="btnsearch">{{ __('common.search') }}</button>
                        <a href="{{ route('role.index', ['search' => '', 'status' => '']) }}" class="btn btn-primary reset-btn">{{ __('common.reset') }}</a>
                        <button tabindex="7" type="button" class="btn btn-dark close-btn" id="search-btn-h">{{ __('common.close') }}</button>
                        <hr>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-12 sortable-main">
            <section id="wrapper">
                <form name="frmlist" id="frmlist" action="{{ route('role.bulkaction') }}" method="POST">
                    @csrf
                    <input type="hidden" name="bulk-action" value="">
                    <div class="table-responsive">
                    <table data-orders="1" data-target="3" class="admintable table table-hover mb-0" aria-describedby="TableDesc">
                        <thead>
                            <tr>
                                <th class="hide" scope="col"></th>

                                <th class="active-box status-column" scope="col">
                                    <em class="sort"></em>
                                </th>

                                <th class="check-box nosort" scope="col">
                                    <div class="custom-control custom-checkbox text-center">
                                        <input type="checkbox" class="custom-control-input" name="selectAll" id="selectAll" onclick="checkAll();">
                                        <label class="custom-control-label" for="selectAll">&nbsp;</label>
                                    </div>
                                </th>

                                <th scope="col" class="control nosort">
                                    <!-- this blank column is responsive controll -->
                                </th>

                                <th scope="col">
                                    <strong>{{ __('role.rolename') }}</strong>
                                </th>
                                <th class="text-right nosort" scope="col">{{__('common.edit')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($roles as $role)
                            @if($role->id == 1 || $role->id == 3) @continue @endif
                            <tr id="display_order_{{ $role->id }}">
                                <td class="hide">
                                    {{$role->id}}
                                </td>
                                <td class="active-box">
                                    <a href="{{ route('role.changestatus', ['id' => $role->id]) }} ">
                                        <span class="sort {{ $role->status == 1 ? 'active' : 'inactive' }} "></span>
                                    </a>
                                </td>
                                <td class="check-box">
                                    <div class="custom-control custom-checkbox text-center">
                                        <input type="checkbox" class="custom-control-input action-checkbox" id="filled-in-box_{{ $role->id }}" name="id[]" value="{{$role->id}}">
                                        <label class="custom-control-label" for="filled-in-box_{{ $role->id }}">&nbsp;</label>
                                    </div>
                                </td>
                                <td>

                                </td>

                                <td class="">
                                    <a href="{{ route('role.edit', ['role' => $role->id]) }}">
                                        {{ ucfirst(($role->title != '') ? $role->title : $role->shortname) }}
                                    </a>
                                </td>
                                <td class="text-right">
                                    <a href="{{ route('role.edit', ['role' => $role->id]) }}"><em class="icon-edit-icon"></em></a>
                                </td>
                            </tr>
                            @endforeach
                            @if (count($roles) == 0)
                            <tr class="noreocrd">
                                <td colspan="7" class="text-center">
                                    {{ __('role.no_result') }}
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                    </div>
                </form>
            </section>
        </div>
    </div>
</div>
@endsection