@extends('admin.layouts.app')
@section('content')
    <form method="post" name="frmaddedit" id="frmaddedit" action="{{ route('site-config.save', ['module' => $module]) }}"
        name="pwdform" id="pwdform" class="col s12">
        @csrf
        <div class="row mb-3">
            <h1 class="col-lg-6 page-title">{{ __('siteconfig.pagetitle') }}</h1>
            <div class="top-btn-box col-lg-6 text-center text-lg-right">
                <button tabindex="9" type="submit" class="btn btn-primary btn-sm" id="btnsave" name="btnsave"><em
                        class="icon-save_icon top-icon"></em> <span>{{ __('common.save') }}</span></button>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 site-config">
                <div class="accordion" id="site-config-accordion">
                    @php $i = 0; @endphp
                    @foreach (config('siteconfig') as $k => $config_group)
                        @php $showfirst = false; @endphp
                        @if ($i == 0)
                            @php $showfirst = true; @endphp
                        @endif
                        @if ($errors->any())
                            @php $showfirst = false; @endphp
                        @endif
                        @if ($config_group['module'] != $module)
                            @continue
                        @endif
                        @if ($config_group['module'] != $module)
                            @continue
                        @endif
                        <div class="card">
                            @php
                                $i++;
                                $is_error = false;
                                $fileds = collect($config_group['inputs'])->pluck('name')->flatten()->all();
                                foreach ($fileds as $field):
                                    if ($errors->has($field)):
                                        $is_error = true;
                                    endif;
                                endforeach;
                            @endphp
                            <div class="card-header p-0 bg-primary text-white" id="site-config-heading-{{ $k }}">
                                <h5 class="mb-0">
                                    <a class="btn px-3 py-2 d-block text-left text-white" href="javacript:void(0);"
                                        data-toggle="collapse" data-target="#accordion-item-{{ $k }}"
                                        aria-expanded="{{ $is_error || $showfirst ? 'true' : 'false' }}"
                                        aria-controls="accordion-item-{{ $k }}">
                                        {{ __($config_group['title']) }}
                                    </a>
                                </h5>
                            </div>

                            <div id="accordion-item-{{ $k }}"
                                class="collapse {{ $is_error || $showfirst ? 'show' : '' }}"
                                aria-labelledby="site-config-heading-{{ $k }}">
                                <div class="card-body">
                                    <div class="row">
                                        @foreach ($config_group['inputs'] as $input)
                                            @includeIf('admin.modules.siteconfig.fields.' . $input['type'])
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </form>


    <script>
        $(document).ready(function() {
            let debounceTimer;
            let isPromocodeValid = true;

            const promocodeInput = $("input[name='stripe_discount_code']");
            const promocodeKeyInput = $("input[name='stripe_discount_key']");
            const promocodeValue = $("input[name='subscribe_popup_discount_value']");
            const promocodeExpireDate = $("input[name='subscribe_popup_date_value']");
            const promocodeExpireDateId = $("input[id='subscribe_popup_date_value']");
            const showSubscribePopupSelect = $("select[name='show_subscribe_popup']");
            const form = $("#frmaddedit");

            const errorSelectors = {
                key: "#stripe_discount_key_error",
                value: "#subscribe_popup_discount_value_error",
                expireDate: "#subscribe_popup_date_value_error"
            };

            const inputFields = {
                key: promocodeKeyInput,
                value: promocodeValue,
                expireDate: promocodeExpireDate
            };

            const errorMessages = {
                key: "{{ __('Unable to fetch discount key. Please check discount code and try again.') }}",
                value: "{{ __('Unable to fetch discount value. Please check discount code and try again.') }}",
                expireDate: "{{ __('Unable to fetch discount expire date. Please check discount code and try again.') }}"
            };

            // Ensure error containers exist
            $.each(errorSelectors, function(key, selector) {
                if ($(selector).length === 0) {
                    inputFields[key].after(
                        `<div class="errormessage" id="${selector.replace('#', '')}"></div>`);
                }
            });

            function callAjax(promocode) {
                const url = "{{ route('checkIfPromocodeExists', 'PROMOCODE') }}".replace('PROMOCODE',
                    encodeURIComponent(promocode));

                $.ajax({
                    type: "GET",
                    url: url,
                    success: function(response) {
                        const coupon = response.coupon;

                        if (!coupon) {
                            isPromocodeValid = false;
                            showErrorMessages();
                            return;
                        }

                        isPromocodeValid = true;

                        // Set discount display
                        let discountDisplay = '';
                        if (coupon.percent_off !== null) {
                            discountDisplay = `${coupon.percent_off}%`;
                        } else if (coupon.amount_off !== null) {
                            discountDisplay = `$${(coupon.amount_off / 100)}`;
                        }

                        promocodeValue.val(discountDisplay);

                        // Format expiration date
                        let formattedDate = '';
                        if (response.expires_at) {
                            const date = new Date(response.expires_at * 1000);
                            // Format date to YYYY-MM-DD
                            formattedDate = date.toISOString().split('T')[0];
                            console.log(formattedDate);
                        }

                        promocodeExpireDateId.val(formattedDate);
                    },
                    error: function() {
                        isPromocodeValid = false;
                        showErrorMessages();
                    }
                });
            }

            function showErrorMessages() {
                $.each(inputFields, function(key, input) {
                    input.val('').addClass('is-invalid');
                    $(errorSelectors[key]).text(errorMessages[key]);
                });
            }

            function clearErrorMessages() {
                $.each(inputFields, function(key, input) {
                    input.removeClass('is-invalid');
                    $(errorSelectors[key]).text('');
                });
            }

            function togglePromocodeFields() {
                const showFields = showSubscribePopupSelect.val() === "1";
                const displayStyle = showFields ? 'block' : 'none';

                promocodeInput.closest('.form-group, .input-group, .field-wrapper').css('display', displayStyle);
                promocodeValue.closest('.form-group, .input-group, .field-wrapper').css('display', displayStyle);
                promocodeExpireDate.closest('.form-group, .input-group, .field-wrapper').css('display',
                    displayStyle);
            }

            // Initial visibility check
            togglePromocodeFields();

            // Change event for dropdown
            showSubscribePopupSelect.on("change", function() {
                togglePromocodeFields();

                const shouldShow = $(this).val() === "1";
                if (shouldShow) {
                    const promocode = promocodeInput.val().trim();
                    if (promocode.length > 0) {
                        callAjax(promocode);
                    }
                } else {
                    isPromocodeValid = true;
                    $.each(inputFields, (key, input) => input.val('').removeClass('is-invalid'));
                    clearErrorMessages();
                }
            });

            // Debounced promocode input
            promocodeInput.on("input", function() {
                if (showSubscribePopupSelect.val() !== "1") return;

                clearTimeout(debounceTimer);

                debounceTimer = setTimeout(function() {
                    const promocode = promocodeInput.val().trim();

                    clearErrorMessages();

                    if (promocode.length === 0) {
                        $.each(inputFields, (key, input) => input.val(''));
                        return;
                    }

                    callAjax(promocode);
                }, 500);
            });

            // Prevent form submission if promocode is invalid
            form.on("submit", function(e) {
                if (showSubscribePopupSelect.val() === "1" && !isPromocodeValid) {
                    e.preventDefault();
                    alert("Invalid promocode. Please correct it before submitting the form.");
                }
            });
        });
    </script>
@endsection
