@extends('admin.layouts.app')
@section('content')


<form method="post"
    action="{{ (isset($slider->id) ? route('slider.update',['slider' => $slider->id]) : route('slider.store'))  }}"
    name="frmaddedit" id="frmaddedit">
    <div class="row mx-0 mb-3">
        <div class="col-lg-6">
            <h1 class="page-title">{{ (isset($slider->id) ? __('slider.editpagetitle') : __('slider.addpagetitle'))  }}
            </h1>
        </div>
        <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
            <div class="top-btn-box">
                <div class="top-btn-box d-flex">
                    <a tabindex="500" id="btncancel" href="{{ route('slider.index') }}" class="btn btn-sm btn-dark mr-1"><em
                            class="icon-close-icon top-icon"></em> <span>{{ __('common.cancel') }}</span></a>
                    <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave" name="btnsave"
                        value='save'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.save') }}</span></button>
                    <button tabindex="900" type="submit" class="btn btn-sm btn-primary" id="btnsave" name="btnsave"
                        value='savecontinue'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.savecontinue') }}</span></button>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="form-group col-md-6">
                <label for="title">{{ __('slider.title') }}<span class="text-danger">*</span></label>
                <input id="title" type="text" class="form-control @error('title') is-invalid @enderror" name="title"
                    value="{{old('title',$slider->title)}}" data-validator="required" tabindex="3">
                <div class="errormessage">@error('title') {{ $message }} @enderror</div>
            </div>
            <div class="form-group col-md-6">
                <label for="display_order">{{ __('slider.display_order') }}</label>
                @if(isset($slider->id))
                <select class="form-control" id="display_order" name="display_order" tabindex="4">
                    @for ($i = 1; $i <= $maxnumber; $i++) <option value="{{ $i }}" @if( old('display_order', $slider->
                        display_order) == $i ) selected @endif>{{ $i }}</option>
                        @endfor
                </select>
                @else
                <input id="display_order" type="text" class="form-control @error('display_order') is-invalid @enderror"
                    name="display_order" value="{{$maxnumber + 1 }}" readonly tabindex="4">
                @endif
                @error('display_order')
                <div class="errormessage">{{ $message }}</div>
                @enderror
            </div>
            <div class="form-group col-md-12">
                <label for="overlay_text">{{ __('slider.overlay_text') }}</label>
                <input id="overlay_text" type="text" class="form-control @error('overlay_text') is-invalid @enderror"
                    name="overlay_text" value="{{old('overlay_text',$slider->overlay_text)}}" tabindex="5">
                @error('overlay_text')
                <div class="errormessage">{{ $message }}</div>
                @enderror
            </div>
            <div class="form-group col-md-12">
                <label for="temp_image">{{ __('slider.image') }}<span class="text-danger">*</span></label>
                <input type="file" id="temp_image" data-size="{{ getImageUploadSizeInMB('slider') }}" class="dropify image-upload" name="temp_image" data-folder="slider"
                    {{ old('image',$slider->image) != "" ? 'data-default-file='.getImageUrl(old('image',$slider->image),'slider') : ''}} @if(old('image',$slider->image)) @else data-validator="required" @endif tabindex="6" />
                <div><small>{{ getImageRecommendedSize('slider') }}</small></div>
                <input name="image" type="hidden" value="{{old('image',$slider->image)}}">
                <div id="error_image" class="errormessage  @error('image') @else{{  'd-none'  }} @enderror">
                    @error('image'){{ $message }}@enderror</div>
            </div>
            <div class="form-group col-md-6">
                <label for="alt_image_text">{{ __('slider.alt_image_text') }}<span class="text-danger">*</span></label>
                <input id="alt_image_text" type="text"
                    class="form-control @error('alt_image_text') is-invalid @enderror" name="alt_image_text"
                    value="{{old('alt_image_text',$slider->alt_image_text)}}" data-validator="required" tabindex="7">
                <div class="errormessage">@error('alt_image_text') {{ $message }} @enderror</div>
            </div>
            <div class="form-group col-md-6">
                <label for="status">{{ __('slider.status') }}</label>
                <select class="form-control" id="status" name="status" tabindex="8">
                    @foreach (config('status') as $value => $label)
                    <option value="{{ $value }}" @if( old('status', $slider->status) == $value ) selected
                        @endif>{{ $label }}</option>
                    @endforeach
                </select>
                @error('status')
                <div class="errormessage">{{ $message }}</div>
                @enderror
            </div>
        </div>
    </div>
</form>
@endsection
