@extends('admin.layouts.app')
@section('content')
<div class="row mx-0 mb-3">
    <div class="col-6">
        <h1 class="page-title">{{  __('slider.pagetitle') }}</h1>
    </div>
    <div class="top-btn-box col-6" id="normal_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
            <a tabindex="1" href="javascript:void(0)" class="btn btn-primary mr-1 search-btn btn-sm show hide"
                id="search-btn">
                <em class="icon-search-icon top-icon"></em>
                <span class="btn-title">{{ __('common.search') }}</span>
            </a>

            <a tabindex="2" href="#basic-uploader" id="addimagebtn"
                class="btn btn-primary addnew-btn btn-sm @if(count($sliders) == 0) hide  @endif" id="add-btn">
                <em class="icon-addnew top-icon"></em>
                <span class="btn-title">{{ __('common.add') }}</span>
            </a>

        </div>
    </div>
    <div class="top-btn-box col-6 hide" id="action_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
            <a href="javascript:void(0)" class="btn btn-sm btn-primary mr-1 active-btn"
                onclick="submitactionform('active');" id="active-btn">
                <em class="icon-radiobutton_checked top-icon"></em>
                <span class="btn-title">{{ __('common.active') }}</span>
            </a>
            <a href="javascript:void(0)" class="btn btn-sm btn-primary mr-1 inactive-btn"
                onclick="submitactionform('inactive');" id="inactive-btn">
                <em class="icon-radio_button_unchecked top-icon"></em>
                <span class="btn-title">{{ __('common.inactive') }}</span>
            </a>
            <a href="javascript:void(0)" class="btn btn-sm btn-dark delete-btn" onclick="submitactionform('delete');" id="delete-btn">
                <em class="icon-close-icon top-icon"></em>
                <span class="btn-title">{{ __('common.delete') }}</span>
            </a>
        </div>
    </div>
</div>
<div class="col-12 admin-holder">
    <div class="row">
        <div class="{{ Request::has('status') && Request::has('search') ? 'show' : 'hide' }}" id="searchbox">
            <form name="frmsearch" id="frmsearch" action="{{ route('slider.index') }}" method="GET" class="col-12">
                @foreach (Request::all() as $key=>$value)
                @if (in_array($key,['search','status','btnsearch']))
                @continue
                @else
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endif
                @endforeach
                <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label>{{ __('slider.title') }}</label>
                        <input tabindex="3" name="search" id="search"
                            placeholder="{{ __('common.search') ." ". __('slider.pagetitle') }}" type="text"
                            class="form-control" value="{{ Request::get('search') }}">
                    </div>
                    <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                        <label>{{ __('slider.status') }}</label>
                        <select tabindex="4" name="status" id="status" class="form-control">
                            <option value="">{{ __('common.select_status') }}</option>
                            @foreach (config('status') as $value => $label)
                            <option value="{{$value}}"
                                {{ Request::get('status') != "" && intval(Request::get('status')) === $value ? 'selected' : '' }}>
                                {{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-12">
                        <button tabindex="5" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                            name="btnsearch">{{ __('common.search') }}</button>
                        <a href="{{ route('slider.index', ['search' => '', 'status' => '']) }}"
                            class="btn btn-primary reset-btn" id="search_reset">{{ __('common.reset') }}</a>
                        <button tabindex="7" type="button" class="btn btn-dark close-btn"
                            id="search-btn-h">{{ __('common.close') }}</button>
                        <hr>
                    </div>
                </div>

            </form>
        </div>
    </div>

    <form name="frmlist" id="frmlist" action="{{ route('slider.bulkaction') }}" method="POST">
        @csrf
        <input type="hidden" name="bulk-action" value="">
        <div id="sliderlist">
            @include('admin.modules.slider.list')
        </div>
    </form>
    <div id="basic-uploader" style="padding-top: 15px;">
        <div class="row fileupload-buttonbar mb-1">
            <div class="col-lg-7">
                <!-- The fileinput-button span is used to style the file input field as button -->
                <span class="btn btn-success fileinput-button" id="addfiles">
                    <em class="glyphicon glyphicon-plus"></em>
                    <span>Add files...</span>
                    <input type="file" name="files[]" multiple>
                </span>
                <button type="submit" id="startall" class="btn btn-primary start">
                    <em class="glyphicon glyphicon-upload"></em>
                    <span>Start Upload</span>
                </button>
                <span class="fileupload-process"></span>
                </br>
            </div>
            <!-- The global progress state -->
            <div class="col-lg-5 fileupload-progress">
                <!-- The global progress bar -->
                <div class="progress progress-striped active hide" role="progressbar" aria-valuemin="0"
                    aria-valuemax="100">
                    <div class="progress-bar progress-bar-success" style="width:0%;"></div>
                </div>
                <!-- The extended global progress state -->
                <div class="progress-extended">&nbsp;</div>
            </div>
            <div class="col-lg-12">
                <em class="text-muted"><small>{{ getImageRecommendedSize('slider') }} </small></em>
            </div>
        </div>

        <!-- dropzone -->
        <div class="dropzone table-layout well mb-2 d-flex justify-content-center align-items-center"
            style="box-shadow:none;border-style:dashed;height:200px;">
            <div class="col-xs-11 text-center">
                <h3 class="text-muted"><em class="ico-file-plus2 mr5"></em> Drag and drop your file here!</h3>
            </div>
        </div>

        <!-- file list -->
        <div class="table-responsive">
            <table class="table table-striped table-hovered upload-lists" aria-describedby="DataTableDesc">
                <thead  style="display:none"><tr><th scope="col"></th></tr></thead>
                <tbody class="files"></tbody>
            </table>
        </div>
    </div>

</div>
@endsection
