@if(isset($sliders) && count($sliders) > 0)
<div class="row">
    <div class="col-md-12 mx-0 mb-3">
        <div class="custom-control custom-checkbox">
            <input type="checkbox" class="custom-control-input" name="selectAll" id="selectAll" onclick="checkAll();">
            <label class="custom-control-label" for="selectAll">{{ __('slider.select_unselect_all') }}</label>
        </div>
    </div>
</div>
<div class="row list-section sortable-list-section" data-sort-url="{{ route('slider.sort') }}" id="sortable">
    @foreach ($sliders as $slider)
    <div class="col-xl-4 col-lg-6 float-left mb-3 {{ $slider->status == 1 ? 'active' : 'inactive' }}"
        id="display_order_{{ $slider->id }}">
        <!-- thumbnail -->
        <div class="thumbnail thumbnail-album animation animating fadeInLeft" style="height: 262px;">
            <!-- media -->
            <div class="media doc_thumb_box lazy text-center"
                data-original="{{ getImageUrl($slider->image, 'slider') }}"
                style="background-size:100%;display: block; background-image: url({{ getImageUrl($slider->image, 'slider') }})">
                <!-- toolbar overlay -->
                <div class="overlay" style="vertical-align: middle !important;">
                    <div class="toolbar d-flex justify-content-center">

                        <a href="{{ getImageUrl($slider->image, 'slider') }}" target="_blank" rel="noopener"
                            class="image-link doc_url_a btn btn-primary d-flex align-items-center justify-content-center mx-1"
                            title="Preview"><em class=" tasktypeicofontsize icon-view-icon"></em></a>
                        <a title="Edit" href="{{route('slider.edit',$slider->id)}}"
                            class="btn btn-success d-flex align-items-center justify-content-center mx-1"><em
                                class="icon-edit-icon tasktypeicofontsize"></em></a>
                        <a href="javascript:void(0)" onclick="removeslider('{{$slider->id}}');" title="Delete"
                            class="btn btn-dark d-flex align-items-center justify-content-center mx-1"><em
                                class="icon ico-remove5 icon-close-icon text-primary tasktypeicofontsize"></em></a>
                    </div>
                </div>
                <div class="ellipsis">
                    <ul class="meta row no-gutters align-items-center">
                        <li class="col-1">
                            <div class="custom-control custom-checkbox my-1 mr-sm-2">
                                <input type="checkbox"
                                    class="custom-checkbox chkbox action-checkbox custom-control-input"
                                    id="filled-in-box_{{ $slider->id }}" name="id[]" value="{{$slider->id}}">
                                <label class="custom-control-label" for="filled-in-box_{{ $slider->id }}"></label>
                            </div>
                        </li>
                        <li class="col-11 text-right">
                            <div class="sort text-truncate {{ $slider->status == 1 ? 'active' : 'inactive' }} ">
                                <a href="#" class="slider-title" data-type="text" data-pk="{{ $slider->id }}" data-url="{{ route('slider.changetitle',['id' => $slider->id]) }}" data-title="Enter Title">{{ $slider->title }}</a>
                                <br><span class="emessage d-none text-danger"></span>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</div>
@else
<div class="row no-gutters">
    <div class="col-12 bg-white text-center p-2 border">
        {{ __('slider.no_result') }}
    </div>
</div>
@endif
