@extends('admin.layouts.app')
@section('content')

    <div class="row mx-0 mb-3">
        <div class="col-6">
            <h1 class="page-title"><?php echo __('submissions.pagetitle'); ?></h1>
        </div>
    </div>

    <div class="col-12 admin-holder">
        <div class="row">
            <div class="{{ Request::has('search') ? 'show' : 'show' }}" id="searchbox">
                <form name="frmsearch" id="frmsearch" action="{{ $submissions->appends(prepareInputRequestArray())->url(1) }}"
                    method="GET" class="col-12">
                    @foreach (Request::all() as $key => $value)
                        @if (in_array($key, ['search', 'status', 'btnsearch', 'type', 'export']))
                            @continue
                        @else
                            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                        @endif
                    @endforeach
                    <div class="row">
                        <div class="form-group col-md-4 col-12">
                            <label>{{ __('submissions.username') }} / {{ __('submissions.podcast_name') }} /
                                {{ __('submissions.bar') }}</label>
                            <input tabindex="3" name="search" id="search"
                                placeholder="{{ __('common.search') . ' ' . __('submissions.pagetitle') }}" type="text"
                                class="form-control rounded" value="{{ Request::get('search') }}">
                        </div>

                        {{-- filter --}}
                        <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                            <label>{{ __('submissions.filter') }}</label>
                            <select tabindex="5" name="status" id="status" class="form-control">
                                <option value="">{{ __('user.select_status') }}</option>

                                @php
                                    $selectedValue = Request::get('status') != '' ? intval(Request::get('status')) : '';
                                @endphp
                                @foreach (config('submission_status') as $key => $val)
                                    <option value="{{ $key }}" {{ $selectedValue === $key ? 'selected' : '' }}>
                                        {{ config('submission_status')[$key] }}
                                    </option>
                                @endforeach

                            </select>
                        </div>

                        {{-- filter --}}
                        @if (Auth::user()->user_type_id == 1)
                            <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                                <label>{{ __('submissions.firm') }}</label>
                                <select tabindex="5" name="firm" id="firm" class="form-control">
                                    <option value="">{{ __('submissions.select_firm') }}</option>

                                    @php
                                        $selectedValue = Request::get('firm') != '' ? Request::get('firm') : '';

                                    @endphp
                                    @foreach ($firmList as $key => $val)
                                        <option value="{{ $key }}"
                                            {{ $selectedValue === $key ? 'selected' : '' }}>
                                            {{ $val }}
                                        </option>
                                    @endforeach

                                </select>
                            </div>
                        @endif

                        {{-- filter --}}
                        <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                            <label>{{ __('submissions.filter') }}</label>
                            <select tabindex="5" name="type" id="type" class="form-control">
                                <option value="">{{ __('user.select_type') }}</option>
                                @if (!empty($filters))
                                    @php
                                        $selectedValue = Request::get('type') != '' ? intval(Request::get('type')) : 5;
                                    @endphp
                                    @foreach ($filters as $filter)
                                        <option value="{{ $filter['id'] }}"
                                            {{ $selectedValue === $filter['id'] ? 'selected' : '' }}>
                                            {{ $filter['title'] }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="form-group col" id="dateRange" style="display:none">
                            <div class=row>
                                <div class="col">
                                    <label>{{ __('submissions.start_date') }}</label>
                                    <input type="text" name="start_date"
                                        value="{{ Request::get('start_date') != '' ? Request::get('start_date') : '' }}"
                                        class="form-control datepicker" />
                                </div>
                                <div class="col">
                                    <label>{{ __('submissions.end_date') }}</label>
                                    <input type="text" name="end_date"
                                        value="{{ Request::get('end_date') != '' ? Request::get('end_date') : '' }}"
                                        class="form-control datepicker" />
                                </div>
                            </div>

                        </div>

                        <div class="form-group col-12">
                            <button tabindex="6" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                                name="btnsearch">{{ __('common.search') }}</button>
                            <a href="{{ $reset_link }}" class="btn btn-primary reset-btn"
                                id="search_reset">{{ __('common.reset') }}</a>
                            {{-- <button tabindex="7" type="button" class="btn btn-dark close-btn"
                                id="search-btn-h">{{ __('common.close') }}</button> --}}
                            {{-- <input tabindex="8" type="button" class="btn btn-primary submit-btn" id="export_btn"
                                value={{ __('submissions.export') }} /> --}}
                            <hr>
                        </div>
                    </div>
                </form>


                <div class="top-btn-box hide col-12" id="action_btns-submissions">
                    <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
                        @if (Auth::user()->user_type_id == 1)
                            <a href="javascript:void(0)" class="btn btn-dark export-btn ml-2"
                                onclick="submitactionformSubmission('export');" title="{{ __('common.export') }}">
                                {{ __('submissions.export_btn') }}
                            </a>

                            <a href="javascript:void(0)" class="btn btn-dark submitted-btn ml-2"
                                onclick="submitactionformSubmission('submit');" title="{{ __('common.submit') }}">
                                {{ __('submissions.submit_btn') }}

                            </a>

                            <a href="javascript:void(0)" class="btn btn-dark approved-btn ml-2"
                                onclick="submitactionformSubmission('approve');" title="{{ __('common.approve') }}">
                                {{ __('submissions.approve_btn') }}

                            </a>
                        @endif
                        {{-- <a href="javascript:void(0)" class="btn btn-dark btn-sm send-certificate-btn ml-2" onclick="submitactionformSubmission('send certificate');"
                             title="{{ __('common.send_certificate') }}">
                             {{ __('submissions.certificate_btn') }}
                        </a> --}}
                    </div>
                </div>

            </div>
            <iframe id="downloadIframe" name="downloadIframe" style="display:none;"></iframe>

            <div class="col-12 photos-main">
                <section id="wrapper">
                    <form name="frmlist" id="frmlist" action="{{ route('submissions.bulkaction') }}" method="POST"
                        target="downloadIframe">
                        @csrf
                        <input type="hidden" name="bulk-action" value="">
                        <div class="table-responsive">
                        <table data-orders="0" data-target="0" class="admintable table table-hover mb-0"
                            aria-describedby="DataTableDesc" style="width: 100%">
                            <thead>
                                <tr>
                                    <th class="hide" scope="col">
                                        <!-- this blank column is for primary column -->

                                    </th>
                                    @if (canUserAccess('manage-student'))
                                        <th class="check-box nosort" scope="col">
                                            <div class="custom-control custom-checkbox text-center">
                                                <input type="checkbox" class="custom-control-input" name="selectAll"
                                                    id="selectAllSubmissions" onclick="checkAllSubmissions();">
                                                <label class="custom-control-label" for="selectAllSubmissions"></label>
                                            </div>
                                        </th>
                                    @endif
                                    <th scope="col" class="control nosort">
                                        <!-- this blank column is responsive controll -->

                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('submissions.username') }}
                                            </span>
                                        </div>
                                    </th>

                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('submissions.bar') }}
                                            </span>
                                        </div>
                                    </th>


                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('submissions.podcast_name') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('submissions.submitted_credits') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('submissions.status') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('submissions.received_on') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('submissions.exported_on') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('submissions.submitted_on') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col"  class="d-none" id="approved_on_header">
                                        <div>
                                            <span>
                                                {{ __('submissions.approved_on') }}
                                            </span>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($details as $detail)
                                    <td class="active-box hide">
                                        <em style="display:none">{{ $detail->id }}</em>
                                    </td>
                                    @if (canUserAccess('manage-student'))
                                        <td class="check-box">
                                            <div class="custom-control custom-checkbox text-center">

                                                <input type="hidden"
                                                    class="custom-control-input action-checkbox-submissions"
                                                    id="filled-in-box_{{ $detail->status }}"
                                                    name="status[{{ $detail->id }}]" value="{{ $detail->status }}">

                                                <input type="checkbox"
                                                    class="custom-control-input action-checkbox-submissions"
                                                    id="filled-in-box_{{ $detail->id }}" name="id[]"
                                                    value="{{ $detail->id }}">
                                                <label class="custom-control-label"
                                                    for="filled-in-box_{{ $detail->id }}"></label>

                                            </div>
                                    @endif
                                    </td>
                                    <td>

                                    </td>
                                    <td>{{ $detail->user_name }}</br>{{ $detail->user_bar_id }}</td>

                                    <td>{{ $detail->state_name }}</td>
                                    <td>{{ $detail->podcast_title }}</br>{{ $detail->podcast_id_for_bar }}</td>
                                    <td>{{ $detail->credits_submitted }}</td>
                                    <td>{{ config('submission_status')[$detail->status] }}</td>

                                    <td
                                        data-sort="{{ \Carbon\Carbon::parse($detail->created_at)->format('Y/m/d H:i:s') }}">
                                        {{ $detail->created_at }}
                                    </td>
                                    <td
                                        data-sort="{{ \Carbon\Carbon::parse($detail->exported_at)->format('Y/m/d H:i:s') }}">
                                        {{ $detail->exported_at ? \Carbon\Carbon::parse($detail->exported_at)->format(config('app.datetime_format')) : '' }}
                                    </td>
                                    <td
                                        data-sort="{{ \Carbon\Carbon::parse($detail->submitted_at)->format('Y/m/d H:i:s') }}">

                                        {{ $detail->submitted_at ? \Carbon\Carbon::parse($detail->submitted_at)->format(config('app.datetime_format')) : '' }}
                                    </td>

                                    <td data-sort="{{ \Carbon\Carbon::parse($detail->approved_at)->format('Y/m/d H:i:s') }}"  class="approved_on_content d-none">

                                        {{ $detail->approved_at ? \Carbon\Carbon::parse($detail->approved_at)->format(config('app.datetime_format')) : '' }}
                                    </td>
                                    </tr>
                                @endforeach
                                @if ($submissions->total() == 0)
                                    <tr class="noreocrd">
                                        <td colspan="10" class="text-center">
                                            {{ __('submissions.empty') }}
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        </div>
                    </form>
                </section>
            </div>
        </div>
    </div>
    <div class="modal fade" id="confirm-action-modal-submission" tabindex="-1" role="dialog" aria-hidden="true">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><img
                    src="{{ asset('assets/front/images/close-model.svg') }}" alt="close button"></span>
        </button>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h2><strong>Confirm</strong></h2>
                </div>
                <div class="modal-body">
                    <div id="dependent_msg_submission"></div>
                    Are you sure you want to <strong class="modal-action-name"></strong> the selected
                    {{ collect(request()->segments())->last() }}(s) ?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-sm btn-dark" data-dismiss="modal">Cancel</button>
                    <a href="#" id="display_submit_btn"
                        class="confirm-action-submissions-submit btn btn-sm btn-primary">{{ __('submissions.submit_btn') }}</a>
                    <a href="#" id="display_export_btn"
                        class="confirm-action-submissions-submit btn btn-sm btn-primary">{{ __('submissions.export_btn') }}</a>
                    <a href="#" id="display_certificate_btn"
                        class="confirm-action-submissions-submit btn btn-sm btn-primary hide">{{ __('submissions.certificate_btn') }}</a>
                    <a href="#" id="display_approve_btn"
                        class="confirm-action-submissions-submit btn btn-sm btn-primary hide">{{ __('submissions.approve_btn') }}</a>
                </div>
            </div>
        </div>
    </div>
    <script>
        checkStatusOfSelection();
        // Function to show or hide dateRange based on selected value
        function toggleDateRange(selectedValue) {
            if (selectedValue == 3) {
                $('#dateRange').show();
            } else {
                $('#dateRange').hide();
            }
        }

        function toggleApprovedOnColumn(selectedValueStatus) {
            if (selectedValueStatus == 4) {
                $('#approved_on_header').removeClass("d-none");
                $('.approved_on_content').removeClass("d-none");
            } else {
                $('#approved_on_header').addClass("d-none");
                $('.approved_on_content').addClass("d-none");
            }
        }

        var selectedValue = $('#type').val();
        var selectedValueStatus = $('#status').val();
        toggleDateRange(selectedValue);
        toggleApprovedOnColumn(selectedValueStatus);

        $('#type').change(function() {
            var selectedValue = $(this).val();
            toggleDateRange(selectedValue);
        });
        $('#status').change(function() {
            var selectedValueStatus = $(this).val();
            toggleApprovedOnColumn(selectedValueStatus);
        });

        $(document).on("click", "#export_btn", function() {
            $('#frmsearch').append('<input type="hidden" name="export" value="{{ __('submissions.export') }}">');
            $('#frmsearch').attr('target', '_blank').submit();
            $(".loader").hide();
            location.reload();
        });

        $(document).on("change", "input.action-checkbox-submissions[name='id[]']", function() {

            checkStatusOfSelection();
            if (
                $("input.action-checkbox-submissions[name='id[]']").filter(":checked").length ==
                $("input.action-checkbox-submissions[name='id[]']").length
            ) {
                $("#selectAllSubmissions").prop("checked", true);
            } else {
                $("#selectAllSubmissions").prop("checked", false);
            }
        });

        /* Start: Check All */
        function checkAllSubmissions() {
            if ($("#selectAllSubmissions").prop("checked") == true) {
                $("input.action-checkbox-submissions[name='id[]']").each(function() {
                    $(this).prop("checked", true);
                });
            } else {
                $("input.action-checkbox-submissions[name='id[]']").each(function() {
                    $(this).prop("checked", false);
                });
            }
            checkStatusOfSelection();
        }

        function checkStatusOfSelection() {
            $('.export-btn').hide();
            $('.submitted-btn').hide();
            $('.approved-btn').hide();
            $('#action_btns-submissions').hide();
            $('#display_export_btn').hide();
            $('#display_submit_btn').hide();
            $('#display_approve_btn').hide();
            $('#display_certificate_btn').hide();
            var checkedValues = [];
            var countReceived = 0;
            var countExported = 0;
            var countSubmitted = 0;
            var countApproved = 0;

            $("input.action-checkbox-submissions[name='id[]']:checked").each(function() {
                var idValue = $(this).val();
                checkedValues.push(idValue);
                var statusValue = $("input.action-checkbox-submissions[name='status[" + idValue + "]']").val();

                if (statusValue == 0) {
                    countReceived++;
                } else if (statusValue == 1) {
                    countExported++;
                } else if (statusValue == 2) {
                    countSubmitted++;
                } else if (statusValue == 4) {
                    countApproved++;
                }
            });
            if (checkedValues.length > 0) {
                $('#action_btns-submissions').show();
            } else {
                $('#action_btns-submissions').hide();
            }

            if (checkedValues.length > 0 && checkedValues.length === countReceived) {
                $('.export-btn').show();
            } else if (checkedValues.length > 0 && checkedValues.length === countExported) {
                $('.submitted-btn').show();
            } else if (checkedValues.length > 0 && checkedValues.length === countSubmitted) {
                $('.approved-btn').show();
            } else {
                $('.export-btn').hide();
                $('.submitted-btn').hide();
                $('.approved-btn').hide();
            }
        }

        function submitactionformSubmission(action) {
            $("input[name='bulk-action']").val(action);
            if (action == "export") {
                $("#display_export_btn").show();
            } else if (action == "submit") {
                $("#display_submit_btn").show();
            } else if (action == "send certificate") {
                $("#display_certificate_btn").show();
            } else if (action == "approve") {
                $("#display_approve_btn").show();
            }
            var html = "";
            $("#dependent_msg_submission").html(html);
            var actionText = action;
            $(".modal-action-name").html(actionText.toUpperCase());
            $("#confirm-action-modal-submission").modal("show");
        }

        $(".confirm-action-submissions-submit").click(function() {
            if ($("input[name='bulk-action']").val() == "export") {
                $('#frmlist').submit();

                $("#confirm-action-modal-submission").modal("hide");

                $(".ajax_message").removeClass("d-none");
                $(".ajax_message")
                    .find("span")
                    .addClass("successmessage")
                    .addClass("text-success")
                    .html("{{ __('submissions.exported_success') }}");
                setTimeout(function() {
                    $(".ajax_message")
                        .find("span")
                        .html("");
                    location.reload();
                }, message_display_time);
            } else if ($("input[name='bulk-action']").val() == "submit") {
                var html = ""
                if ($("input[name='bulk-action']").val() == "submit") {
                    html = "{{ __('submissions.submitted_success') }}";
                } else if ($("input[name='bulk-action']").val() == "send certificate") {
                    html = "{{ __('submissions.send_certificated_success') }}";
                }
                $('#frmlist').submit();

                $("#confirm-action-modal-submission").modal("hide");

                $(".ajax_message").removeClass("d-none");
                $(".ajax_message")
                    .find("span")
                    .addClass("successmessage")
                    .addClass("text-success")
                    .html(html);
                setTimeout(function() {
                    $(".ajax_message")
                        .find("span")
                        .html("");
                    location.reload();
                }, 2000);
            } else {
                var html = ""
                if ($("input[name='bulk-action']").val() == "approve") {
                    html = "{{ __('submissions.approved_success') }}";
                } else if ($("input[name='bulk-action']").val() == "send certificate") {
                    html = "{{ __('submissions.send_certificated_success') }}";
                }
                $('#frmlist').submit();

                $("#confirm-action-modal-submission").modal("hide");

                $(".ajax_message").removeClass("d-none");
                $(".ajax_message")
                    .find("span")
                    .addClass("successmessage")
                    .addClass("text-success")
                    .html(html);
                setTimeout(function() {
                    $(".ajax_message")
                        .find("span")
                        .html("");
                    location.reload();
                }, 2000);
            }


        });
    </script>

@endsection
