@extends('admin.layouts.app')
@section('content')
    <div class="row mx-0 mb-3">
        <div class="col-6">
            <h1 class="page-title"><?php echo __('subscriptions.pagetitle'); ?></h1>
        </div>
        <div class="top-btn-box col-6" id="normal_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
                <a tabindex="1" href="javascript:void(0)" class="btn btn-primary mr-1 search-btn btn-sm show hide"
                    id="search-btn">
                    <em class="icon-search-icon top-icon"></em>
                    <span class="btn-title">{{ __('common.search') }}</span>
                </a>
            </div>
        </div>

        <div class="top-btn-box hide col-6" id="action_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
                <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');"
                    id="delete-btn" title="{{ __('common.delete') }}">
                    <em class="icon-close-icon top-icon"></em>
                    <span class="btn-title">{{ __('common.delete') }}</span>
                </a>
            </div>

        </div>
    </div>

    <div class="col-12 admin-holder">
        <div class="row">
            <div class="{{ Request::has('search') ? 'show' : 'hide' }}" id="searchbox">
                <form name="frmsearch" id="frmsearch"
                    action="{{ $subscriptions->appends(prepareInputRequestArray())->url(1) }}" method="GET"
                    class="col-12">
                    @foreach (Request::all() as $key => $value)
                        @if (in_array($key, ['search', 'status', 'btnsearch', 'name', 'bar', 'status', 'firm', 'export']))
                            @continue
                        @else
                            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                        @endif
                    @endforeach
                    <div class="row">
                        {{-- <div class="form-group col-md-6 col-12">
                            <label>{{ __('subscriptions.bar') }} / {{ __('subscriptions.subscription_status') }} /
                                {{ __('subscriptions.username') }}</label>
                            <input tabindex="3" name="search" id="search"
                                placeholder="{{ __('common.search') . ' ' . __('subscriptions.pagetitle') }}"
                                type="text" class="form-control rounded" value="{{ Request::get('search') }}">
                        </div> --}}

                        {{-- filter --}}
                        {{-- name filter  --}}
                        <div class="form-group col-xl-3 col-lg-5 col-md-6 col-12">
                            <label>{{ __('subscriptions.name_filter') }}</label>
                            <select tabindex="5" name="name" id="name-filter" class="form-control selectpicker" data-live-search="true">
                                <option value="">{{ __('subscriptions.select_name') }}</option>
                                @if (!empty($namefilter))
                                    @foreach ($namefilter as $id => $name)
                                        <option value="{{ $id }}"
                                            {{ Request::get('name') != '' && intval(Request::get('name')) === $id ? 'selected' : '' }}>
                                            {{ $name }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>

                        {{-- bar filter --}}
                        <div class="form-group  col-xl-3 col-lg-5 col-md-6 col-12">
                            <label>{{ __('subscriptions.bar_filter') }}</label>
                            <select tabindex="5" name="bar" id="bar-filter" class="form-control selectpicker">
                                <option value="">{{ __('subscriptions.select_bar') }}</option>
                                @if (!empty($barfilter))
                                    @foreach ($barfilter as $id => $name)
                                        <option value="{{ $id }}"
                                            {{ Request::get('bar') != '' && intval(Request::get('bar')) === $id ? 'selected' : '' }}>
                                            {{ $name }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>

                        {{-- status filter --}}
                        <div class="form-group  col-xl-3 col-lg-5 col-md-6 col-12">
                            <label>{{ __('subscriptions.status_filter') }}</label>
                            <select tabindex="5" name="status" id="status-filter" class="form-control selectpicker">
                                <option value="">{{ __('subscriptions.select_status') }}</option>
                                @if (!empty($statusfilter))
                                    @foreach ($statusfilter as $id => $name)
                                        <option value="{{ $id }}"
                                            {{ Request::get('status') != '' && Request::get('status') === $id ? 'selected' : '' }}>
                                            {{ $name }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>

                        {{-- firm filter --}}
                        @if (Auth::user()->user_type_id == 1)
                            <div class="form-group  col-xl-3 col-lg-5 col-md-6 col-12">
                                <label>{{ __('subscriptions.firm_filter') }}</label>
                                <select tabindex="5" name="firm" id="firm-filter" class="form-control selectpicker">
                                    <option value="">{{ __('subscriptions.select_firm') }}</option>
                                    @if (!empty($firmfilter))
                                        @foreach ($firmfilter as $id => $name)
                                            @if (!empty($name))
                                                <option value="{{ $id }}"
                                                    {{ Request::get('firm') != '' && Request::get('firm') === $id ? 'selected' : '' }}>
                                                    {{ $name }}
                                                </option>
                                            @endif
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        @endif

                        {{-- filters end --}}

                        <div class="form-group col-12">
                            <button tabindex="6" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                                name="btnsearch">{{ __('common.search') }}</button>
                            <a href="{{ $reset_link }}" class="btn btn-primary reset-btn"
                                id="search_reset">{{ __('common.reset') }}</a>
                            <button tabindex="7" type="button" class="btn btn-dark close-btn"
                                id="search-btn-h">{{ __('common.close') }}</button>
                            <input tabindex="8" type="button" class="btn btn-primary submit-btn" id="export_btn"
                                 value={{ __('subscriptions.export') }} />
                            <hr>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-12 photos-main">
                <section id="wrapper">
                    <form name="frmlist" id="frmlist" action="{{ route('subscriptions.bulkaction') }}" method="POST">
                        @csrf
                        <input type="hidden" name="bulk-action" value="">
                        <div class="table-responsive">
                        <table data-orders="0" data-target="0"
                            class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                            <thead>
                                <tr>
                                    <th scope="col" class="control nosort">
                                        <!-- this blank column is responsive controll -->
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('subscriptions.username') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('subscriptions.bar') }}
                                            </span>
                                        </div>
                                    </th>
                                    @if (Auth::user()->user_type_id == 1)
                                        <th scope="col">
                                            <div>
                                                <span>
                                                    {{ __('subscriptions.firm_name') }}
                                                </span>
                                            </div>
                                        </th>
                                    @endif
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('subscriptions.subscription_status') }}
                                            </span>
                                        </div>
                                    </th>

                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('subscriptions.start_date') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('subscriptions.end_date') }}
                                            </span>
                                        </div>
                                    </th>

                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('subscriptions.paid_by') }}
                                            </span>
                                        </div>
                                    </th>
                                    @if (Auth::user()->user_type_id == 2)
                                        <th scope="col">
                                            <div>
                                                <span>
                                                    {{ __('subscriptions.action') }}
                                                </span>
                                            </div>
                                        </th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($details as $detail)
                                    <tr>
                                        <td></td>
                                        <td>{{ $detail->user_firstname }} {{ $detail->user_lastname }}</td>
                                        <td>{{ $detail->bar_name }}</td>
                                        @if (Auth::user()->user_type_id == 1)
                                            <td>{{ $detail->firm_name }}</td>
                                        @endif
                                        <td>
                                            <span style="text-transform: uppercase;">{{ $detail->stripe_subscription_status }}</span>
                                            @if ($detail->cancel_at_period_end == 1)
                                                <br><span>{{ __('subscriptions.canceled_renewal') }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $detail->start_date }}</td>
                                        <td>{{ $detail->end_date }}</td>
                                        <td>{{ ($detail->paid_by == 2)?"FIRM":"USER" }}</td>
                                        @if (Auth::user()->user_type_id == 2)
                                            <td>
                                                @if($detail->paid_by == 2)
                                                    <button type="button" class="btn btn-primary m-2 renewClick" data-user_id={{$detail->user_id}} data-subscription_id={{$detail->id}} data-bar_user_references_id={{$detail->bar_user_references_id}}>Renew</button>
                                                    @if ($detail->stripe_subscription_status != "canceled")
                                                        @if ($detail->cancel_at_period_end != 1)
                                                            <button type="button" class="btn btn-danger cancelCLick" data-subscription_id={{$detail->id}} >Cancel</button>
                                                        @endif
                                                    @endif
                                                @endif
                                            </td>
                                        @endif
                                    </tr>
                                @endforeach
                                @if ($subscriptions->total() == 0)
                                    <tr class="noreocrd">
                                        <td colspan="10" class="text-center">
                                            {{ __('subscriptions.empty') }}
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        </div>
                    </form>
                </section>
            </div>
        </div>
    </div>
    <!-- Confirmation Modal -->
<div class="modal fade" id="confirmationModal" tabindex="-1" role="dialog" aria-labelledby="confirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmationModalLabel">Are you sure?</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          Proceed for payment now.
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="button" class="btn btn-primary" id="confirmProceedButton">Yes, Proceed!</button>
        </div>
      </div>
    </div>
  </div>
    <!-- Cancel Confirmation Modal -->
<div class="modal fade" id="cancelconfirmationModal" tabindex="-1" role="dialog" aria-labelledby="cancelconfirmationModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Are you sure?</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
            <b>You want to cancel your subscription?</b>
            <p>You'll still be able to use your subscription features till current plan expire.</p>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Not Now</button>
          <button type="button" class="btn btn-primary" id="cancelconfirmProceedButton">Yes, Proceed!</button>
        </div>
      </div>
    </div>
  </div>
@endsection
@section('extra-js-2')
<script>
    $(document).ready(function() {

        var reloadRequired = @json(session('reload'));
        if (reloadRequired) {
            $(".loader").addClass('d-flex');
            setTimeout(function() {
                $(".loader").removeClass('d-flex');
                window.location.href = "{{ route('subscriptions.index') }}";
            }, 3000); // 3000 milliseconds = 3 seconds
        }

        var bar_user_references_id = 0
        var subscription_id = 0
        var user_id = 0
        $(document).on('click','.renewClick',function() {
            subscription_id = $(this).attr("data-subscription_id")
            bar_user_references_id = $(this).attr("data-bar_user_references_id")
            user_id = $(this).attr("data-user_id")
            $('#confirmationModal').modal('show');
        });

        $(document).on('click','.cancelCLick',function() {
            subscription_id = $(this).attr("data-subscription_id")
            $('#cancelconfirmationModal').modal('show');
        });

        $('#confirmProceedButton').on('click', function() {
            window.location.href = "{{ route('renewalSubscription', [':id', 'subscription_id', 'bar_user_references_id']) }}".replace(':id', user_id).replace('subscription_id', subscription_id).replace('bar_user_references_id', bar_user_references_id);
        });
        $('#cancelconfirmProceedButton').on('click', function() {
            window.location.href = "{{ route('cancelSubscriptionByFirm', ':subscription_id') }}".replace(':subscription_id', subscription_id);
        });

        $(document).on("click", "#export_btn", function() {
            $('#frmsearch').append('<input type="hidden" name="export" value="{{ __('subscriptions.export') }}">');
            $('#frmsearch').attr('target', '_blank').submit();
            $(".loader").hide();
            location.reload();
        });
    });
</script>
@endsection
