@extends('admin.layouts.app')
@section('content')
    <div class="row mx-0 mb-3">
        <div class="col-6">
            <h1 class="page-title"><?php echo __('support.pagetitle'); ?></h1>
        </div>
        <div class="top-btn-box col-6" id="normal_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
                <a tabindex="1" href="javascript:void(0)" class="btn btn-primary mr-1 search-btn btn-sm show hide"
                    id="search-btn">
                    <em class="icon-search-icon top-icon"></em>
                    <span class="btn-title">{{ __('common.search') }}</span>
                </a>
            </div>
        </div>

        <div class="top-btn-box hide col-6" id="action_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
                <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');"
                    id="delete-btn" title="{{ __('common.delete') }}">
                    <em class="icon-close-icon top-icon"></em>
                    <span class="btn-title">{{ __('common.delete') }}</span>
                </a>
            </div>

        </div>
    </div>

    <div class="col-12 admin-holder">
        <div class="row">
            <div class="{{ Request::has('search') ? 'show' : 'hide' }}" id="searchbox">
                <form name="frmsearch" id="frmsearch"
                    action="{{ $supportData->appends(prepareInputRequestArray())->url(1) }}" method="GET" class="col-12">
                    @foreach (Request::all() as $key => $value)
                        @if (in_array($key, ['search', 'status', 'btnsearch']))
                            @continue
                        @else
                            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                        @endif
                    @endforeach
                    <div class="row">
                        <div class="form-group col-md-6 col-12">
                            <label>{{ __('support.name') }} / {{ __('support.email') }} /
                                {{ __('support.phone_number') }}</label>
                            <input tabindex="3" name="search" id="search"
                                placeholder="{{ __('common.search') . ' ' . __('support.pagetitle') }}" type="text"
                                class="form-control rounded" value="{{ Request::get('search') }}">
                        </div>


                        <div class="form-group col-12">
                            <button tabindex="6" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                                name="btnsearch">{{ __('common.search') }}</button>
                            <a href="{{ $reset_link }}" class="btn btn-primary reset-btn"
                                id="search_reset">{{ __('common.reset') }}</a>
                            <button tabindex="7" type="button" class="btn btn-dark close-btn"
                                id="search-btn-h">{{ __('common.close') }}</button>
                            <hr>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-12 photos-main">
                <section id="wrapper">
                    <form name="frmlist" id="frmlist" action="{{ route('support.bulkaction') }}" method="POST">
                        @csrf
                        <input type="hidden" name="bulk-action" value="">
                        <div class="table-responsive">
                        <table data-orders="4" data-target="@if (canUserAccess('manage-support')) 3 @else 1 @endif"
                            class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                            <thead>
                                <tr>
                                    <th class="hide" scope="col">
                                        <!-- this blank column is for primary column -->

                                    </th>
                                    @if (canUserAccess('manage-support'))
                                        <th class="active-box"></th>
                                        <th class="check-box nosort" scope="col">
                                            <div class="custom-control custom-checkbox text-center">
                                                <input type="checkbox" class="custom-control-input" name="selectAll"
                                                    id="selectAll" onclick="checkAll();">
                                                <label class="custom-control-label" for="selectAll"></label>
                                            </div>
                                        </th>
                                    @endif
                                    <th scope="col" class="control nosort">
                                        <!-- this blank column is responsive controll -->

                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('support.name') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('support.phone_number') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('support.email') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('support.comment') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('support.created_at') }}
                                            </span>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($supportData as $support)
                                    <tr>
                                        <td class="active-box hide">
                                            <em style="display:none">{{ $support->id }}</em>
                                        </td>
                                        @if (canUserAccess('manage-support'))
                                            <td></td>
                                            <td class="check-box">
                                                <div class="custom-control custom-checkbox text-center">
                                                    <input type="checkbox"
                                                        class="custom-control-input chkbox action-checkbox"
                                                        id="filled-in-box_{{ $support->id }}" name="id[]"
                                                        value="{{ $support->id }}">
                                                    <label class="custom-control-label"
                                                        for="filled-in-box_{{ $support->id }}"></label>
                                                </div>
                                            </td>
                                        @endif
                                        <td></td>
                                        <td>{{ $support->firstName }} {{ $support->lastName }}</td>
                                        <td>{{ formatPhoneNumber($support->phone) }}</td>

                                        <td>
                                            <div class="email-add"><a
                                                    href="mailto:{{ $support->email }}">{{ $support->email }}</a>
                                            </div>
                                        </td>

                                        <td>
                                            <p>{{ $support->comment }}</p>
                                        </td>
                                        <td
                                            data-sort="{{ \Carbon\Carbon::parse($support->created_at)->format('Y/m/d H:i:s') }}">
                                            {{ $support->created_at }}</td>

                                    </tr>
                                @endforeach
                                @if ($supportData->total() == 0)
                                    <tr class="noreocrd">
                                        <td colspan="10" class="text-center">

                                            {{ __(Request::segment(2) . '.no_result') }}
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        </div>
                    </form>
                </section>
            </div>
        </div>
    </div>
@endsection
