@extends('admin.layouts.app')
@section('content')

<form method="post" action="{{ route('courseprogress.update', $user->id)}}" sub_title="frmaddedit" id="frmaddedit">
    <div class="row mx-0 mb-3"> 
        <div class="col-lg-6">
            <h1 class="page-title">{{ __('courseprogress.pageTitle')}}</h1>
        </div>
        <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
            <div class="top-btn-box">
                <div class="top-btn-box d-flex">
                    <a tabindex="8" id="btncancel" href="{{ route('student.progress',$user->id) }}" class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em> <span>{{ __('common.cancel') }}</span></a>
                    <button tabindex="9" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave" name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.save') }}</span></button>
                    <button tabindex="10" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave" name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                        <span>{{ __('common.savecontinue') }}</span></button>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
     @csrf
     <input type="hidden" name="course_id" value={{$course->course_id}} >
     <input type="hidden" name="user_id" value={{$user->id}} >
     <input type="hidden" name="current_status" value={{$course->status}}>


        <div class="row">
            <div class="form-group col-md-6">
                <label for="user">{{ __('courseprogress.user') }}</label>
                <input id="user" type="text" class="form-control @error('user') is-invalid @enderror" readonly name="user" value="{{$user->fullname}}" tabindex="1">
                <div class="errormessage"> @error('user') {{ $message }} @enderror</div>
            </div>

            <div class="form-group col-md-6">
                <label for="course">{{ __('courseprogress.course') }}</label>
                <input id="course" type="text" class="form-control @error('course') is-invalid @enderror" readonly name="course" value="{{$course->course->title}}" tabindex="2">
                <div class="errormessage"> @error('course') {{ $message }} @enderror</div>
            </div>

            <div class="col-md-12">
                <h2>{{ __('courseprogress.course_status') }}</h2>
            </div>


            <div class="form-group col-md-6">
                <label>{{ __('courseprogress.current_status') }}</label>
                <select tabindex="3" name="curruent_status"  disabled class="form-control rounded">
                    @foreach (config('enrol_status') as $value => $label)
                    @if($value != 4)
                    <option value="{{$value}}"
                        {{ $course->status != "" && $course->status === $value ? 'selected' : '' }}>
                        {{ $label }}</option>
                    @endif
                    @endforeach
                </select>
                <div class="errormessage"> @error('enrol_status') {{ $message }} @enderror</div>
            </div>

            <div class="form-group col-md-6">
                <label>{{ __('courseprogress.status') }}</label>
                <select tabindex="4" name="status" id="status" @if($course->status == 3 || $course->status == 2 )  disabled  @endif data-validator="requied" class="form-control rounded">
                    <option>Select status</option>
                    @foreach (config('enrol_status') as $value => $label)
                    @if($value != 4)
                    <option value="{{$value}}"  @if($course->status == 3 || $course->status == 2 )  selected  @endif >
                        {{ $label }}</option>
                    @endif
                    @endforeach
                </select>
                <div class="errormessage"> @error('status') {{ $message }} @enderror</div>
            </div>

            <div class="form-group col-md-6">
                <label for="score">{{ __('courseprogress.score') }}</label>
                <input id="score" type="text" data-validator="numeric" class="form-control @error('score') is-invalid @enderror" name="score" value="{{$course->course->master_score}}" tabindex="5">
                <div class="errormessage"> @error('score') {{ $message }} @enderror</div>
            </div>
             

 
            <div class="form-group col-md-6">
                <label for="completed_date">{{ __('courseprogress.completed_date') }}</label>
                <input id="completed_date" type="text" class="form-control datepicker @error('completed_date') is-invalid @enderror" name="completed_date" value="{{ (!empty($course->completion_date))?\Carbon\Carbon::parse($course->completion_date)->format('n/j/Y'):'' }}" tabindex="6">
                <div class="errormessage"> @error('completed_date') {{ $message }} @enderror</div>
            </div>
                        
            
            <div class="form-group col-md-6">
                <label for="time_spent">{{ __('courseprogress.time_spent') }}<small>(minutes)</small></label>
                <input id="time_spent" type="text" data-validator="numeric" class="form-control @error('time_spent') is-invalid @enderror" name="time_spent" value="{{$course->timespent}}" tabindex="7">
                <div> <small id="hrs"></small> <small>Hours</small> <small>And</small> <small id="minutes"></small> <small>Minutes.</small></div>
                <div class="errormessage"> @error('time_spent') {{ $message }} @enderror</div>
            </div>

        </div>
</form>
@endsection