@extends('admin.layouts.app')
@section('content')
    @if ($errors->any())
        {!! implode('', $errors->all('<div style="display: none">:message</div>')) !!}
    @endif
    <form class="position-relative" method="post"
        action="{{ isset($user->id) ? route('user.update', $user->id) : route('user.store') }}" name="frmaddedit"
        id="frmaddedit">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6">
                <h1 class="page-title">
                    {{ isset($user->id) ? __(Request::segment(2) . '.editpagetitle') : __(Request::segment(2) . '.addpagetitle') }}
                </h1>
            </div>
            <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        @if (Auth::user()->id != $user->id )
                        @if (isset($user->id) && $user->user_type_id == 1)
                            <a href="javascript:void(0)"
                                class="btn btn-dark btn-sm delete-btn mr-1 d-flex align-items-center gap-1"
                                onclick="confirmDelete();" id="delete-btn" title="{{ __('common.delete') }}">
                                <em class="icon-close-icon top-icon"></em>
                                <span class="ml-1">{{ __('common.delete') }}</span>
                            </a>
                        @endif
                        @endif
                        <a tabindex="500" id="btncancel"
                            href=" @if (Request::segment(2) == 'user') {{ route('user.index') }} @else   {{ route(Request::segment(2) . '.list') }} @endif "
                            class="btn btn-dark mr-1 btn-sm"><em class="icon-close-icon top-icon"></em>
                            <span>{{ __('common.cancel') }}</span></a>
                        <button tabindex="900" type="submit" class="btn btn-primary mr-1 btn-sm" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.save') }}</span></button>
                        <button tabindex="900" type="submit" class="btn btn-primary btn-sm" id="btnsave" name="btnsave"
                            value='savecontinue'><em class="icon-save_icon top-icon"></em>
                            <span>{{ __('common.savecontinue') }}</span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12 datepicker-custom pb-5">
            @csrf
            @if (isset($user->id))
                @method('PUT')
                <input type="hidden" name="id[]" value="{{ $user->id }}">
            @endif
            <div class="row">

                <div class="form-group col-md-6">
                    <label for="first_name">{{ __('user.first_name') }}<span class="text-danger">*</span></label>
                    <input id="first_name" type="text" tabindex="4"
                        class="form-control firstele @error('first_name') is-invalid @enderror" name="first_name"
                        value="{{ old('first_name', $user->first_name) }}" data-validator="required" maxlength="30">
                    <div class="errormessage">
                        @error('first_name')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label for="last_name">{{ __('user.last_name') }}<span class="text-danger">*</span></label>
                    <input id="last_name" type="text"
                        class="form-control firstele @error('last_name') is-invalid @enderror" name="last_name"
                        value="{{ old('last_name', $user->last_name) }}" data-validator="required" tabindex="5" maxlength="30">
                    <div class="errormessage"> @error('last_name')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label for="email">{{ __('user.email') }}<span class="text-danger">*</span></label>
                    <input id="email" type="text" class="form-control firstele @error('email') is-invalid @enderror"
                        name="email" value="{{ old('email', $user->email) }}" data-validator="required|email"
                        tabindex="6" @if (isset($user->id)) readonly @endif maxlength="50">
                    <div class="errormessage">
                        @error('email')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                @if (isset($user->id) && $user->email_verified_at != null && Request::segment(2) == 'student')
                    <div class="form-group col-md-6">
                        <label for="status">{{ __('user.status') }}</label>
                        <select class="form-control" id="status" name="status" tabindex="13"
                            {{ Auth::user()->id == $user->id ? 'disabled' : '' }}>
                            @foreach (config('status') as $value => $label)
                                <option value="{{ $value }}" @if (old('status', $user->status) == $value) selected @endif>
                                    {{ $label }}</option>
                            @endforeach
                        </select>

                        <div class="errormessage"> @error('status')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                @endif

                @if (Request::segment(2) == 'student')
                    <input id="user_type_id" type="hidden" name="user_type_id"
                        value="{{ old('user_type_id', $user->user_type_id) ?: 3 }}">
                @elseif(Request::segment(2) == 'user')
                    <input id="user_type_id" type="hidden" name="user_type_id"
                        value="{{ old('user_type_id', $user->user_type_id) ?: 1 }}">
                @else
                    <input id="user_type_id" type="hidden" name="user_type_id"
                        value="{{ old('user_type_id', $user->user_type_id) ?: 2 }}">
                @endif
                @if (isset($user->id) && $user->email_verified_at !== null)
                    <div class="form-group col-md-6 d-none">
                        <label for="password">{{ __('user.password') }}</label>
                        <input id="password" type="password" tabindex="4"
                            class="form-control firstele @error('password') is-invalid @enderror" name="password">
                        <div class="errormessage">
                            @error('password')
                                {{ $message }}
                            @enderror
                        </div>
                        <small class="form-text text-muted line1">
                            {!! __('user.password_rule_' . strtolower(siteconfig('password_strength')) . '_msg', [
                                'min' => siteconfig('minimum_password_length'),
                            ]) !!}
                        </small>
                    </div>

                    <div class="form-group col-md-6 d-none">
                        <label for="confirm_password">{{ __('user.confirm_password') }}</label>
                        <input id="confirm_password" type="password" tabindex="4"
                            class="form-control firstele @error('confirm_password') is-invalid @enderror"
                            name="confirm_password"
                            @if (isset($user->id)) @else data-validator="required|same:password" @endif>
                        <div class="errormessage">
                            @error('confirm_password')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                @endif


                @if (Request::segment(2) == 'user' || Request::segment(2) == 'firmuser')
                @else
                    <div class="form-group col-md-12">
                        @php
                            $image = '';
                            if (old('profile_image') != '') {
                                $image = getImageUrl(old('profile_image'), 'profile_image');
                            } elseif (isset($user->id) && !empty($user->id) && $user->profile_image != '') {
                                $image = getImageUrl($user->profile_image_org, 'profile_image');
                            }
                        @endphp
                        <label for="temp_profile_image">{{ __('user.profile_image') }}</label>
                        <input type="file" id="temp_profile_image"
                            data-size="{{ getImageUploadSizeInMB('profile_image') }}" class="dropify image-upload"
                            name="temp_profile_image" data-folder="profile_image"
                            {{ $image != '' ? 'data-default-file=' . $image : '' }} tabindex="7">
                        <div><small class="form-text">{{ getImageRecommendedSize('profile_image') }}</small></div>
                        <input name="profile_image" type="hidden" value="{{ $user->profile_image_org }}">
                        <div id="error_profile_image"
                            class="errormessage  @error('profile_image') @else{{ 'd-none' }} @enderror">
                            @error('profile_image')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="firmcode">{{ __('user.firmcode') }}</label>
                        <input id="firmcode" type="text"
                            class="form-control firstele @error('firmcode') is-invalid @enderror" name="firmcode"
                            @if (Auth::user()->user_type_id == 2) readonly value="{{ $loginfirmcode }}" @else value="{{ old('firmcode', $user->firmcode) }}" @endif
                            tabindex="12">
                        <div class="errormessage">
                            @error('firmcode')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                @endif
                <div class="form-group col-md-6">
                    <label for="phone">{{ __('user.phone') }}@if (Request::segment(2) != 'student')
                            <span class="text-danger">*</span>
                        @endif
                    </label>
                    <input id="phone" type="text" class="form-control @error('phone') is-invalid @enderror" @if (Request::segment(2) != 'student')data-validator="required" @endif
                        name="phone" value="{{ old('phone', $user->phone) }}" data-mask='000-000-0000'
                        placeholder="___-___-____" tabindex="11" data-validator-label="phone number">
                    <div class="errormessage">
                        @error('phone')
                            {{ $message }}
                        @enderror
                    </div>
                </div>

                @if (isset($user->id) && $user->email_verified_at != null && Request::segment(2) != 'student')
                    <div class="form-group col-md-6">
                        <label for="status">{{ __('user.status') }}</label>
                        <select class="form-control" id="status" name="status" tabindex="13"
                            {{ Auth::user()->id == $user->id ? 'disabled' : '' }}>
                            @foreach (config('status') as $value => $label)
                                <option value="{{ $value }}" @if (old('status', $user->status) == $value) selected @endif>
                                    {{ $label }}</option>
                            @endforeach
                        </select>

                        <div class="errormessage"> @error('status')
                                {{ $message }}
                            @enderror
                        </div>

                    </div>
                @endif

            </div>
        </div>
    </form>

    <!-- Delete Form -->
    <form id="delete-form" action="{{ isset($user->id) ? route('user.destroy', $user->id) : '' }}" method="POST"
        style="display: none;">
        @csrf
        @method('DELETE')
    </form>

    <div class="modal fade" id="confirm-action-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true"><img src="{{ asset('assets/front/images/close-model.svg') }}"
                    alt="close button"></span>
        </button>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h2><strong>Confirm Delete</strong></h2>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this user?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-sm btn-dark" data-dismiss="modal">Cancel</button>
                    <a href="#" id="confirm-action-submit" class="btn btn-sm btn-primary">Confirm</a>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function confirmDelete() {
            $("#confirm-action-modal").modal("show");
        }

        $(document).ready(function() {
            $("#confirm-action-submit").click(function(e) {
                e.preventDefault();
                var form = $("#delete-form");

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: form.serialize(),
                    success: function(response) {
                        $("#confirm-action-modal").modal("hide");
                        if (response.success) {
                            window.location.href = "{{ route('user.index') }}";
                        }
                    },
                    error: function(xhr) {
                        $("#confirm-action-modal").modal("hide");
                        window.location.href = "{{ route('user.index') }}";
                    }
                });
            });
        });
    </script>
@endsection
