@extends('admin.layouts.app')
@section('content')
<div class="row mx-0 mb-3">
    <div class="col-6">
        <h1 class="page-title"><?php echo __(Request::segment(2).'.pagetitle'); ?></h1>
    </div>
    <div class="top-btn-box col-6" id="normal_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
            <a tabindex="1" href="javascript:void(0)" class="btn btn-primary mr-1 search-btn btn-sm show hide"
                id="search-btn">
                <em class="icon-search-icon top-icon"></em>
                <span class="btn-title">{{ __('common.search') }}</span>
            </a>
            @if(canUserAccess('manage-user') || canUserAccess('manage-student') )
            <a tabindex="2" href="{{ (Request::segment(2) == 'student')?route('student.create'):route('user.create')}}" class="btn btn-primary addnew-btn btn-sm" id="add-btn">
                <em class="icon-addnew top-icon"></em>
                <span class="btn-title">{{ __('common.add') }}</span>
            </a>
            @endif
        </div>
    </div>

    <div class="top-btn-box hide col-6" id="action_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm active-btn"
                onclick="submitactionform('active');" id="active-btn" title="{{ __('common.active') }}">
                <em class="icon-radiobutton_checked top-icon"></em>
                <span class="btn-title">{{ __('common.active') }}</span>
            </a>
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm inactive-btn"
                onclick="submitactionform('inactive');" id="inactive-btn" title="{{ __('common.inactive') }}">
                <em class="icon-radio_button_unchecked top-icon"></em>
                <span class="btn-title">{{ __('common.inactive') }}</span>
            </a>
            {{-- <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');" id="delete-btn" title="{{ __('common.delete') }}">
                <em class="icon-close-icon top-icon"></em>
                <span class="btn-title">{{ __('common.delete') }}</span>
            </a> --}}
        </div>

    </div>
</div>

<div class="col-12 admin-holder">
    <div class="row">
        <div class="{{ Request::has('status') && Request::has('search') ? 'show' : 'hide' }}" id="searchbox">
            <form name="frmsearch" id="frmsearch" action="{{ $users->appends(prepareInputRequestArray())->url(1) }}"
                method="GET" class="col-12">
                @foreach (Request::all() as $key=>$value)
                @if (in_array($key,['search','status','btnsearch']))
                @continue
                @else
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endif
                @endforeach
                <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label>{{ __('user.name') }} / {{ __('user.email') }}</label>
                        <input tabindex="3" name="search" id="search"
                            placeholder="{{ __('common.search') ." ". __('user.pagetitle') }}" type="text"
                            class="form-control rounded" value="{{ Request::get('search') }}">
                    </div>
                    <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                        <label>{{ __('user.status') }}</label>
                        <select tabindex="4" name="status" id="status" class="form-control rounded">
                            <option value="">{{ __('common.select_status') }}</option>
                            @foreach (config('status') as $value => $label)
                            <option value="{{$value}}"
                                {{ Request::get('status') != "" && intval(Request::get('status')) === $value ? 'selected' : '' }}>
                                {{ $label }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-12">
                        <button tabindex="6" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                            name="btnsearch">{{ __('common.search') }}</button>
                        <a href="{{ $reset_link }}"
                            class="btn btn-primary reset-btn" id="search_reset">{{ __('common.reset') }}</a>
                        <button tabindex="7" type="button" class="btn btn-dark close-btn"
                            id="search-btn-h">{{ __('common.close') }}</button>
                        <hr>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-12 photos-main">
            <section id="wrapper">
                <form name="frmlist" id="frmlist" action="{{ route('user.bulkaction') }}" method="POST">
                    @csrf
                    <input type="hidden" name="bulk-action" value="">
                    <div class="table-responsive">
                    <table data-orders="4" data-target="@if(canUserAccess('manage-user')||canUserAccess('manage-student')) 3 @else 1 @endif" class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                        <thead>
                            <tr>
                                <th class="hide" scope="col">
                                    <!-- this blank column is for primary column -->

                                </th>
                                @if(canUserAccess('manage-user')||canUserAccess('manage-student'))
                                <th class="active-box status-column" scope="col">
                                    <em class="sort"></em>
                                </th>
                                <th class="check-box nosort" scope="col">
                                    <div class="custom-control custom-checkbox text-center">
                                        <input type="checkbox" class="custom-control-input" name="selectAll"
                                            id="selectAll" onclick="checkAll();">
                                        <label class="custom-control-label" for="selectAll"></label>
                                    </div>
                                </th>
                                @endif
                                <th scope="col" class="control nosort">
                                    <!-- this blank column is responsive controll -->

                                </th>
                                <th scope="col">
                                    <div>
                                        <span>
                                            {{ __('user.name') }}
                                        </span>
                                    </div>
                                </th>
                                <th scope="col">
                                    <div>
                                        <span>
                                            {{ __('user.email') }}
                                        </span>
                                    </div>
                                </th>

                                <th scope="col">
                                    <div>
                                        <span>
                                            {{ __('user.last_login_at') }}
                                        </span>
                                    </div>
                                </th>
                                <th scope="col">
                                    <div>
                                        <span>
                                            {{ __('user.created_at') }}
                                        </span>
                                    </div>
                                </th>
                                <th class="nosort" scope="col">{{__('user.reset_password')}}</th>
                                @if(canUserAccess('manage-user')||canUserAccess('manage-student'))
                                <th class="text-left nosort" scope="col">Action</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $user)
                            <tr>
                                <td class="active-box hide">
                                    <em style="display:none">{{ $user->fullname }}</em>
                                </td>
                                @if(canUserAccess('manage-user')||canUserAccess('manage-student'))
                                <td class="active-box">
                                    <em style="display:none">{{$user->status==2?0:$user->status}}</em>
                                    @if (Auth::user()->id != $user->id )
                                    <a href="{{ route('user.changestatus', ['id' => $user->id]) }} ">
                                        @endif

                                        <span class="sort {{ $user->status == 1 ? 'active' : 'inactive' }} "></span>
                                        @if (Auth::user()->id != $user->id)
                                    </a>
                                    @endif
                                </td>
                                <td class="check-box">
                                    <div class="custom-control custom-checkbox text-center">
                                        @if (Auth::user()->id != $user->id )

                                        <input type="checkbox" class="custom-control-input action-checkbox"
                                            id="filled-in-box_{{ $user->id }}" name="id[]" value="{{$user->id}}">
                                        <label class="custom-control-label" for="filled-in-box_{{ $user->id }}"></label>


                                        @endif
                                    </div>
                                    @endif
                                </td>
                                <td>

                                </td>
                                <td>{{ $user->first_name }} {{ $user->last_name }}</td>

                                <td>
                                    <div class="email-add"><a href="mailto:{{ $user->email }}">{{ $user->email }}</a>
                                    </div>
                                </td>
                                <td
                                    data-sort=" @if(!empty($user->last_login_at)) {{ \Carbon\Carbon::parse( $user->last_login_at)->format('Y/m/d H:i:s')}}  @endif">
                                    @if(!empty($user->last_login_at))
                                    {{ \Carbon\Carbon::createFromFormat('Y-m-d H:i:s',  $user->last_login_at)->format(config('app.datetime_format')) }}
                                    @else

                                    @endif
                                </td>
                                <td data-sort="{{ \Carbon\Carbon::parse( $user->created_at)->format('Y/m/d H:i:s') }}">
                                    {{ $user->created_at }}</td>
                                <td>
                                    @if($user->email_verified_at == NULL)
                                    <a
                                        href="{{ route('user.reset-password', [$user->email,$user->user_type_id]) }}">{{ __('user.account_activation') }}</a>
                                    @elseif($user->status == 1)
                                    <a
                                        href="{{ route('user.reset-password', [$user->email,$user->user_type_id]) }}">{{ __('user.reset_password') }}</a>
                                    @else
                                    -
                                    @endif
                                </td>
                                @if(canUserAccess('manage-user')||canUserAccess('manage-student'))
                                <td class="text-center">

<a href="@if(Request::segment(2) == 'student') {{ route('student.edit', $user->id) }} @else {{ route('user.edit', $user->id) }} @endif"><em
                                            class="icon-edit-icon left"></em></a>
                                </td>
                                @endif
                            </tr>
                            @endforeach
                            @if ($users->total() == 0)
                            <tr class="noreocrd">
                                <td colspan="10" class="text-center">
                                    {{ __(Request::segment(2).'.no_result') }}
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                    </div>
                </form>
            </section>
        </div>
    </div>
</div>
@endsection
