@extends('admin.layouts.app')
@section('content')
    <div class="row mx-0 mb-3">
        <div class="col-6">
        <h1 class="page-title"><?php echo __(Request::segment(2).'.pagetitle'); ?></h1>
        </div>
        <div class="top-btn-box col-6" id="normal_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
                <div class="form-group mb-0 mr-3">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" id="show_only_current_members" name="show_only_current_members" 
                            {{ siteconfig('show_only_current_members_app_user') == 1 ? 'checked' : '' }}>
                        <label class="custom-control-label" for="show_only_current_members">{{ __('user.show_current_members') }}</label>
                    </div>
                </div>
                <a tabindex="1" href="javascript:void(0)" class="btn btn-primary mr-1 search-btn btn-sm show hide"
                    id="search-btn">
                    <em class="icon-search-icon top-icon"></em>
                    <span class="btn-title">{{ __('common.search') }}</span>
                </a>
            @if(canUserAccess('manage-student'))
            <a tabindex="2" href="{{ route('student.create') }}" class="btn btn-primary addnew-btn btn-sm" id="add-btn">
                        <em class="icon-addnew top-icon"></em>
                        <span class="btn-title">{{ __('common.add') }}</span>
                    </a>
                @endif
            </div>
        </div>

        <div class="top-btn-box hide col-6" id="action_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
                <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm active-btn"
                    onclick="submitactionform('active');" id="active-btn" title="{{ __('common.active') }}">
                    <em class="icon-radiobutton_checked top-icon"></em>
                    <span class="btn-title">{{ __('common.active') }}</span>
                </a>
                <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm inactive-btn"
                    onclick="submitactionform('inactive');" id="inactive-btn" title="{{ __('common.inactive') }}">
                    <em class="icon-radio_button_unchecked top-icon"></em>
                    <span class="btn-title">{{ __('common.inactive') }}</span>
                </a>
                {{-- <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');" id="delete-btn" title="{{ __('common.delete') }}">
                <em class="icon-close-icon top-icon"></em>
                <span class="btn-title">{{ __('common.delete') }}</span>
            </a> --}}
            </div>

        </div>
    </div>

    <div class="col-12 admin-holder">
        <div class="row">
        <div class="{{ (Request::has('status') && Request::has('search')) || (Request::has('bar_id') && Request::has('bar_id'))  ? 'show' : 'hide' }}" id="searchbox">
                <form name="frmsearch" id="frmsearch" action="{{ $users->appends(prepareInputRequestArray())->url(1) }}"
                    method="GET" class="col-12">
                @foreach (Request::all() as $key=>$value)
                @if (in_array($key,['search','status','btnsearch','bar_id']))
                            @continue
                        @else
                            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                        @endif
                    @endforeach
                    <div class="row">
                        <div class="form-group col-md-6 col-12">
                            <label>{{ __('user.name') }} / {{ __('user.email') }}</label>
                            <input tabindex="3" name="search" id="search"
                            placeholder="{{ __('common.search') ." ". __('student.pagetitle') }}" type="text"
                                class="form-control rounded" value="{{ Request::get('search') }}">
                        </div>
                        <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                            <label>{{ __('user.status') }}</label>
                            <select tabindex="4" name="status" id="status" class="form-control rounded">
                                <option value="">{{ __('common.select_status') }}</option>
                                @foreach (config('status') as $value => $label)
                            <option value="{{$value}}"
                                {{ Request::get('status') != "" && intval(Request::get('status')) === $value ? 'selected' : '' }}>
                                        {{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                            <label>{{ __('user.bar_id') }}</label>
                            <select tabindex="4" name="bar_id" id="bar_id" class="form-control rounded">
                                <option value="">{{ __('user.select_bar') }}</option>
                                @foreach ($activebars as $value => $label)
                            <option value="{{$value}}"
                                {{ Request::get('bar_id') != "" && intval(Request::get('bar_id')) === $value ? 'selected' : '' }}>
                                        {{ $label }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-12">
                            <button tabindex="6" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                                name="btnsearch">{{ __('common.search') }}</button>
                        <a href="{{ $reset_link }}"
                            class="btn btn-primary reset-btn" id="search_reset">{{ __('common.reset') }}</a>
                            <button tabindex="7" type="button" class="btn btn-dark close-btn"
                                id="search-btn-h">{{ __('common.close') }}</button>
                            <hr>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-12 photos-main">
            <section id="wrapper">
                <form name="frmlist" id="frmlist" action="{{ route('user.bulkaction') }}" method="POST">
                    @csrf
                    <input type="hidden" name="bulk-action" value="">
                    <div class="table-responsive">
                    <table data-orders="4" data-target="@if(canUserAccess('manage-student')) 3 @else 1 @endif" class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                            <thead>
                                <tr>
                                    <th class="hide" scope="col">
                                        <!-- this blank column is for primary column -->

                                    </th>
                                @if(canUserAccess('manage-student'))
                                        <th class="active-box status-column" scope="col">
                                            <em class="sort"></em>
                                        </th>
                                        <th class="check-box nosort" scope="col">
                                            <div class="custom-control custom-checkbox text-center">
                                                <input type="checkbox" class="custom-control-input" name="selectAll"
                                                    id="selectAll" onclick="checkAll();">
                                                <label class="custom-control-label" for="selectAll"></label>
                                            </div>
                                        </th>
                                    @endif
                                    <th scope="col" class="control nosort">
                                        <!-- this blank column is responsive controll -->

                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('user.firm_user') }}
                                            </span>
                                        </div>
                                    </th>
                                    {{-- <th scope="col">
                                    <div>
                                        <span>
                                            {{ __('user.firm_approval_status') }}
                                        </span>
                                    </div>
                                </th> --}}
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('user.firm') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('user.subscription_status') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('user.promocode') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('user.enrolled_bars') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('user.last_login_at') }}
                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                {{ __('user.created_at') }}
                                            </span>
                                        </div>
                                    </th>
                                @if(canUserAccess('manage-student'))
                                <th class="nosort" scope="col">{{__('user.reset_password')}}</th>
                                    @endif
                                @if(Auth::user()->user_type_id == 2)
                                <th class="nosort" scope="col">{{__('user.firm_approved_status')}}</th>
                                    @endif
                                @if(canUserAccess('manage-student')||canUserAccess('manage-student'))
                                        <th class="text-left nosort" scope="col">Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $user)
                                    <tr>
                                        <td class="active-box hide">
                                            <em style="display:none">{{ $user->fullname }}</em>
                                        </td>
                                @if(canUserAccess('manage-student'))
                                            <td class="active-box">
                                    <em style="display:none">{{$user->status==2?0:$user->status}}</em>
                                    @if (Auth::user()->id != $user->id )
                                                    <a href="{{ route('user.changestatus', ['id' => $user->id]) }} ">
                                                @endif

                                        <span class="sort {{ $user->status == 1 ? 'active' : 'inactive' }} "></span>
                                                @if (Auth::user()->id != $user->id)
                                                    </a>
                                                @endif
                                            </td>
                                            <td class="check-box">
                                                <div class="custom-control custom-checkbox text-center">
                                        @if (Auth::user()->id != $user->id )

                                        <input type="checkbox" class="custom-control-input action-checkbox"
                                            id="filled-in-box_{{ $user->id }}" name="id[]" value="{{$user->id}}">
                                        <label class="custom-control-label" for="filled-in-box_{{ $user->id }}"></label>


                                                    @endif
                                                </div>
                                        @endif
                                        </td>
                                        <td>

                                        </td>
                                <td>{{ $user->fullname }} <br/>
                                            <a href="mailto:{{ $user->email }}">{{ $user->email }}</a>
                                        </td>

                                        {{-- <td>
                                    @if(getFirmApprovalStatusName($user->firm_approved_status) != false)
                                        {{getFirmApprovalStatusName($user->firm_approved_status)}}
                                    @else
                                        N/A
                                    @endif
                                </td> --}}
                                        <td>
                                            {!! userFirm($user->id) !!}
                                        </td>
                                        <td>
                                            {{-- @if ($user->firm_approved_status != null) --}}
                                        @if(checkActiveUserSubscription($user->id) != false)
                                                <span class="badge bg-success text-light">Active</span>
                                            @else
                                                <span class="badge bg-danger text-light">Inactive</span>
                                            @endif
                                            {{-- @else
                                        -
                                    @endif --}}
                                        </td>
                                        <td>
                                            @if (!empty($user->subscriptions))
                                                @foreach ($user->subscriptions as $subscription)
                                                    {{ $subscription->promocode }}
                                                @endforeach
                                            @endif
                                        </td>
                                        <td>{{ getUserBarsCustom($user->id) }}</td>
                                        <td
                                    data-sort=" @if(!empty($user->last_login_at)) {{ \Carbon\Carbon::parse( $user->last_login_at)->format('Y/m/d H:i:s')}}  @endif">
                                    @if(!empty($user->last_login_at))
                                    {{ \Carbon\Carbon::createFromFormat('Y-m-d H:i:s',  $user->last_login_at)->format(config('app.datetime_format')) }}
                                            @else

                                            @endif
                                        </td>
                                <td data-sort="{{ \Carbon\Carbon::parse( $user->created_at)->format('Y/m/d H:i:s') }}">
                                            {{ $user->created_at }}</td>

                                @if(canUserAccess('manage-student'))
                                            <td>
                                    @if($user->email_verified_at == NULL)
                                                    <a
                                        href="{{ route('user.reset-password', [$user->email,$user->user_type_id]) }}">{{ __('user.account_activation') }}</a>
                                                @elseif($user->status == 1)
                                                    <a
                                        href="{{ route('user.reset-password', [$user->email,$user->user_type_id]) }}">{{ __('user.reset_password') }}</a>
                                                @else
                                                    -
                                                @endif
                                            </td>
                                        @endif
                                @if(Auth::user()->user_type_id == 2)
                                            <td>
                                                @if ($user->firm_approved_status == null)
                                                    @if (checkUserBarsNeedTopay($user->id))
                                            <select class="form-control firm_status" data-id="{{ $user->id }}" >
                                                <option value="" disabled selected>{{ __('user.select_firm_status') }}</option>
                                                            @forelse ($firmApprovedStatuses as $status)
                                                    @if (checkFirmUserSubscriptionOptions($user->appUserFirm->user_subscription,$status->id) == true)
                                                        <option value="{{ $status->id }}" {{ isset($user->firm_approved_status) ? ($user->firm_approved_status == $status->id ? 'selected' : '') : '' }} {{ $user->firm_approved_status == 3 || $user->firm_approved_status == 1 ? 'disabled' : '' }} >{{ $status->name }}</option>
                                                                @endif
                                                            @empty
                                                                <option value="">No data available</option>
                                                            @endforelse
                                                        </select>
                                                    @else
                                                        <span class="badge bg-warning">No bars selected yet</span>
                                                    @endif
                                                @else
                                        <span class="badge bg-warning">{{getFirmApprovalStatusName($user->firm_approved_status)}}</span>
                                                @endif


                                            </td>
                                        @endif
                                        <td class="px-2 text-left">

                                @if(canUserAccess('manage-student'))
                                <a class="mr-2" href="@if(Request::segment(2) == 'student') {{ route('student.edit', $user->id) }}
                                    @else {{ route('user.edit', $user->id) }} @endif"><em class="icon-edit-icon left"></em></a>
                                            @endif

                                @if( canUserAccess('manage-student'))
                                <a href="@if(Request::segment(2) == 'student') {{ route('student.progress', $user->id) }}
                                     @endif"><em class="icon-open-icon left"></em></a>
                                        </td>
                                @endif
                                </tr>
                                @endforeach
                                @if ($users->total() == 0)
                                    <tr class="noreocrd">
                                        <td colspan="10" class="text-center">
                                    {{ __(Request::segment(2).'.no_result') }}
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                     </div>
                </form>
            </section>
        </div>
    </div>
    <!-- Confirmation Modal -->
<div class="modal fade" id="confirmationModal" tabindex="-1" role="dialog" aria-labelledby="confirmationModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmationModalLabel">Are you sure?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Proceed for payment now.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="confirmProceedButton">Yes, Proceed!</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('extra-js-2')
    <script>
        $(document).ready(function() {
            $(document).on('change', '.firm_status', function() {
                var statusId = $(this).val();
                userId = $(this).attr('data-id');
                console.log('user id -' + userId);
                var newUrl = "{{ route('student.firmApprovedStatus') }}";

                if (statusId == 1) {
                    // Show the Bootstrap confirmation modal
                    $('#confirmationModal').modal('show');
                } else {
                    $.ajax({
                        url: newUrl,
                        method: 'GET',
                    data: { status_id: statusId, user_id: userId },
                        dataType: 'json',
                        success: function(response) {
                            setTimeout(function() {
                                location.reload();
                            }, 1000);
                        },
                        error: function(xhr, status, error) {
                            console.error(xhr.responseText);
                        }
                    });
                }
            });

            $('#confirmProceedButton').on('click', function() {
                window.location.href = "{{ route('checkout', ':id') }}".replace(':id', userId);
            });
        });
    </script>
@endsection
