@extends('admin.layouts.app')
@section('content')
    <div class="container-fluid dashboard-cms  pb-5">
        <div class="row">
            <div class="col-md-12">
                <h4>View {{ $student->fullname }}'s Details</h4>
            </div>
        </div>
        <div class="row">
            <div class="form-group col-12">{{ $student->first_name }} {{ $student->last_name }}</div>

            <div class="form-group col-12">
                <div class="email-add"><a href="mailto:{{ $student->email }}">{{ $student->email }}</a>
                </div>
            </div>
            <div class="form-group col-12">
                <div>{{ formatPhoneNumber($student->phone) }}</div>
            </div>
            <div class="form-group col-12">{{ $student->firmcode }}</div>
            <div class="form-group col-12">{{ $student->subscription_status }}</div>
            <div class="form-group col-12">
                @if (!empty($student->last_login_at))
                    {{ \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $student->last_login_at)->format(config('app.datetime_format')) }}
                @else
                @endif
            </div>
            <div class="form-group col-12">
                {{ $student->created_at }}</div>

            @if (canUserAccess('manage-user'))
                <div class="form-group col-12">
                    @if ($student->email_verified_at == null)
                        <a
                            href="{{ route('user.reset-password', [$student->email, $student->user_type_id]) }}">{{ __('user.account_activation') }}</a>
                    @elseif($student->status == 1)
                        <a
                            href="{{ route('user.reset-password', [$student->email, $student->user_type_id]) }}">{{ __('user.reset_password') }}</a>
                    @else
                        -
                    @endif
                </div>
            @endif
        </div>
    </div>
@endsection
