@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
@endif
@endif
<p> Dear {{ $user->first_name }} {{ $user->last_name }},</p>
<p>
    We are writing to confirm that your account on {{ siteconfig('company_name') }} has been successfully deleted.
</p>
<p>
    As requested, all your personal data, including your submitted podcasts, podcast history, and subscription details, have been permanently removed from our system. This action is irreversible, and your account can no longer be reactivated.
</p>
<p>
    We are sorry to see you go and hope to have the opportunity to serve you again in the future.
</p>
<p>
    If you have any questions or need further assistance, please do not hesitate to contact our support team at {{ getSupportEmail() }}.
</p>
<p>
    Thank you for being a part of our community.
</p>
<p>
    Best regards,<br>
    The {{ siteconfig('company_name') }} Team
</p>
@if (! empty($salutation))
<p>{{ $salutation }}</p>
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
