@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
@if (!empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
    # @lang('Whoops!')
@else
@endif
@endif
<p> Dear {{ $user->first_name }} {{ $user->last_name }},</p>
<p>
Your {{ $user->userType->title }} account for <a href="{{ $domain }}">{{ $domain }}</a> has been successfully created. We're excited to welcome you aboard!
</p>
<p>
To start using your account, please verify your email address by clicking the button below:
</p>
<p>
<a href="{{ $veryfy_link }}" class="button button-primary" target="_blank" rel="noopener">@lang('Verify Email Address')</a>
</p>
<p>
Verifying your email will grant you access to a suite of administrative tools and features designed to enhance your experience with {{ siteconfig('company_name') }}.
</p>
<p>
Should you encounter any difficulties during the verification process, please reach out to our support team at {{ getSupportEmail() }}. We're here to help.
</p>
<p>
Best regards,<br>
The {{ siteconfig('company_name') }} Team
</p>
@if (!empty($salutation))
<p>{{ $salutation }}</p>
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
    {{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
