@component('mail::layout')
{{-- Header- --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
@endif
@endif
{{-- <p> Hello Team,</p> --}}
<p>
    A new faculty member has expressed interest in joining Clearly Legal.
</p>

<p> <b>First Name:</b> {{ $userData->first_name }} </p>
<p> <b>Last Name:</b> {{ $userData->last_name }} </p>
<p> <b>Email:</b> {{ $userData->email }} </p>
<p> <b>Phone:</b> {{ formatPhoneNumber($userData->phone_number) }}  </p>
<p> <b>Bio Link:</b> {{$userData->bio_link}} </p>
<p> <b>Firm Name:</b> {{$userData->firm_name}} </p>
<p> <b>Practising Categories:</b> {{$userData->categories->pluck('name')->implode(', ')}} </p>



Thank you,
<br>
@if (! empty($salutation))
{{ $salutation }}
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent