@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
<p> Hello {{ $user->first_name }} {{ $user->last_name }},</p>
@endif
@endif
<p>You are receiving this email because we received a password reset request for your account.</p>
<div style="text-align:center"><a href="{{ $reset_link }}" class="button button-primary" target="_blank" rel="noopener" >Reset Password</a></div>
<p>This password reset link will expire in {{ floor(config('auth.passwords.users.expire')/ 60) }} hours.</p>
<p>If you did not request a password reset, no further action is required.</p>

Thank you,
<br>
@if (! empty($salutation))
{{ $salutation }}
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
