@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
# Dear Admin,
@endif
@endif
<p>The following user account has been activated. </p>
<table style="width: 100%; border-collapse: collapse;">
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Name</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;">{{ $user->first_name . ' ' . $user->last_name }}</td>
    </tr>
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Email</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;">{{ $user->email }}</td>
    </tr>
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Phone</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;">{{ $user->phone }}</td>
    </tr>
    @if (userFirmAdmin($user->id))
        <tr>
            <td style="padding: 8px; border: 1px solid #ddd;"><strong>Firm Code</strong></td>
            <td style="padding: 8px; border: 1px solid #ddd;">{{ userFirmAdmin($user->id)->name }}</td>
        </tr>
    @endif
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Subscription Start Date</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;">{{ date('Y-m-d H:i:s', $subscription->current_period_start) }}</td>
    </tr>
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Subscription End Date</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;">{{ date('Y-m-d H:i:s', $subscription->current_period_end) }}</td>
    </tr>
</table>

<table style="width: 100%; border-collapse: collapse; margin-top: 20px;">
    <thead>
        <tr>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left;">Description</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: center;">Qty</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: right;">Unit Price</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: right;">Amount</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($subscription->items->data as $item)
            <tr>
                <td style="border: 1px solid #ddd; padding: 8px;">
                    {{ $item->price->metadata->productName }}
                </td>
                <td style="border: 1px solid #ddd; padding: 8px; text-align: center;">{{ $item->quantity }}</td>
                <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">${{ number_format($item->price->unit_amount / 100, 2) }}</td>
                <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">${{ number_format(($item->price->unit_amount * $item->quantity)/100, 2) }}</td>
            </tr>
        @endforeach
        <tr>
            <td colspan="3" style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                <strong>Subtotal</strong>
            </td>
            <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                ${{ number_format($subtotal / 100, 2) }}
            </td>
        </tr>
        @if (!empty($subscription->discount->coupon))
        <tr>
            <td colspan="3" style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                <strong>PROMOCODE : {{ $subscription->discount->coupon->name }} (@if($is_discount_percentage){{ $subscription->discount->coupon->percent_off }}% off @else${{ number_format($discount / 100, 2) }} off @endif)</strong>
            </td>
            <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                -${{ number_format($discount / 100, 2) }}
            </td>
        </tr>
        @endif
        <tr>
            <td colspan="3" style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                <strong>Total</strong>
            </td>
            <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                <strong>${{ number_format(($total/100), 2) }}</strong>
            </td>
        </tr>
    </tbody>
</table>

<br/>
<p>Please note: This is an automated email that cannot accept replies.</p>

Thank you,
<br>
@if (! empty($salutation))
{{ $salutation }}
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
