@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot

<p>Dear <strong>{{ $name }}</strong>,</p>

<p>I am writing to share a new software tool I helped develop and to follow up on my Facebook post regarding beta testing. First, thank you very much for your willingness to help. It won’t take much of your time, and you may be entitled to CLE credit for doing so.</p>

<p>We’ve built a CLE-by-podcast tool. You listen, you click “done,” and we take care of everything else, including posting your hours. The podcasts are 15 minutes long, and each one that is approved will earn you 0.25 hours of credit.</p>

<p>If you are still willing to help, please follow the instructions below. Keep in mind, this software is in its early stages, and the content is less polished than what you may be used to. Nevertheless, I hope you find them entertaining and educational.</p>

<p>We are seeking honest feedback. Tell us what you like about the app, the content, everything. Tell us what you don’t like as well. You won’t hurt my feelings; I want to make this perfect so we can all have a better CLE experience.</p>

<p>PS: Once we finalize this, each of you will be entitled to a full year of courses (15 hours) for 50% off. My way of saying thank you very much.</p>

<p>Also, if you’d like to be a speaker, please let me know, and I will get you on the calendar. It requires no preparation and is recorded remotely, so you don’t have to go anywhere.</p>

<p>Thanks again, I owe you.<br>Sean Martin</p>

<h3>Instructions for Beta Testing:</h3>
<ul>
    <li>Download the app by clicking this link:
        <a href="https://clearly.legal/app-download" target="_blank">https://clearly.legal/app-download</a>, or try searching for “CLEarly Legal” in the app store.
    </li>
    <li>Use this 100% off promo code at registration: <strong>CLE100</strong>.</li>
    <li>Register yourself:
        <ul>
            <li><strong>iPhone users:</strong> Please register from the web at
                <a href="https://app.clearly.legal" target="_blank">https://app.clearly.legal</a> or follow the on-screen steps on the iPhone.
            </li>
            <li><strong>Android users:</strong> You can complete the registration process within the app itself.</li>
        </ul>
    </li>
    <li>Once registered, select and listen to the podcasts.</li>
    <li>The trial period will expire after 14 days. You will be entitled to 50% off after filling out the feedback form.</li>
</ul>

<p>We are eagerly awaiting your feedback here:
    <a href="https://docs.google.com/forms/d/1aZil1wjYHdn-qMINLE55wVPlIonhRDRLS9Hq2jMIw3U/viewform?ts=66c8b7fb&edit_requested=true" target="_blank">Google Feedback Form</a>.
</p>
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
