@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot

<p>Dear <strong>{{ $name }}</strong>,</p>

<p>I hope this message finds you well. I wanted to send a quick reminder about the CLEarly Legal beta testing program. We haven’t received your registration yet, and we would love to have your valuable feedback as we continue to refine the app.</p>

<p>If you’ve already registered, feel free to ignore this message. If not, we’d still greatly appreciate your help, and it won’t take much of your time. You may even be entitled to CLE credit for your participation.</p>

<h3>Instructions for Beta Testing:</h3>
<ul>
    <li>Download the app by clicking this link:
        <a href="https://clearly.legal/app-download" target="_blank">https://clearly.legal/app-download</a>, or try searching for “CLEarly Legal” in the app store.
    </li>
    <li>Use this 100% off promo code at registration: <strong>CLE100</strong>.</li>
    <li>Register yourself:
        <ul>
            <li><strong>iPhone users:</strong> Please register from the web at
                <a href="https://app.clearly.legal" target="_blank">https://app.clearly.legal</a> or follow the on-screen steps on the iPhone.
            </li>
            <li><strong>Android users:</strong> You can complete the registration process within the app itself.</li>
        </ul>
    </li>
    <li>Once registered, select and listen to the podcasts.</li>
</ul>
<p>The trial period will expire after 14 days. You will be entitled to 50% off after filling out the feedback form.</p>
<p>We are eagerly awaiting your feedback here:
    <a href="https://docs.google.com/forms/d/1aZil1wjYHdn-qMINLE55wVPlIonhRDRLS9Hq2jMIw3U/viewform?ts=66c8b7fb&edit_requested=true" target="_blank">Google Feedback Form</a>.
</p>

<p>Thank you again for your support. It means a lot, and your feedback will help us deliver the best possible CLE experience!</p>

<p>Best regards,<br>Sean Martin</p>

{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
